rule win_astralocker_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2026-01-05"
        version = "1"
        description = "Detects win.astralocker."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.astralocker"
        malpedia_rule_date = "20260105"
        malpedia_hash = "19b79e7cab4eaf532122e5b45a77dd8f6bb5cc79"
        malpedia_version = "20251219"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 33d2 33f6 891401 89740104 b808000000 6bc800 8b5508 }
            // n = 7, score = 500
            //   33d2                 | xor                 edx, edx
            //   33f6                 | xor                 esi, esi
            //   891401               | mov                 dword ptr [ecx + eax], edx
            //   89740104             | mov                 dword ptr [ecx + eax + 4], esi
            //   b808000000           | mov                 eax, 8
            //   6bc800               | imul                ecx, eax, 0
            //   8b5508               | mov                 edx, dword ptr [ebp + 8]

        $sequence_1 = { 51 8b14d0 52 e8???????? 83c408 8945f4 8955f8 }
            // n = 7, score = 500
            //   51                   | push                ecx
            //   8b14d0               | mov                 edx, dword ptr [eax + edx*8]
            //   52                   | push                edx
            //   e8????????           |                     
            //   83c408               | add                 esp, 8
            //   8945f4               | mov                 dword ptr [ebp - 0xc], eax
            //   8955f8               | mov                 dword ptr [ebp - 8], edx

        $sequence_2 = { 891401 89740104 b808000000 6bc800 }
            // n = 4, score = 500
            //   891401               | mov                 dword ptr [ecx + eax], edx
            //   89740104             | mov                 dword ptr [ecx + eax + 4], esi
            //   b808000000           | mov                 eax, 8
            //   6bc800               | imul                ecx, eax, 0

        $sequence_3 = { 891401 89740104 b808000000 6bc800 8b5508 8b440a04 }
            // n = 6, score = 500
            //   891401               | mov                 dword ptr [ecx + eax], edx
            //   89740104             | mov                 dword ptr [ecx + eax + 4], esi
            //   b808000000           | mov                 eax, 8
            //   6bc800               | imul                ecx, eax, 0
            //   8b5508               | mov                 edx, dword ptr [ebp + 8]
            //   8b440a04             | mov                 eax, dword ptr [edx + ecx + 4]

        $sequence_4 = { 8955f0 ba08000000 6bf200 8b45ec }
            // n = 4, score = 500
            //   8955f0               | mov                 dword ptr [ebp - 0x10], edx
            //   ba08000000           | mov                 edx, 8
            //   6bf200               | imul                esi, edx, 0
            //   8b45ec               | mov                 eax, dword ptr [ebp - 0x14]

        $sequence_5 = { ba08000000 6bf200 8b45ec 8b55f0 b11a }
            // n = 5, score = 500
            //   ba08000000           | mov                 edx, 8
            //   6bf200               | imul                esi, edx, 0
            //   8b45ec               | mov                 eax, dword ptr [ebp - 0x14]
            //   8b55f0               | mov                 edx, dword ptr [ebp - 0x10]
            //   b11a                 | mov                 cl, 0x1a

        $sequence_6 = { 6bc80a 8b5508 33c0 33f6 89040a }
            // n = 5, score = 500
            //   6bc80a               | imul                ecx, eax, 0xa
            //   8b5508               | mov                 edx, dword ptr [ebp + 8]
            //   33c0                 | xor                 eax, eax
            //   33f6                 | xor                 esi, esi
            //   89040a               | mov                 dword ptr [edx + ecx], eax

        $sequence_7 = { 6bc20a 8b4d08 33d2 33f6 891401 89740104 }
            // n = 6, score = 500
            //   6bc20a               | imul                eax, edx, 0xa
            //   8b4d08               | mov                 ecx, dword ptr [ebp + 8]
            //   33d2                 | xor                 edx, edx
            //   33f6                 | xor                 esi, esi
            //   891401               | mov                 dword ptr [ecx + eax], edx
            //   89740104             | mov                 dword ptr [ecx + eax + 4], esi

        $sequence_8 = { 8b5508 8b440a04 50 8b0c0a 51 e8???????? }
            // n = 6, score = 500
            //   8b5508               | mov                 edx, dword ptr [ebp + 8]
            //   8b440a04             | mov                 eax, dword ptr [edx + ecx + 4]
            //   50                   | push                eax
            //   8b0c0a               | mov                 ecx, dword ptr [edx + ecx]
            //   51                   | push                ecx
            //   e8????????           |                     

        $sequence_9 = { 8b4508 8b4cd004 51 8b14d0 52 e8???????? 83c408 }
            // n = 7, score = 500
            //   8b4508               | mov                 eax, dword ptr [ebp + 8]
            //   8b4cd004             | mov                 ecx, dword ptr [eax + edx*8 + 4]
            //   51                   | push                ecx
            //   8b14d0               | mov                 edx, dword ptr [eax + edx*8]
            //   52                   | push                edx
            //   e8????????           |                     
            //   83c408               | add                 esp, 8

    condition:
        7 of them and filesize < 191488
}