rule win_atharvan_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2026-01-05"
        version = "1"
        description = "Detects win.atharvan."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.atharvan"
        malpedia_rule_date = "20260105"
        malpedia_hash = "19b79e7cab4eaf532122e5b45a77dd8f6bb5cc79"
        malpedia_version = "20251219"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { f6d1 80c103 8848ff 4883ea01 75eb 448b8504010000 488bd5 }
            // n = 7, score = 100
            //   f6d1                 | mov                 byte ptr [ecx + esi*8 + 0x3e], al
            //   80c103               | dec                 eax
            //   8848ff               | arpl                dx, ax
            //   4883ea01             | dec                 ecx
            //   75eb                 | cmp                 eax, eax
            //   448b8504010000       | jl                  0xa
            //   488bd5               | dec                 edx

        $sequence_1 = { 4885c0 7441 48c7c1ffffffff 0f1f4000 48ffc1 803c0800 }
            // n = 6, score = 100
            //   4885c0               | dec                 ebp
            //   7441                 | mov                 edi, eax
            //   48c7c1ffffffff       | dec                 esp
            //   0f1f4000             | mov                 dword ptr [esp + 0x40], eax
            //   48ffc1               | dec                 eax
            //   803c0800             | mov                 esi, edx

        $sequence_2 = { 895128 488d0d9fc10000 488b45d8 488908 488d0d915b0100 488b45d8 }
            // n = 6, score = 100
            //   895128               | xor                 ecx, esp
            //   488d0d9fc10000       | dec                 eax
            //   488b45d8             | add                 esp, 0x70
            //   488908               | pop                 edi
            //   488d0d915b0100       | pop                 esi
            //   488b45d8             | dec                 eax

        $sequence_3 = { 0fb601 84c0 75f1 488d4c2468 b0c2 }
            // n = 5, score = 100
            //   0fb601               | mov                 ecx, dword ptr [esp + 0x50]
            //   84c0                 | jne                 0x4bb
            //   75f1                 | mov                 edx, 2
            //   488d4c2468           | dec                 ecx
            //   b0c2                 | mov                 ecx, esi

        $sequence_4 = { 48c1f806 4c8d0504f50000 83e23f 488d14d2 498b04c0 f644d03801 7424 }
            // n = 7, score = 100
            //   48c1f806             | lea                 edi, [0x1373f]
            //   4c8d0504f50000       | dec                 eax
            //   83e23f               | and                 dword ptr [esp + 0x80], 0
            //   488d14d2             | inc                 ebp
            //   498b04c0             | test                dh, dh
            //   f644d03801           | jmp                 0xed1
            //   7424                 | dec                 esp

        $sequence_5 = { ff15???????? 85c0 0f842f010000 b901001000 }
            // n = 4, score = 100
            //   ff15????????         |                     
            //   85c0                 | and                 ecx, 0x3f
            //   0f842f010000         | jae                 0x13f8
            //   b901001000           | dec                 eax

        $sequence_6 = { 488b08 488d05b8330100 483901 7408 488b09 e8???????? 488b03 }
            // n = 7, score = 100
            //   488b08               | inc                 ecx
            //   488d05b8330100       | sub                 eax, ecx
            //   483901               | dec                 eax
            //   7408                 | mov                 edx, 0xfffffff0
            //   488b09               | dec                 esp
            //   e8????????           |                     
            //   488b03               | arpl                ax, cx

        $sequence_7 = { ff15???????? 488bd8 4883f8ff 742b 448d460e 488bc8 }
            // n = 6, score = 100
            //   ff15????????         |                     
            //   488bd8               | dec                 esp
            //   4883f8ff             | lea                 eax, [esp + 0x24]
            //   742b                 | mov                 edx, 0x104
            //   448d460e             | dec                 eax
            //   488bc8               | lea                 ecx, [ecx + 1]

        $sequence_8 = { 4533d2 498bd2 4885ff 7e1f 4c8d05179dfeff 4b8b8ce070550200 }
            // n = 6, score = 100
            //   4533d2               | dec                 eax
            //   498bd2               | xor                 ecx, esp
            //   4885ff               | dec                 eax
            //   7e1f                 | add                 esp, 0x4f0
            //   4c8d05179dfeff       | dec                 esp
            //   4b8b8ce070550200     | mov                 esi, dword ptr [esp + 0x90]

        $sequence_9 = { 458be0 c7442469cf968ed8 4c8bea c744246d8dc8c4cf }
            // n = 4, score = 100
            //   458be0               | cmp                 eax, -1
            //   c7442469cf968ed8     | inc                 ecx
            //   4c8bea               | mov                 edi, edi
            //   c744246d8dc8c4cf     | test                ebx, ebx

    condition:
        7 of them and filesize < 348160
}