rule win_ati_agent_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2026-01-05"
        version = "1"
        description = "Detects win.ati_agent."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.ati_agent"
        malpedia_rule_date = "20260105"
        malpedia_hash = "19b79e7cab4eaf532122e5b45a77dd8f6bb5cc79"
        malpedia_version = "20251219"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 4885c0 7404 f0440108 488d4158 41b806000000 488d1532cf0000 }
            // n = 6, score = 100
            //   4885c0               | mov                 ebx, eax
            //   7404                 | dec                 ecx
            //   f0440108             | sar                 esp, 5
            //   488d4158             | dec                 esp
            //   41b806000000         | lea                 esi, [0xe172]
            //   488d1532cf0000       | and                 ebx, 0x1f

        $sequence_1 = { c3 48895c2408 4889742410 57 4883ec70 8bf2 }
            // n = 6, score = 100
            //   c3                   | cmp                 dword ptr [eax - 0x10], edx
            //   48895c2408           | je                  0x378
            //   4889742410           | dec                 eax
            //   57                   | mov                 edx, dword ptr [eax]
            //   4883ec70             | dec                 eax
            //   8bf2                 | lea                 eax, [ecx + 0x58]

        $sequence_2 = { 48895c2408 57 4883ec20 488d1d67870000 }
            // n = 4, score = 100
            //   48895c2408           | mov                 esp, ebx
            //   57                   | dec                 ecx
            //   4883ec20             | sar                 esp, 5
            //   488d1d67870000       | dec                 esp

        $sequence_3 = { 488d4158 41b806000000 488d1594c50000 483950f0 740b }
            // n = 5, score = 100
            //   488d4158             | dec                 eax
            //   41b806000000         | mov                 eax, edx
            //   488d1594c50000       | jae                 0x589
            //   483950f0             | dec                 eax
            //   740b                 | arpl                cx, bx

        $sequence_4 = { 4883ec40 488b05???????? 4833c4 4889442438 498bf0 488bfa }
            // n = 6, score = 100
            //   4883ec40             | dec                 eax
            //   488b05????????       |                     
            //   4833c4               | cmp                 ecx, 0xe
            //   4889442438           | dec                 eax
            //   498bf0               | dec                 esi
            //   488bfa               | jne                 0xb7d

        $sequence_5 = { 7d16 4863cf 8a84191d010000 42888401e0e80000 ffc7 ebde }
            // n = 6, score = 100
            //   7d16                 | dec                 esp
            //   4863cf               | lea                 ecx, [0xffff8662]
            //   8a84191d010000       | dec                 ecx
            //   42888401e0e80000     | mov                 ecx, ecx
            //   ffc7                 | test                eax, eax
            //   ebde                 | dec                 eax

        $sequence_6 = { 4c8bef 49c1fd05 4c8d3528e20000 83e31f 486bdb58 }
            // n = 5, score = 100
            //   4c8bef               | inc                 ebp
            //   49c1fd05             | xor                 eax, eax
            //   4c8d3528e20000       | dec                 eax
            //   83e31f               | mov                 dword ptr [esp + 0x7d0], ebx
            //   486bdb58             | mov                 dword ptr [esp + 0x50], 0x618

        $sequence_7 = { e8???????? 4883c448 c3 4053 4883ec40 8bd9 }
            // n = 6, score = 100
            //   e8????????           |                     
            //   4883c448             | inc                 ebp
            //   c3                   | xor                 eax, eax
            //   4053                 | xor                 edx, edx
            //   4883ec40             | dec                 eax
            //   8bd9                 | mov                 dword ptr [esp + 0x520], ebx

        $sequence_8 = { 48890d???????? c3 4883ec28 4c8bc1 }
            // n = 4, score = 100
            //   48890d????????       |                     
            //   c3                   | mov                 ecx, dword ptr [eax + ecx*8]
            //   4883ec28             | dec                 eax
            //   4c8bc1               | arpl                cx, cx

        $sequence_9 = { e8???????? b9ff000000 e8???????? 488bfb 4803ff 4c8d2df1790000 49837cfd0000 }
            // n = 7, score = 100
            //   e8????????           |                     
            //   b9ff000000           | dec                 eax
            //   e8????????           |                     
            //   488bfb               | mov                 eax, dword ptr [esp + 0x50]
            //   4803ff               | dec                 eax
            //   4c8d2df1790000       | lea                 ecx, [0xbf67]
            //   49837cfd0000         | jb                  0x1e6

    condition:
        7 of them and filesize < 172032
}