rule win_atlas_agent_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2026-01-05"
        version = "1"
        description = "Detects win.atlas_agent."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.atlas_agent"
        malpedia_rule_date = "20260105"
        malpedia_hash = "19b79e7cab4eaf532122e5b45a77dd8f6bb5cc79"
        malpedia_version = "20251219"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 0fb60c0a 83e13c c1f902 03c1 }
            // n = 4, score = 200
            //   0fb60c0a             | movzx               ecx, byte ptr [edx + ecx]
            //   83e13c               | and                 ecx, 0x3c
            //   c1f902               | sar                 ecx, 2
            //   03c1                 | add                 eax, ecx

        $sequence_1 = { 8bc1 99 b903000000 f7f9 c1e002 }
            // n = 5, score = 200
            //   8bc1                 | mov                 eax, ecx
            //   99                   | cdq                 
            //   b903000000           | mov                 ecx, 3
            //   f7f9                 | idiv                ecx
            //   c1e002               | shl                 eax, 2

        $sequence_2 = { 8a80c0ba0410 84c0 7f1f 8bce }
            // n = 4, score = 100
            //   8a80c0ba0410         | shl                 eax, 2
            //   84c0                 | mov                 dl, byte ptr [ebp - 0xd]
            //   7f1f                 | mov                 byte ptr [ebp - 0xf], dl
            //   8bce                 | movzx               eax, byte ptr [ebp - 0xf]

        $sequence_3 = { 8a55fe 8810 8d4508 50 }
            // n = 4, score = 100
            //   8a55fe               | lea                 ecx, [0x18135]
            //   8810                 | dec                 eax
            //   8d4508               | mov                 edi, ecx
            //   50                   | dec                 eax

        $sequence_4 = { 8a55f3 8855f1 0fb645f1 85c0 746c 68???????? 8d4dd8 }
            // n = 7, score = 100
            //   8a55f3               | lea                 edx, [0x1812b]
            //   8855f1               | push                edi
            //   0fb645f1             | dec                 eax
            //   85c0                 | sub                 esp, 0x20
            //   746c                 | mov                 ebx, edx
            //   68????????           |                     
            //   8d4dd8               | dec                 esp

        $sequence_5 = { 8a5de3 8b0495e0b50410 885c012e 8b0495e0b50410 }
            // n = 4, score = 100
            //   8a5de3               | dec                 eax
            //   8b0495e0b50410       | lea                 edx, [0x17f47]
            //   885c012e             | mov                 ecx, 0x16
            //   8b0495e0b50410       | push                edi

        $sequence_6 = { 57 4883ec20 8bfa 4c8d0d517f0100 }
            // n = 4, score = 100
            //   57                   | mov                 esi, edx
            //   4883ec20             | push                edi
            //   8bfa                 | dec                 eax
            //   4c8d0d517f0100       | sub                 esp, 0x20

        $sequence_7 = { 57 4883ec20 488d1daf180300 488d3da8180300 eb12 488b03 }
            // n = 6, score = 100
            //   57                   | push                edi
            //   4883ec20             | dec                 eax
            //   488d1daf180300       | sub                 esp, 0x20
            //   488d3da8180300       | dec                 eax
            //   eb12                 | lea                 ebx, [0x318af]
            //   488b03               | dec                 eax

        $sequence_8 = { 57 4883ec20 8bda 4c8d0d35810100 }
            // n = 4, score = 100
            //   57                   | dec                 eax
            //   4883ec20             | test                eax, eax
            //   8bda                 | push                edi
            //   4c8d0d35810100       | dec                 eax

        $sequence_9 = { 57 4883ec20 8bf9 e8???????? 4885c0 7509 488d0533ed0200 }
            // n = 7, score = 100
            //   57                   | mov                 ebx, edx
            //   4883ec20             | dec                 eax
            //   8bf9                 | lea                 ebp, [0xfffd3757]
            //   e8????????           |                     
            //   4885c0               | inc                 ecx
            //   7509                 | and                 ebx, 0xf
            //   488d0533ed0200       | dec                 eax

        $sequence_10 = { 8a55ff 8810 8b45ec 83c001 }
            // n = 4, score = 100
            //   8a55ff               | dec                 esp
            //   8810                 | lea                 ecx, [0x17f51]
            //   8b45ec               | push                edi
            //   83c001               | dec                 eax

        $sequence_11 = { 57 4883ec20 4c8bda 488d2d5737fdff }
            // n = 4, score = 100
            //   57                   | lea                 edi, [0x318d4]
            //   4883ec20             | jmp                 0x26
            //   4c8bda               | push                edi
            //   488d2d5737fdff       | dec                 eax

        $sequence_12 = { 8a55ff 8811 8b45f4 50 e8???????? 83c404 8945f0 }
            // n = 7, score = 100
            //   8a55ff               | sub                 esp, 0x20
            //   8811                 | mov                 edi, edx
            //   8b45f4               | dec                 esp
            //   50                   | lea                 ecx, [0x17f51]
            //   e8????????           |                     
            //   83c404               | dec                 eax
            //   8945f0               | mov                 ebx, ecx

        $sequence_13 = { 57 4883ec20 488d1ddb180300 488d3dd4180300 }
            // n = 4, score = 100
            //   57                   | dec                 eax
            //   4883ec20             | lea                 ebx, [0x318af]
            //   488d1ddb180300       | dec                 eax
            //   488d3dd4180300       | lea                 edi, [0x318a8]

    condition:
        7 of them and filesize < 857088
}