rule win_atmitch_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2026-01-05"
        version = "1"
        description = "Detects win.atmitch."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.atmitch"
        malpedia_rule_date = "20260105"
        malpedia_hash = "19b79e7cab4eaf532122e5b45a77dd8f6bb5cc79"
        malpedia_version = "20251219"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 7407 8b542418 895004 837c242400 740c 8b442420 50 }
            // n = 7, score = 100
            //   7407                 | je                  9
            //   8b542418             | mov                 edx, dword ptr [esp + 0x18]
            //   895004               | mov                 dword ptr [eax + 4], edx
            //   837c242400           | cmp                 dword ptr [esp + 0x24], 0
            //   740c                 | je                  0xe
            //   8b442420             | mov                 eax, dword ptr [esp + 0x20]
            //   50                   | push                eax

        $sequence_1 = { ff15???????? 8d4c2414 ff15???????? 8d4c2410 ff15???????? }
            // n = 5, score = 100
            //   ff15????????         |                     
            //   8d4c2414             | lea                 ecx, [esp + 0x14]
            //   ff15????????         |                     
            //   8d4c2410             | lea                 ecx, [esp + 0x10]
            //   ff15????????         |                     

        $sequence_2 = { ff15???????? c744242000000000 833d????????02 7f05 e8???????? a1???????? }
            // n = 6, score = 100
            //   ff15????????         |                     
            //   c744242000000000     | mov                 dword ptr [esp + 0x20], 0
            //   833d????????02       |                     
            //   7f05                 | jg                  7
            //   e8????????           |                     
            //   a1????????           |                     

        $sequence_3 = { 8b4818 83c408 51 51 8bcc 8964241c }
            // n = 6, score = 100
            //   8b4818               | mov                 ecx, dword ptr [eax + 0x18]
            //   83c408               | add                 esp, 8
            //   51                   | push                ecx
            //   51                   | push                ecx
            //   8bcc                 | mov                 ecx, esp
            //   8964241c             | mov                 dword ptr [esp + 0x1c], esp

        $sequence_4 = { 50 680300020b ff15???????? 8d4c240e 51 51 8bcc }
            // n = 7, score = 100
            //   50                   | push                eax
            //   680300020b           | push                0xb020003
            //   ff15????????         |                     
            //   8d4c240e             | lea                 ecx, [esp + 0xe]
            //   51                   | push                ecx
            //   51                   | push                ecx
            //   8bcc                 | mov                 ecx, esp

        $sequence_5 = { c645fc01 8b06 8b4804 8b443110 25c0010000 }
            // n = 5, score = 100
            //   c645fc01             | mov                 byte ptr [ebp - 4], 1
            //   8b06                 | mov                 eax, dword ptr [esi]
            //   8b4804               | mov                 ecx, dword ptr [eax + 4]
            //   8b443110             | mov                 eax, dword ptr [ecx + esi + 0x10]
            //   25c0010000           | and                 eax, 0x1c0

        $sequence_6 = { 6aff 8d4c2414 ff15???????? 6a00 6a0a 8d4c2418 ff15???????? }
            // n = 7, score = 100
            //   6aff                 | push                -1
            //   8d4c2414             | lea                 ecx, [esp + 0x14]
            //   ff15????????         |                     
            //   6a00                 | push                0
            //   6a0a                 | push                0xa
            //   8d4c2418             | lea                 ecx, [esp + 0x18]
            //   ff15????????         |                     

        $sequence_7 = { 8bf8 83c404 33c9 33d2 33c0 6a11 }
            // n = 6, score = 100
            //   8bf8                 | mov                 edi, eax
            //   83c404               | add                 esp, 4
            //   33c9                 | xor                 ecx, ecx
            //   33d2                 | xor                 edx, edx
            //   33c0                 | xor                 eax, eax
            //   6a11                 | push                0x11

        $sequence_8 = { 8bcc 89642410 68???????? ff15???????? e8???????? 83c404 a1???????? }
            // n = 7, score = 100
            //   8bcc                 | mov                 ecx, esp
            //   89642410             | mov                 dword ptr [esp + 0x10], esp
            //   68????????           |                     
            //   ff15????????         |                     
            //   e8????????           |                     
            //   83c404               | add                 esp, 4
            //   a1????????           |                     

        $sequence_9 = { 8b0e 0fb7412c 83c408 83f809 774d ff2485f4200010 b8???????? }
            // n = 7, score = 100
            //   8b0e                 | mov                 ecx, dword ptr [esi]
            //   0fb7412c             | movzx               eax, word ptr [ecx + 0x2c]
            //   83c408               | add                 esp, 8
            //   83f809               | cmp                 eax, 9
            //   774d                 | ja                  0x4f
            //   ff2485f4200010       | jmp                 dword ptr [eax*4 + 0x100020f4]
            //   b8????????           |                     

    condition:
        7 of them and filesize < 73728
}