rule win_atomsilo_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2026-01-05"
        version = "1"
        description = "Detects win.atomsilo."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.atomsilo"
        malpedia_rule_date = "20260105"
        malpedia_hash = "19b79e7cab4eaf532122e5b45a77dd8f6bb5cc79"
        malpedia_version = "20251219"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 48c7c03f000000 23c1 488d0d7a8d0100 f20f5904c1 f20f5804c1 660f72e406 660f73f434 }
            // n = 7, score = 100
            //   48c7c03f000000       | cmp                 edx, 0x10
            //   23c1                 | dec                 eax
            //   488d0d7a8d0100       | cmovae              ebx, dword ptr [ebp + 7]
            //   f20f5904c1           | dec                 eax
            //   f20f5804c1           | add                 ebx, ecx
            //   660f72e406           | inc                 esp
            //   660f73f434           | lea                 eax, [esi + 1]

        $sequence_1 = { 90 488d4f78 488d542458 e8???????? 488bd8 488b4c2470 48394c2468 }
            // n = 7, score = 100
            //   90                   | lea                 eax, [ebp - 0x80]
            //   488d4f78             | mov                 edx, esi
            //   488d542458           | dec                 eax
            //   e8????????           |                     
            //   488bd8               | mov                 edi, dword ptr [esp + 0x48]
            //   488b4c2470           | mov                 edx, ebx
            //   48394c2468           | dec                 eax

        $sequence_2 = { 4053 4883ec20 488d054b400800 488bd9 488901 488d052e420800 48894108 }
            // n = 7, score = 100
            //   4053                 | xor                 esi, dword ptr [esp + 0x10]
            //   4883ec20             | inc                 ecx
            //   488d054b400800       | xor                 ebp, esp
            //   488bd9               | inc                 ecx
            //   488901               | xor                 esi, ebp
            //   488d052e420800       | inc                 ecx
            //   48894108             | ror                 ecx, 2

        $sequence_3 = { 480134c7 0f8593010000 ffc1 8bc1 493bc0 72ed 488b5318 }
            // n = 7, score = 100
            //   480134c7             | ror                 ebx, 2
            //   0f8593010000         | add                 ebx, 0x5a827999
            //   ffc1                 | inc                 ecx
            //   8bc1                 | mov                 eax, ecx
            //   493bc0               | rol                 eax, 5
            //   72ed                 | add                 eax, edx
            //   488b5318             | mov                 edx, dword ptr [edi + 0x28]

        $sequence_4 = { 48c7442458ffffffff 4c89742460 4d85f6 7505 498bef eb0b 498bce }
            // n = 7, score = 100
            //   48c7442458ffffffff     | dec    eax
            //   4c89742460           | lea                 edx, [ebp - 0x19]
            //   4d85f6               | dec                 eax
            //   7505                 | lea                 ecx, [ebp - 0x69]
            //   498bef               | dec                 esp
            //   eb0b                 | lea                 eax, [0x34fc8]
            //   498bce               | jmp                 0x9f6

        $sequence_5 = { 4183cf08 44897c2420 4c8d4c2458 4c8bc6 488d55b8 488d4d88 e8???????? }
            // n = 7, score = 100
            //   4183cf08             | rol                 esp, 1
            //   44897c2420           | add                 edi, 0x8f1bbcdc
            //   4c8d4c2458           | inc                 ecx
            //   4c8bc6               | rol                 edi, 1
            //   488d55b8             | inc                 ebp
            //   488d4d88             | xor                 esi, esp
            //   e8????????           |                     

        $sequence_6 = { 4103c7 c1ca02 448b7c2408 03c8 4403c9 4433ff }
            // n = 6, score = 100
            //   4103c7               | call                dword ptr [edi + 0x88]
            //   c1ca02               | inc                 esp
            //   448b7c2408           | mov                 eax, dword ptr [eax + 8]
            //   03c8                 | dec                 esp
            //   4403c9               | mov                 ecx, ebx
            //   4433ff               | dec                 eax

        $sequence_7 = { 8bc9 488b542430 8b0c8a c1e908 0fb6c9 488d1554b50500 }
            // n = 6, score = 100
            //   8bc9                 | lea                 eax, [0x293a3]
            //   488b542430           | dec                 eax
            //   8b0c8a               | lea                 edx, [ebp - 0x28]
            //   c1e908               | dec                 eax
            //   0fb6c9               | lea                 ecx, [ebp - 0x38]
            //   488d1554b50500       | mov                 eax, dword ptr [eax + 8]

        $sequence_8 = { 488d0dda730900 8b542440 83c202 8bd2 4c8b442430 418b1490 c1ea10 }
            // n = 7, score = 100
            //   488d0dda730900       | lea                 eax, [ebp - 0x29]
            //   8b542440             | dec                 eax
            //   83c202               | mov                 dword ptr [ebp - 9], eax
            //   8bd2                 | inc                 eax
            //   4c8b442430           | xor                 bh, bh
            //   418b1490             | dec                 eax
            //   c1ea10               | lea                 edx, [ebx + 0x10]

        $sequence_9 = { 488bd0 488bcb e8???????? 4103f5 413bf4 72c1 488b45a7 }
            // n = 7, score = 100
            //   488bd0               | mov                 eax, edi
            //   488bcb               | dec                 esp
            //   e8????????           |                     
            //   4103f5               | cmp                 eax, ebx
            //   413bf4               | jb                  0x664
            //   72c1                 | dec                 ecx
            //   488b45a7             | mov                 dword ptr [esp + ebx*8], ecx

    condition:
        7 of them and filesize < 1785856
}