rule win_aukill_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2026-01-05"
        version = "1"
        description = "Detects win.aukill."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.aukill"
        malpedia_rule_date = "20260105"
        malpedia_hash = "19b79e7cab4eaf532122e5b45a77dd8f6bb5cc79"
        malpedia_version = "20251219"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 33d2 b940040000 ff15???????? 488bd8 }
            // n = 4, score = 200
            //   33d2                 | lea                 ecx, [0xe247]
            //   b940040000           | dec                 ecx
            //   ff15????????         |                     
            //   488bd8               | mov                 edx, ecx

        $sequence_1 = { 488b442460 4c8d442430 488b4c2458 33d2 4889442434 }
            // n = 5, score = 200
            //   488b442460           | dec                 eax
            //   4c8d442430           | cmp                 dword ptr [eax + 0x138], edi
            //   488b4c2458           | dec                 eax
            //   33d2                 | lea                 edx, [0xdc44]
            //   4889442434           | dec                 eax

        $sequence_2 = { 48894c2430 ba04003583 894c2428 48894c2420 448d4920 48894c2450 488b0d???????? }
            // n = 7, score = 200
            //   48894c2430           | dec                 eax
            //   ba04003583           | lea                 ecx, [0x14990]
            //   894c2428             | inc                 ecx
            //   48894c2420           | and                 edx, 0x3f
            //   448d4920             | dec                 ecx
            //   48894c2450           | add                 ebp, eax
            //   488b0d????????       |                     

        $sequence_3 = { 771c 488b0b ff15???????? 0fb608 }
            // n = 4, score = 200
            //   771c                 | lea                 edx, [0x209a7]
            //   488b0b               | dec                 eax
            //   ff15????????         |                     
            //   0fb608               | lea                 ecx, [0x209b2]

        $sequence_4 = { 33c9 48895c2440 48894c2438 4c8d442440 48894c2430 ba04003583 }
            // n = 6, score = 200
            //   33c9                 | mov                 dword ptr [esp + 0x28], eax
            //   48895c2440           | dec                 eax
            //   48894c2438           | lea                 eax, [eax + 1]
            //   4c8d442440           | jne                 0x13ac
            //   48894c2430           | dec                 eax
            //   ba04003583           | mov                 ecx, dword ptr [esp + 0x50]

        $sequence_5 = { 488b442460 4c8d442430 488b4c2458 33d2 }
            // n = 4, score = 200
            //   488b442460           | cmp                 ecx, eax
            //   4c8d442430           | dec                 eax
            //   488b4c2458           | cmp                 ebx, eax
            //   33d2                 | jne                 0x68b

        $sequence_6 = { 48894c2420 448d4920 48894c2450 488b0d???????? }
            // n = 4, score = 200
            //   48894c2420           | lea                 eax, [0x2069f]
            //   448d4920             | inc                 ecx
            //   48894c2450           | mov                 edx, esp
            //   488b0d????????       |                     

        $sequence_7 = { 448d4920 48894c2450 488b0d???????? 48897c2458 4889442448 }
            // n = 5, score = 200
            //   448d4920             | lea                 edx, [0x2111f]
            //   48894c2450           | mov                 dword ptr [esp + 0x4c], 2
            //   488b0d????????       |                     
            //   48897c2458           | xor                 ecx, ecx
            //   4889442448           | mov                 dword ptr [esp + 0x40], ebx

        $sequence_8 = { ff15???????? 85c0 751d 488bcb ff15???????? ff15???????? }
            // n = 6, score = 200
            //   ff15????????         |                     
            //   85c0                 | jne                 0x7e4
            //   751d                 | dec                 eax
            //   488bcb               | mov                 eax, edi
            //   ff15????????         |                     
            //   ff15????????         |                     

        $sequence_9 = { 8905???????? c705????????02000000 48c705????????04000000 ff15???????? 488905???????? 4885c0 }
            // n = 6, score = 200
            //   8905????????         |                     
            //   c705????????02000000     |     
            //   48c705????????04000000     |     
            //   ff15????????         |                     
            //   488905????????       |                     
            //   4885c0               | inc                 eax

    condition:
        7 of them and filesize < 446464
}