rule win_aurastealer_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2026-01-05"
        version = "1"
        description = "Detects win.aurastealer."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.aurastealer"
        malpedia_rule_date = "20260105"
        malpedia_hash = "19b79e7cab4eaf532122e5b45a77dd8f6bb5cc79"
        malpedia_version = "20251219"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 09f8 894648 83c110 894e44 8b7e30 }
            // n = 5, score = 1500
            //   09f8                 | or                  eax, edi
            //   894648               | mov                 dword ptr [esi + 0x48], eax
            //   83c110               | add                 ecx, 0x10
            //   894e44               | mov                 dword ptr [esi + 0x44], ecx
            //   8b7e30               | mov                 edi, dword ptr [esi + 0x30]

        $sequence_1 = { 09f9 85d2 0f49c8 89f5 }
            // n = 4, score = 1500
            //   09f9                 | or                  ecx, edi
            //   85d2                 | test                edx, edx
            //   0f49c8               | cmovns              ecx, eax
            //   89f5                 | mov                 ebp, esi

        $sequence_2 = { 09fb 895e48 83c110 894e44 }
            // n = 4, score = 1500
            //   09fb                 | or                  ebx, edi
            //   895e48               | mov                 dword ptr [esi + 0x48], ebx
            //   83c110               | add                 ecx, 0x10
            //   894e44               | mov                 dword ptr [esi + 0x44], ecx

        $sequence_3 = { 09fb 8b0c24 0fb68c0e32900000 01d1 }
            // n = 4, score = 1500
            //   09fb                 | or                  ebx, edi
            //   8b0c24               | mov                 ecx, dword ptr [esp]
            //   0fb68c0e32900000     | movzx               ecx, byte ptr [esi + ecx + 0x9032]
            //   01d1                 | add                 ecx, edx

        $sequence_4 = { 0a1c24 751f 8b7920 8b3f }
            // n = 4, score = 1500
            //   0a1c24               | or                  bl, byte ptr [esp]
            //   751f                 | jne                 0x21
            //   8b7920               | mov                 edi, dword ptr [ecx + 0x20]
            //   8b3f                 | mov                 edi, dword ptr [edi]

        $sequence_5 = { 0a442404 89ee 7456 8b6c2410 }
            // n = 4, score = 1500
            //   0a442404             | or                  al, byte ptr [esp + 4]
            //   89ee                 | mov                 esi, ebp
            //   7456                 | je                  0x58
            //   8b6c2410             | mov                 ebp, dword ptr [esp + 0x10]

        $sequence_6 = { 09fa d1ea 89f7 83e601 }
            // n = 4, score = 1500
            //   09fa                 | or                  edx, edi
            //   d1ea                 | shr                 edx, 1
            //   89f7                 | mov                 edi, esi
            //   83e601               | and                 esi, 1

        $sequence_7 = { 0a4c2410 751c 6840df0400 6a01 }
            // n = 4, score = 1500
            //   0a4c2410             | or                  cl, byte ptr [esp + 0x10]
            //   751c                 | jne                 0x1e
            //   6840df0400           | push                0x4df40
            //   6a01                 | push                1

        $sequence_8 = { 01442428 8bf1 13d9 33d2 }
            // n = 4, score = 100
            //   01442428             | add                 dword ptr [esp + 0x28], eax
            //   8bf1                 | mov                 esi, ecx
            //   13d9                 | adc                 ebx, ecx
            //   33d2                 | xor                 edx, edx

        $sequence_9 = { 01442420 13d1 c1eb0b 0fa4c115 }
            // n = 4, score = 100
            //   01442420             | add                 dword ptr [esp + 0x20], eax
            //   13d1                 | adc                 edx, ecx
            //   c1eb0b               | shr                 ebx, 0xb
            //   0fa4c115             | shld                ecx, eax, 0x15

        $sequence_10 = { 012c18 42 3bd7 72dc }
            // n = 4, score = 100
            //   012c18               | add                 dword ptr [eax + ebx], ebp
            //   42                   | inc                 edx
            //   3bd7                 | cmp                 edx, edi
            //   72dc                 | jb                  0xffffffde

        $sequence_11 = { 014c241c 13f0 33d2 89742420 }
            // n = 4, score = 100
            //   014c241c             | add                 dword ptr [esp + 0x1c], ecx
            //   13f0                 | adc                 esi, eax
            //   33d2                 | xor                 edx, edx
            //   89742420             | mov                 dword ptr [esp + 0x20], esi

        $sequence_12 = { 014c2420 8be8 13f0 33ff }
            // n = 4, score = 100
            //   014c2420             | add                 dword ptr [esp + 0x20], ecx
            //   8be8                 | mov                 ebp, eax
            //   13f0                 | adc                 esi, eax
            //   33ff                 | xor                 edi, edi

        $sequence_13 = { 0144241c 8b7c2424 136c2414 33c0 }
            // n = 4, score = 100
            //   0144241c             | add                 dword ptr [esp + 0x1c], eax
            //   8b7c2424             | mov                 edi, dword ptr [esp + 0x24]
            //   136c2414             | adc                 ebp, dword ptr [esp + 0x14]
            //   33c0                 | xor                 eax, eax

        $sequence_14 = { 0128 42 3bd7 72db }
            // n = 4, score = 100
            //   0128                 | add                 dword ptr [eax], ebp
            //   42                   | inc                 edx
            //   3bd7                 | cmp                 edx, edi
            //   72db                 | jb                  0xffffffdd

        $sequence_15 = { 0002 8a0c0f 83c40c 020e }
            // n = 4, score = 100
            //   0002                 | add                 byte ptr [edx], al
            //   8a0c0f               | mov                 cl, byte ptr [edi + ecx]
            //   83c40c               | add                 esp, 0xc
            //   020e                 | add                 cl, byte ptr [esi]

    condition:
        7 of them and filesize < 1918976
}