rule win_auriga_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2026-01-05"
        version = "1"
        description = "Detects win.auriga."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.auriga"
        malpedia_rule_date = "20260105"
        malpedia_hash = "19b79e7cab4eaf532122e5b45a77dd8f6bb5cc79"
        malpedia_version = "20251219"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 59 59 8945fc 897df8 763a }
            // n = 5, score = 100
            //   59                   | pop                 ecx
            //   59                   | pop                 ecx
            //   8945fc               | mov                 dword ptr [ebp - 4], eax
            //   897df8               | mov                 dword ptr [ebp - 8], edi
            //   763a                 | jbe                 0x3c

        $sequence_1 = { 83c10c 894df4 8b11 3b15???????? 755b 8bd0 2b55fc }
            // n = 7, score = 100
            //   83c10c               | add                 ecx, 0xc
            //   894df4               | mov                 dword ptr [ebp - 0xc], ecx
            //   8b11                 | mov                 edx, dword ptr [ecx]
            //   3b15????????         |                     
            //   755b                 | jne                 0x5d
            //   8bd0                 | mov                 edx, eax
            //   2b55fc               | sub                 edx, dword ptr [ebp - 4]

        $sequence_2 = { ffd7 33c0 8985c0fbffff 8985ccfbffff 8985d0fbffff 8d85bcfbffff }
            // n = 6, score = 100
            //   ffd7                 | call                edi
            //   33c0                 | xor                 eax, eax
            //   8985c0fbffff         | mov                 dword ptr [ebp - 0x440], eax
            //   8985ccfbffff         | mov                 dword ptr [ebp - 0x434], eax
            //   8985d0fbffff         | mov                 dword ptr [ebp - 0x430], eax
            //   8d85bcfbffff         | lea                 eax, [ebp - 0x444]

        $sequence_3 = { 33c0 83c40c 8d7dec ab ab 33c0 6a20 }
            // n = 7, score = 100
            //   33c0                 | xor                 eax, eax
            //   83c40c               | add                 esp, 0xc
            //   8d7dec               | lea                 edi, [ebp - 0x14]
            //   ab                   | stosd               dword ptr es:[edi], eax
            //   ab                   | stosd               dword ptr es:[edi], eax
            //   33c0                 | xor                 eax, eax
            //   6a20                 | push                0x20

        $sequence_4 = { 59 648b01 8b400c 8b701c ad 8b4008 }
            // n = 6, score = 100
            //   59                   | pop                 ecx
            //   648b01               | mov                 eax, dword ptr fs:[ecx]
            //   8b400c               | mov                 eax, dword ptr [eax + 0xc]
            //   8b701c               | mov                 esi, dword ptr [eax + 0x1c]
            //   ad                   | lodsd               eax, dword ptr [esi]
            //   8b4008               | mov                 eax, dword ptr [eax + 8]

        $sequence_5 = { 742d 8b430c 8b580c 53 ffd7 84c0 7420 }
            // n = 7, score = 100
            //   742d                 | je                  0x2f
            //   8b430c               | mov                 eax, dword ptr [ebx + 0xc]
            //   8b580c               | mov                 ebx, dword ptr [eax + 0xc]
            //   53                   | push                ebx
            //   ffd7                 | call                edi
            //   84c0                 | test                al, al
            //   7420                 | je                  0x22

        $sequence_6 = { 8b0d???????? 03c1 3900 74f0 8b15???????? 56 }
            // n = 6, score = 100
            //   8b0d????????         |                     
            //   03c1                 | add                 eax, ecx
            //   3900                 | cmp                 dword ptr [eax], eax
            //   74f0                 | je                  0xfffffff2
            //   8b15????????         |                     
            //   56                   | push                esi

        $sequence_7 = { 59 59 8945fc 897df8 763a 8b45e8 03c7 }
            // n = 7, score = 100
            //   59                   | pop                 ecx
            //   59                   | pop                 ecx
            //   8945fc               | mov                 dword ptr [ebp - 4], eax
            //   897df8               | mov                 dword ptr [ebp - 8], edi
            //   763a                 | jbe                 0x3c
            //   8b45e8               | mov                 eax, dword ptr [ebp - 0x18]
            //   03c7                 | add                 eax, edi

        $sequence_8 = { 0f8ce7010000 8d85e8f9ffff 50 8d85e0f9ffff }
            // n = 4, score = 100
            //   0f8ce7010000         | jl                  0x1ed
            //   8d85e8f9ffff         | lea                 eax, [ebp - 0x618]
            //   50                   | push                eax
            //   8d85e0f9ffff         | lea                 eax, [ebp - 0x620]

        $sequence_9 = { 8945e8 a1???????? 8b1c30 8bfb 8d45f0 8d5001 8a08 }
            // n = 7, score = 100
            //   8945e8               | mov                 dword ptr [ebp - 0x18], eax
            //   a1????????           |                     
            //   8b1c30               | mov                 ebx, dword ptr [eax + esi]
            //   8bfb                 | mov                 edi, ebx
            //   8d45f0               | lea                 eax, [ebp - 0x10]
            //   8d5001               | lea                 edx, [eax + 1]
            //   8a08                 | mov                 cl, byte ptr [eax]

    condition:
        7 of them and filesize < 75776
}