rule win_aurora_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2026-01-05"
        version = "1"
        description = "Detects win.aurora."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.aurora"
        malpedia_rule_date = "20260105"
        malpedia_hash = "19b79e7cab4eaf532122e5b45a77dd8f6bb5cc79"
        malpedia_version = "20251219"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 52 8d4dc0 e8???????? 68???????? c645fc01 e8???????? }
            // n = 6, score = 300
            //   52                   | push                edx
            //   8d4dc0               | lea                 ecx, [ebp - 0x40]
            //   e8????????           |                     
            //   68????????           |                     
            //   c645fc01             | mov                 byte ptr [ebp - 4], 1
            //   e8????????           |                     

        $sequence_1 = { 6a1f 68???????? c745d40f000000 c745d000000000 c645c000 e8???????? c645fc01 }
            // n = 7, score = 300
            //   6a1f                 | push                0x1f
            //   68????????           |                     
            //   c745d40f000000       | mov                 dword ptr [ebp - 0x2c], 0xf
            //   c745d000000000       | mov                 dword ptr [ebp - 0x30], 0
            //   c645c000             | mov                 byte ptr [ebp - 0x40], 0
            //   e8????????           |                     
            //   c645fc01             | mov                 byte ptr [ebp - 4], 1

        $sequence_2 = { 0f8259ffffff 8d4de4 e8???????? 8bc6 8b4df4 64890d00000000 59 }
            // n = 7, score = 300
            //   0f8259ffffff         | jb                  0xffffff5f
            //   8d4de4               | lea                 ecx, [ebp - 0x1c]
            //   e8????????           |                     
            //   8bc6                 | mov                 eax, esi
            //   8b4df4               | mov                 ecx, dword ptr [ebp - 0xc]
            //   64890d00000000       | mov                 dword ptr fs:[0], ecx
            //   59                   | pop                 ecx

        $sequence_3 = { 75f9 2bca 51 53 8d4dd0 e8???????? }
            // n = 6, score = 300
            //   75f9                 | jne                 0xfffffffb
            //   2bca                 | sub                 ecx, edx
            //   51                   | push                ecx
            //   53                   | push                ebx
            //   8d4dd0               | lea                 ecx, [ebp - 0x30]
            //   e8????????           |                     

        $sequence_4 = { 0f45c2 50 e8???????? 8bfb }
            // n = 4, score = 300
            //   0f45c2               | cmovne              eax, edx
            //   50                   | push                eax
            //   e8????????           |                     
            //   8bfb                 | mov                 edi, ebx

        $sequence_5 = { 68???????? 8d8de4f1ffff c785f8f1ffff0f000000 c785f4f1ffff00000000 c685e4f1ffff00 e8???????? }
            // n = 6, score = 300
            //   68????????           |                     
            //   8d8de4f1ffff         | lea                 ecx, [ebp - 0xe1c]
            //   c785f8f1ffff0f000000     | mov    dword ptr [ebp - 0xe08], 0xf
            //   c785f4f1ffff00000000     | mov    dword ptr [ebp - 0xe0c], 0
            //   c685e4f1ffff00       | mov                 byte ptr [ebp - 0xe1c], 0
            //   e8????????           |                     

        $sequence_6 = { c785b8efffff0f000000 c785b4efffff00000000 c685a4efffff00 e8???????? 8d8dbcefffff }
            // n = 5, score = 300
            //   c785b8efffff0f000000     | mov    dword ptr [ebp - 0x1048], 0xf
            //   c785b4efffff00000000     | mov    dword ptr [ebp - 0x104c], 0
            //   c685a4efffff00       | mov                 byte ptr [ebp - 0x105c], 0
            //   e8????????           |                     
            //   8d8dbcefffff         | lea                 ecx, [ebp - 0x1044]

        $sequence_7 = { 0f8483000000 c1e706 03f8 83c106 894ddc 7869 8bc7 }
            // n = 7, score = 300
            //   0f8483000000         | je                  0x89
            //   c1e706               | shl                 edi, 6
            //   03f8                 | add                 edi, eax
            //   83c106               | add                 ecx, 6
            //   894ddc               | mov                 dword ptr [ebp - 0x24], ecx
            //   7869                 | js                  0x6b
            //   8bc7                 | mov                 eax, edi

        $sequence_8 = { 68???????? 8d8d24f1ffff c78538f1ffff0f000000 c78534f1ffff00000000 }
            // n = 4, score = 300
            //   68????????           |                     
            //   8d8d24f1ffff         | lea                 ecx, [ebp - 0xedc]
            //   c78538f1ffff0f000000     | mov    dword ptr [ebp - 0xec8], 0xf
            //   c78534f1ffff00000000     | mov    dword ptr [ebp - 0xecc], 0

        $sequence_9 = { a1???????? 33c5 50 8d45f4 64a300000000 c745ec00000000 83ec18 }
            // n = 7, score = 300
            //   a1????????           |                     
            //   33c5                 | xor                 eax, ebp
            //   50                   | push                eax
            //   8d45f4               | lea                 eax, [ebp - 0xc]
            //   64a300000000         | mov                 dword ptr fs:[0], eax
            //   c745ec00000000       | mov                 dword ptr [ebp - 0x14], 0
            //   83ec18               | sub                 esp, 0x18

    condition:
        7 of them and filesize < 827392
}