rule win_avast_disabler_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2026-01-05"
        version = "1"
        description = "Detects win.avast_disabler."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.avast_disabler"
        malpedia_rule_date = "20260105"
        malpedia_hash = "19b79e7cab4eaf532122e5b45a77dd8f6bb5cc79"
        malpedia_version = "20251219"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 50 8d85f0feffff 50 e8???????? 8b4c371c }
            // n = 5, score = 100
            //   50                   | push                eax
            //   8d85f0feffff         | lea                 eax, [ebp - 0x110]
            //   50                   | push                eax
            //   e8????????           |                     
            //   8b4c371c             | mov                 ecx, dword ptr [edi + esi + 0x1c]

        $sequence_1 = { c20c00 3b0d???????? 7503 c20000 e9???????? 8bff }
            // n = 6, score = 100
            //   c20c00               | ret                 0xc
            //   3b0d????????         |                     
            //   7503                 | jne                 5
            //   c20000               | ret                 0
            //   e9????????           |                     
            //   8bff                 | mov                 edi, edi

        $sequence_2 = { e8???????? 8b4c371c 8d85f0feffff 2b4c3718 }
            // n = 4, score = 100
            //   e8????????           |                     
            //   8b4c371c             | mov                 ecx, dword ptr [edi + esi + 0x1c]
            //   8d85f0feffff         | lea                 eax, [ebp - 0x110]
            //   2b4c3718             | sub                 ecx, dword ptr [edi + esi + 0x18]

        $sequence_3 = { 8bf0 85f6 7815 8d45f8 50 e8???????? 8bf0 }
            // n = 7, score = 100
            //   8bf0                 | mov                 esi, eax
            //   85f6                 | test                esi, esi
            //   7815                 | js                  0x17
            //   8d45f8               | lea                 eax, [ebp - 8]
            //   50                   | push                eax
            //   e8????????           |                     
            //   8bf0                 | mov                 esi, eax

        $sequence_4 = { 41 83ef01 75f1 8b85ecfeffff 33c9 0fb7d0 33c0 }
            // n = 7, score = 100
            //   41                   | inc                 ecx
            //   83ef01               | sub                 edi, 1
            //   75f1                 | jne                 0xfffffff3
            //   8b85ecfeffff         | mov                 eax, dword ptr [ebp - 0x114]
            //   33c9                 | xor                 ecx, ecx
            //   0fb7d0               | movzx               edx, ax
            //   33c0                 | xor                 eax, eax

        $sequence_5 = { 57 8945e4 33ff 8d45dc }
            // n = 4, score = 100
            //   57                   | push                edi
            //   8945e4               | mov                 dword ptr [ebp - 0x1c], eax
            //   33ff                 | xor                 edi, edi
            //   8d45dc               | lea                 eax, [ebp - 0x24]

        $sequence_6 = { 8bf0 85f6 7826 6a04 59 }
            // n = 5, score = 100
            //   8bf0                 | mov                 esi, eax
            //   85f6                 | test                esi, esi
            //   7826                 | js                  0x28
            //   6a04                 | push                4
            //   59                   | pop                 ecx

        $sequence_7 = { 6a00 ff7508 8bf0 57 }
            // n = 4, score = 100
            //   6a00                 | push                0
            //   ff7508               | push                dword ptr [ebp + 8]
            //   8bf0                 | mov                 esi, eax
            //   57                   | push                edi

        $sequence_8 = { 6bf80e 668b450c 6639443712 7408 }
            // n = 4, score = 100
            //   6bf80e               | imul                edi, eax, 0xe
            //   668b450c             | mov                 ax, word ptr [ebp + 0xc]
            //   6639443712           | cmp                 word ptr [edi + esi + 0x12], ax
            //   7408                 | je                  0xa

        $sequence_9 = { 6a00 ff7508 8bf0 57 e8???????? }
            // n = 5, score = 100
            //   6a00                 | push                0
            //   ff7508               | push                dword ptr [ebp + 8]
            //   8bf0                 | mov                 esi, eax
            //   57                   | push                edi
            //   e8????????           |                     

    condition:
        7 of them and filesize < 41984
}