rule win_avcrypt_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2026-01-05"
        version = "1"
        description = "Detects win.avcrypt."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.avcrypt"
        malpedia_rule_date = "20260105"
        malpedia_hash = "19b79e7cab4eaf532122e5b45a77dd8f6bb5cc79"
        malpedia_version = "20251219"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { e8???????? 83c40c 8d4dc0 e8???????? be???????? c745fc02000000 56 }
            // n = 7, score = 100
            //   e8????????           |                     
            //   83c40c               | add                 esp, 0xc
            //   8d4dc0               | lea                 ecx, [ebp - 0x40]
            //   e8????????           |                     
            //   be????????           |                     
            //   c745fc02000000       | mov                 dword ptr [ebp - 4], 2
            //   56                   | push                esi

        $sequence_1 = { 0fb7c8 b8ffff0000 663bc1 8b4dec 6a04 58 }
            // n = 6, score = 100
            //   0fb7c8               | movzx               ecx, ax
            //   b8ffff0000           | mov                 eax, 0xffff
            //   663bc1               | cmp                 ax, cx
            //   8b4dec               | mov                 ecx, dword ptr [ebp - 0x14]
            //   6a04                 | push                4
            //   58                   | pop                 eax

        $sequence_2 = { ddd8 db2d???????? b801000000 833d????????00 0f8516a20000 ba05000000 8d0d60974300 }
            // n = 7, score = 100
            //   ddd8                 | fstp                st(0)
            //   db2d????????         |                     
            //   b801000000           | mov                 eax, 1
            //   833d????????00       |                     
            //   0f8516a20000         | jne                 0xa21c
            //   ba05000000           | mov                 edx, 5
            //   8d0d60974300         | lea                 ecx, [0x439760]

        $sequence_3 = { 8b00 837dec08 8d4dd8 8bd0 0f434dd8 }
            // n = 5, score = 100
            //   8b00                 | mov                 eax, dword ptr [eax]
            //   837dec08             | cmp                 dword ptr [ebp - 0x14], 8
            //   8d4dd8               | lea                 ecx, [ebp - 0x28]
            //   8bd0                 | mov                 edx, eax
            //   0f434dd8             | cmovae              ecx, dword ptr [ebp - 0x28]

        $sequence_4 = { e8???????? 59 8365fc00 8b049d80b54300 f644380401 7413 ff7510 }
            // n = 7, score = 100
            //   e8????????           |                     
            //   59                   | pop                 ecx
            //   8365fc00             | and                 dword ptr [ebp - 4], 0
            //   8b049d80b54300       | mov                 eax, dword ptr [ebx*4 + 0x43b580]
            //   f644380401           | test                byte ptr [eax + edi + 4], 1
            //   7413                 | je                  0x15
            //   ff7510               | push                dword ptr [ebp + 0x10]

        $sequence_5 = { 8ac3 e8???????? c3 68a4020000 b8???????? e8???????? 8bc2 }
            // n = 7, score = 100
            //   8ac3                 | mov                 al, bl
            //   e8????????           |                     
            //   c3                   | ret                 
            //   68a4020000           | push                0x2a4
            //   b8????????           |                     
            //   e8????????           |                     
            //   8bc2                 | mov                 eax, edx

        $sequence_6 = { 68???????? 6a18 6a18 50 e8???????? e8???????? }
            // n = 6, score = 100
            //   68????????           |                     
            //   6a18                 | push                0x18
            //   6a18                 | push                0x18
            //   50                   | push                eax
            //   e8????????           |                     
            //   e8????????           |                     

        $sequence_7 = { b44b 5a baa5c94fad 90 302c83 2d2171e50b }
            // n = 6, score = 100
            //   b44b                 | mov                 ah, 0x4b
            //   5a                   | pop                 edx
            //   baa5c94fad           | mov                 edx, 0xad4fc9a5
            //   90                   | nop                 
            //   302c83               | xor                 byte ptr [ebx + eax*4], ch
            //   2d2171e50b           | sub                 eax, 0xbe57121

        $sequence_8 = { 48 7412 e8???????? c70016000000 e8???????? ebb4 c745e440be4300 }
            // n = 7, score = 100
            //   48                   | dec                 eax
            //   7412                 | je                  0x14
            //   e8????????           |                     
            //   c70016000000         | mov                 dword ptr [eax], 0x16
            //   e8????????           |                     
            //   ebb4                 | jmp                 0xffffffb6
            //   c745e440be4300       | mov                 dword ptr [ebp - 0x1c], 0x43be40

        $sequence_9 = { 8965c8 68???????? e8???????? 83ec18 c645fc14 8bcc 68???????? }
            // n = 7, score = 100
            //   8965c8               | mov                 dword ptr [ebp - 0x38], esp
            //   68????????           |                     
            //   e8????????           |                     
            //   83ec18               | sub                 esp, 0x18
            //   c645fc14             | mov                 byte ptr [ebp - 4], 0x14
            //   8bcc                 | mov                 ecx, esp
            //   68????????           |                     

    condition:
        7 of them and filesize < 6160384
}