rule win_ave_maria_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2026-01-05"
        version = "1"
        description = "Detects win.ave_maria."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.ave_maria"
        malpedia_rule_date = "20260105"
        malpedia_hash = "19b79e7cab4eaf532122e5b45a77dd8f6bb5cc79"
        malpedia_version = "20251219"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { ff15???????? 33c9 85c0 0f94c1 8bc1 c3 }
            // n = 6, score = 400
            //   ff15????????         |                     
            //   33c9                 | xor                 ecx, ecx
            //   85c0                 | test                eax, eax
            //   0f94c1               | sete                cl
            //   8bc1                 | mov                 eax, ecx
            //   c3                   | ret                 

        $sequence_1 = { 8a5716 f6d2 80e201 5f 5e 8ac2 5b }
            // n = 7, score = 400
            //   8a5716               | mov                 dl, byte ptr [edi + 0x16]
            //   f6d2                 | not                 dl
            //   80e201               | and                 dl, 1
            //   5f                   | pop                 edi
            //   5e                   | pop                 esi
            //   8ac2                 | mov                 al, dl
            //   5b                   | pop                 ebx

        $sequence_2 = { 50 e8???????? 8b37 8bcf e8???????? 50 56 }
            // n = 7, score = 400
            //   50                   | push                eax
            //   e8????????           |                     
            //   8b37                 | mov                 esi, dword ptr [edi]
            //   8bcf                 | mov                 ecx, edi
            //   e8????????           |                     
            //   50                   | push                eax
            //   56                   | push                esi

        $sequence_3 = { e8???????? 8d4de8 e8???????? 8b4508 5e c9 c20400 }
            // n = 7, score = 400
            //   e8????????           |                     
            //   8d4de8               | lea                 ecx, [ebp - 0x18]
            //   e8????????           |                     
            //   8b4508               | mov                 eax, dword ptr [ebp + 8]
            //   5e                   | pop                 esi
            //   c9                   | leave               
            //   c20400               | ret                 4

        $sequence_4 = { 8bf0 ba???????? 51 8bce e8???????? ba???????? }
            // n = 6, score = 400
            //   8bf0                 | mov                 esi, eax
            //   ba????????           |                     
            //   51                   | push                ecx
            //   8bce                 | mov                 ecx, esi
            //   e8????????           |                     
            //   ba????????           |                     

        $sequence_5 = { 740a 8b45f0 8906 33c0 40 eb02 33c0 }
            // n = 7, score = 400
            //   740a                 | je                  0xc
            //   8b45f0               | mov                 eax, dword ptr [ebp - 0x10]
            //   8906                 | mov                 dword ptr [esi], eax
            //   33c0                 | xor                 eax, eax
            //   40                   | inc                 eax
            //   eb02                 | jmp                 4
            //   33c0                 | xor                 eax, eax

        $sequence_6 = { 56 8bf1 ff15???????? 8d8ed8010000 e8???????? 8d4e30 e8???????? }
            // n = 7, score = 400
            //   56                   | push                esi
            //   8bf1                 | mov                 esi, ecx
            //   ff15????????         |                     
            //   8d8ed8010000         | lea                 ecx, [esi + 0x1d8]
            //   e8????????           |                     
            //   8d4e30               | lea                 ecx, [esi + 0x30]
            //   e8????????           |                     

        $sequence_7 = { 0f84e0000000 51 ba???????? 8bc8 e8???????? 8b4e10 ba???????? }
            // n = 7, score = 400
            //   0f84e0000000         | je                  0xe6
            //   51                   | push                ecx
            //   ba????????           |                     
            //   8bc8                 | mov                 ecx, eax
            //   e8????????           |                     
            //   8b4e10               | mov                 ecx, dword ptr [esi + 0x10]
            //   ba????????           |                     

        $sequence_8 = { 8d44240c 56 57 8b7d08 6a00 ff7708 }
            // n = 6, score = 400
            //   8d44240c             | lea                 eax, [esp + 0xc]
            //   56                   | push                esi
            //   57                   | push                edi
            //   8b7d08               | mov                 edi, dword ptr [ebp + 8]
            //   6a00                 | push                0
            //   ff7708               | push                dword ptr [edi + 8]

        $sequence_9 = { 03d1 c1cf02 8b4df0 03d3 334dac 8bc7 }
            // n = 6, score = 400
            //   03d1                 | add                 edx, ecx
            //   c1cf02               | ror                 edi, 2
            //   8b4df0               | mov                 ecx, dword ptr [ebp - 0x10]
            //   03d3                 | add                 edx, ebx
            //   334dac               | xor                 ecx, dword ptr [ebp - 0x54]
            //   8bc7                 | mov                 eax, edi

    condition:
        7 of them and filesize < 237568
}