rule win_aveo_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2026-01-05"
        version = "1"
        description = "Detects win.aveo."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.aveo"
        malpedia_rule_date = "20260105"
        malpedia_hash = "19b79e7cab4eaf532122e5b45a77dd8f6bb5cc79"
        malpedia_version = "20251219"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 894804 894808 89480c b9???????? 8d7901 8a11 41 }
            // n = 7, score = 200
            //   894804               | mov                 dword ptr [eax + 4], ecx
            //   894808               | mov                 dword ptr [eax + 8], ecx
            //   89480c               | mov                 dword ptr [eax + 0xc], ecx
            //   b9????????           |                     
            //   8d7901               | lea                 edi, [ecx + 1]
            //   8a11                 | mov                 dl, byte ptr [ecx]
            //   41                   | inc                 ecx

        $sequence_1 = { 68???????? e8???????? 83c404 899df4fdffff eb06 89b5f4fdffff 68???????? }
            // n = 7, score = 200
            //   68????????           |                     
            //   e8????????           |                     
            //   83c404               | add                 esp, 4
            //   899df4fdffff         | mov                 dword ptr [ebp - 0x20c], ebx
            //   eb06                 | jmp                 8
            //   89b5f4fdffff         | mov                 dword ptr [ebp - 0x20c], esi
            //   68????????           |                     

        $sequence_2 = { 52 50 8d9df8feffff e8???????? }
            // n = 4, score = 200
            //   52                   | push                edx
            //   50                   | push                eax
            //   8d9df8feffff         | lea                 ebx, [ebp - 0x108]
            //   e8????????           |                     

        $sequence_3 = { 8d8dfcefffff 51 8bf8 e8???????? 33ff 39bdf4efffff }
            // n = 6, score = 200
            //   8d8dfcefffff         | lea                 ecx, [ebp - 0x1004]
            //   51                   | push                ecx
            //   8bf8                 | mov                 edi, eax
            //   e8????????           |                     
            //   33ff                 | xor                 edi, edi
            //   39bdf4efffff         | cmp                 dword ptr [ebp - 0x100c], edi

        $sequence_4 = { e8???????? 83c40c 8d842418010000 50 8d8c241c030000 }
            // n = 5, score = 200
            //   e8????????           |                     
            //   83c40c               | add                 esp, 0xc
            //   8d842418010000       | lea                 eax, [esp + 0x118]
            //   50                   | push                eax
            //   8d8c241c030000       | lea                 ecx, [esp + 0x31c]

        $sequence_5 = { b9???????? 8d7901 8a11 41 84d2 75f9 2bcf }
            // n = 7, score = 200
            //   b9????????           |                     
            //   8d7901               | lea                 edi, [ecx + 1]
            //   8a11                 | mov                 dl, byte ptr [ecx]
            //   41                   | inc                 ecx
            //   84d2                 | test                dl, dl
            //   75f9                 | jne                 0xfffffffb
            //   2bcf                 | sub                 ecx, edi

        $sequence_6 = { 8db590fdffff 898574fdffff e8???????? be00100000 }
            // n = 4, score = 200
            //   8db590fdffff         | lea                 esi, [ebp - 0x270]
            //   898574fdffff         | mov                 dword ptr [ebp - 0x28c], eax
            //   e8????????           |                     
            //   be00100000           | mov                 esi, 0x1000

        $sequence_7 = { 50 e8???????? 8d8df4f9ffff 51 8d95f4feffff 52 }
            // n = 6, score = 200
            //   50                   | push                eax
            //   e8????????           |                     
            //   8d8df4f9ffff         | lea                 ecx, [ebp - 0x60c]
            //   51                   | push                ecx
            //   8d95f4feffff         | lea                 edx, [ebp - 0x10c]
            //   52                   | push                edx

        $sequence_8 = { 6803800000 50 ff15???????? 8b4de8 6a00 6a05 }
            // n = 6, score = 200
            //   6803800000           | push                0x8003
            //   50                   | push                eax
            //   ff15????????         |                     
            //   8b4de8               | mov                 ecx, dword ptr [ebp - 0x18]
            //   6a00                 | push                0
            //   6a05                 | push                5

        $sequence_9 = { 51 e8???????? 8b4df8 83c404 5f }
            // n = 5, score = 200
            //   51                   | push                ecx
            //   e8????????           |                     
            //   8b4df8               | mov                 ecx, dword ptr [ebp - 8]
            //   83c404               | add                 esp, 4
            //   5f                   | pop                 edi

    condition:
        7 of them and filesize < 180224
}