rule win_avrecon_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2026-01-05"
        version = "1"
        description = "Detects win.avrecon."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.avrecon"
        malpedia_rule_date = "20260105"
        malpedia_hash = "19b79e7cab4eaf532122e5b45a77dd8f6bb5cc79"
        malpedia_version = "20251219"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 6a24 8d4554 50 e8???????? }
            // n = 4, score = 300
            //   6a24                 | push                0x24
            //   8d4554               | lea                 eax, [ebp + 0x54]
            //   50                   | push                eax
            //   e8????????           |                     

        $sequence_1 = { 8d45f8 50 53 ff75ec c745f801000000 ffd7 83f8ff }
            // n = 7, score = 300
            //   8d45f8               | lea                 eax, [ebp - 8]
            //   50                   | push                eax
            //   53                   | push                ebx
            //   ff75ec               | push                dword ptr [ebp - 0x14]
            //   c745f801000000       | mov                 dword ptr [ebp - 8], 1
            //   ffd7                 | call                edi
            //   83f8ff               | cmp                 eax, -1

        $sequence_2 = { 83791c01 7511 6a00 8d4514 50 56 57 }
            // n = 7, score = 300
            //   83791c01             | cmp                 dword ptr [ecx + 0x1c], 1
            //   7511                 | jne                 0x13
            //   6a00                 | push                0
            //   8d4514               | lea                 eax, [ebp + 0x14]
            //   50                   | push                eax
            //   56                   | push                esi
            //   57                   | push                edi

        $sequence_3 = { 8d4401fc c7457401000000 894570 8d7c1f04 837d7000 }
            // n = 5, score = 300
            //   8d4401fc             | lea                 eax, [ecx + eax - 4]
            //   c7457401000000       | mov                 dword ptr [ebp + 0x74], 1
            //   894570               | mov                 dword ptr [ebp + 0x70], eax
            //   8d7c1f04             | lea                 edi, [edi + ebx + 4]
            //   837d7000             | cmp                 dword ptr [ebp + 0x70], 0

        $sequence_4 = { 807d7301 7508 e8???????? 885d73 8d85a8f3ffff 50 }
            // n = 6, score = 300
            //   807d7301             | cmp                 byte ptr [ebp + 0x73], 1
            //   7508                 | jne                 0xa
            //   e8????????           |                     
            //   885d73               | mov                 byte ptr [ebp + 0x73], bl
            //   8d85a8f3ffff         | lea                 eax, [ebp - 0xc58]
            //   50                   | push                eax

        $sequence_5 = { 8d85a8f7ffff 50 c7454000040000 ff15???????? }
            // n = 4, score = 300
            //   8d85a8f7ffff         | lea                 eax, [ebp - 0x858]
            //   50                   | push                eax
            //   c7454000040000       | mov                 dword ptr [ebp + 0x40], 0x400
            //   ff15????????         |                     

        $sequence_6 = { 51 894d30 33c0 8d8d18feffff 40 51 50 }
            // n = 7, score = 300
            //   51                   | push                ecx
            //   894d30               | mov                 dword ptr [ebp + 0x30], ecx
            //   33c0                 | xor                 eax, eax
            //   8d8d18feffff         | lea                 ecx, [ebp - 0x1e8]
            //   40                   | inc                 eax
            //   51                   | push                ecx
            //   50                   | push                eax

        $sequence_7 = { 50 bb7f660440 53 ff7508 c745f801000000 ffd7 83f8ff }
            // n = 7, score = 300
            //   50                   | push                eax
            //   bb7f660440           | mov                 ebx, 0x4004667f
            //   53                   | push                ebx
            //   ff7508               | push                dword ptr [ebp + 8]
            //   c745f801000000       | mov                 dword ptr [ebp - 8], 1
            //   ffd7                 | call                edi
            //   83f8ff               | cmp                 eax, -1

        $sequence_8 = { 50 e8???????? 85c0 7466 6a0e 68???????? }
            // n = 6, score = 300
            //   50                   | push                eax
            //   e8????????           |                     
            //   85c0                 | test                eax, eax
            //   7466                 | je                  0x68
            //   6a0e                 | push                0xe
            //   68????????           |                     

        $sequence_9 = { 83650800 b8e8030000 660105???????? 0fb705???????? 50 ffd6 668945de }
            // n = 7, score = 300
            //   83650800             | and                 dword ptr [ebp + 8], 0
            //   b8e8030000           | mov                 eax, 0x3e8
            //   660105????????       |                     
            //   0fb705????????       |                     
            //   50                   | push                eax
            //   ffd6                 | call                esi
            //   668945de             | mov                 word ptr [ebp - 0x22], ax

    condition:
        7 of them and filesize < 360448
}