rule win_avzhan_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2026-01-05"
        version = "1"
        description = "Detects win.avzhan."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.avzhan"
        malpedia_rule_date = "20260105"
        malpedia_hash = "19b79e7cab4eaf532122e5b45a77dd8f6bb5cc79"
        malpedia_version = "20251219"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { eb1d 6a02 e8???????? 83c008 }
            // n = 4, score = 200
            //   eb1d                 | jmp                 0x1f
            //   6a02                 | push                2
            //   e8????????           |                     
            //   83c008               | add                 eax, 8

        $sequence_1 = { 51 8d8c2404020000 51 56 }
            // n = 4, score = 200
            //   51                   | push                ecx
            //   8d8c2404020000       | lea                 ecx, [esp + 0x204]
            //   51                   | push                ecx
            //   56                   | push                esi

        $sequence_2 = { e8???????? 83c003 33d2 0fafc6 f7742408 }
            // n = 5, score = 200
            //   e8????????           |                     
            //   83c003               | add                 eax, 3
            //   33d2                 | xor                 edx, edx
            //   0fafc6               | imul                eax, esi
            //   f7742408             | div                 dword ptr [esp + 8]

        $sequence_3 = { c744243844000000 f3ab 8b442464 8b3d???????? }
            // n = 4, score = 200
            //   c744243844000000     | mov                 dword ptr [esp + 0x38], 0x44
            //   f3ab                 | rep stosd           dword ptr es:[edi], eax
            //   8b442464             | mov                 eax, dword ptr [esp + 0x64]
            //   8b3d????????         |                     

        $sequence_4 = { ffd7 6a00 8b542414 52 ffd3 6a0a ffd7 }
            // n = 7, score = 200
            //   ffd7                 | call                edi
            //   6a00                 | push                0
            //   8b542414             | mov                 edx, dword ptr [esp + 0x14]
            //   52                   | push                edx
            //   ffd3                 | call                ebx
            //   6a0a                 | push                0xa
            //   ffd7                 | call                edi

        $sequence_5 = { 8d8c2418020000 6a00 51 6a00 ffd5 85c0 }
            // n = 6, score = 200
            //   8d8c2418020000       | lea                 ecx, [esp + 0x218]
            //   6a00                 | push                0
            //   51                   | push                ecx
            //   6a00                 | push                0
            //   ffd5                 | call                ebp
            //   85c0                 | test                eax, eax

        $sequence_6 = { 49 50 8bd9 e8???????? }
            // n = 4, score = 200
            //   49                   | dec                 ecx
            //   50                   | push                eax
            //   8bd9                 | mov                 ebx, ecx
            //   e8????????           |                     

        $sequence_7 = { 6a14 ff15???????? 833d????????01 75d2 }
            // n = 4, score = 200
            //   6a14                 | push                0x14
            //   ff15????????         |                     
            //   833d????????01       |                     
            //   75d2                 | jne                 0xffffffd4

        $sequence_8 = { e8???????? 8bf0 6a64 81c600040000 e8???????? }
            // n = 5, score = 200
            //   e8????????           |                     
            //   8bf0                 | mov                 esi, eax
            //   6a64                 | push                0x64
            //   81c600040000         | add                 esi, 0x400
            //   e8????????           |                     

        $sequence_9 = { 83c418 3935???????? 7450 8b942464010000 }
            // n = 4, score = 200
            //   83c418               | add                 esp, 0x18
            //   3935????????         |                     
            //   7450                 | je                  0x52
            //   8b942464010000       | mov                 edx, dword ptr [esp + 0x164]

    condition:
        7 of them and filesize < 122880
}