rule win_azorult_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2026-01-05"
        version = "1"
        description = "Detects win.azorult."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.azorult"
        malpedia_rule_date = "20260105"
        malpedia_hash = "19b79e7cab4eaf532122e5b45a77dd8f6bb5cc79"
        malpedia_version = "20251219"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 8901 8bc1 c7410410000000 5d c20400 55 8bec }
            // n = 7, score = 200
            //   8901                 | mov                 dword ptr [ecx], eax
            //   8bc1                 | mov                 eax, ecx
            //   c7410410000000       | mov                 dword ptr [ecx + 4], 0x10
            //   5d                   | pop                 ebp
            //   c20400               | ret                 4
            //   55                   | push                ebp
            //   8bec                 | mov                 ebp, esp

        $sequence_1 = { ff15???????? 8b4dc8 8bd1 81e20000ff00 8bc1 c1e810 0bd0 }
            // n = 7, score = 200
            //   ff15????????         |                     
            //   8b4dc8               | mov                 ecx, dword ptr [ebp - 0x38]
            //   8bd1                 | mov                 edx, ecx
            //   81e20000ff00         | and                 edx, 0xff0000
            //   8bc1                 | mov                 eax, ecx
            //   c1e810               | shr                 eax, 0x10
            //   0bd0                 | or                  edx, eax

        $sequence_2 = { 83c410 5e c9 c3 55 8bec 81eccc060000 }
            // n = 7, score = 200
            //   83c410               | add                 esp, 0x10
            //   5e                   | pop                 esi
            //   c9                   | leave               
            //   c3                   | ret                 
            //   55                   | push                ebp
            //   8bec                 | mov                 ebp, esp
            //   81eccc060000         | sub                 esp, 0x6cc

        $sequence_3 = { 8d9adcbc1b8f 8b702c 03d9 337018 8bcf }
            // n = 5, score = 200
            //   8d9adcbc1b8f         | lea                 ebx, [edx - 0x70e44324]
            //   8b702c               | mov                 esi, dword ptr [eax + 0x2c]
            //   03d9                 | add                 ebx, ecx
            //   337018               | xor                 esi, dword ptr [eax + 0x18]
            //   8bcf                 | mov                 ecx, edi

        $sequence_4 = { 6a00 6a00 ff7508 ff7510 ff15???????? 85ff 7405 }
            // n = 7, score = 200
            //   6a00                 | push                0
            //   6a00                 | push                0
            //   ff7508               | push                dword ptr [ebp + 8]
            //   ff7510               | push                dword ptr [ebp + 0x10]
            //   ff15????????         |                     
            //   85ff                 | test                edi, edi
            //   7405                 | je                  7

        $sequence_5 = { e8???????? 84c0 0f8444010000 8d45d8 50 8d4dfc e8???????? }
            // n = 7, score = 200
            //   e8????????           |                     
            //   84c0                 | test                al, al
            //   0f8444010000         | je                  0x14a
            //   8d45d8               | lea                 eax, [ebp - 0x28]
            //   50                   | push                eax
            //   8d4dfc               | lea                 ecx, [ebp - 4]
            //   e8????????           |                     

        $sequence_6 = { 83fa04 1bc0 83e004 8b443814 d3e8 884415f8 42 }
            // n = 7, score = 200
            //   83fa04               | cmp                 edx, 4
            //   1bc0                 | sbb                 eax, eax
            //   83e004               | and                 eax, 4
            //   8b443814             | mov                 eax, dword ptr [eax + edi + 0x14]
            //   d3e8                 | shr                 eax, cl
            //   884415f8             | mov                 byte ptr [ebp + edx - 8], al
            //   42                   | inc                 edx

        $sequence_7 = { 68???????? 680000baba 50 50 e8???????? a1???????? 85c0 }
            // n = 7, score = 200
            //   68????????           |                     
            //   680000baba           | push                0xbaba0000
            //   50                   | push                eax
            //   50                   | push                eax
            //   e8????????           |                     
            //   a1????????           |                     
            //   85c0                 | test                eax, eax

        $sequence_8 = { c3 55 8bec 81ec2c020000 56 8d85d8fdffff 33f6 }
            // n = 7, score = 200
            //   c3                   | ret                 
            //   55                   | push                ebp
            //   8bec                 | mov                 ebp, esp
            //   81ec2c020000         | sub                 esp, 0x22c
            //   56                   | push                esi
            //   8d85d8fdffff         | lea                 eax, [ebp - 0x228]
            //   33f6                 | xor                 esi, esi

        $sequence_9 = { 80f920 74f4 80f97d 750c 8d4201 8907 8bc3 }
            // n = 7, score = 200
            //   80f920               | cmp                 cl, 0x20
            //   74f4                 | je                  0xfffffff6
            //   80f97d               | cmp                 cl, 0x7d
            //   750c                 | jne                 0xe
            //   8d4201               | lea                 eax, [edx + 1]
            //   8907                 | mov                 dword ptr [edi], eax
            //   8bc3                 | mov                 eax, ebx

    condition:
        7 of them and filesize < 1073152
}