rule win_babar_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2026-01-05"
        version = "1"
        description = "Detects win.babar."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.babar"
        malpedia_rule_date = "20260105"
        malpedia_hash = "19b79e7cab4eaf532122e5b45a77dd8f6bb5cc79"
        malpedia_version = "20251219"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 3bd6 7505 8d55e0 eb16 }
            // n = 4, score = 400
            //   3bd6                 | cmp                 edx, esi
            //   7505                 | jne                 7
            //   8d55e0               | lea                 edx, [ebp - 0x20]
            //   eb16                 | jmp                 0x18

        $sequence_1 = { 3bd6 721b 57 8bcb e8???????? 8bc8 }
            // n = 6, score = 400
            //   3bd6                 | cmp                 edx, esi
            //   721b                 | jb                  0x1d
            //   57                   | push                edi
            //   8bcb                 | mov                 ecx, ebx
            //   e8????????           |                     
            //   8bc8                 | mov                 ecx, eax

        $sequence_2 = { 3bd6 7503 8d5014 895010 }
            // n = 4, score = 400
            //   3bd6                 | cmp                 edx, esi
            //   7503                 | jne                 5
            //   8d5014               | lea                 edx, [eax + 0x14]
            //   895010               | mov                 dword ptr [eax + 0x10], edx

        $sequence_3 = { 3bd7 0f8440010000 397e14 0f8437010000 }
            // n = 4, score = 400
            //   3bd7                 | cmp                 edx, edi
            //   0f8440010000         | je                  0x146
            //   397e14               | cmp                 dword ptr [esi + 0x14], edi
            //   0f8437010000         | je                  0x13d

        $sequence_4 = { 46 ddd9 83fe03 ddd8 }
            // n = 4, score = 400
            //   46                   | inc                 esi
            //   ddd9                 | fstp                st(1)
            //   83fe03               | cmp                 esi, 3
            //   ddd8                 | fstp                st(0)

        $sequence_5 = { 3bd6 7505 8d55d8 eb16 }
            // n = 4, score = 400
            //   3bd6                 | cmp                 edx, esi
            //   7505                 | jne                 7
            //   8d55d8               | lea                 edx, [ebp - 0x28]
            //   eb16                 | jmp                 0x18

        $sequence_6 = { 3bd7 7215 7704 3bc3 }
            // n = 4, score = 400
            //   3bd7                 | cmp                 edx, edi
            //   7215                 | jb                  0x17
            //   7704                 | ja                  6
            //   3bc3                 | cmp                 eax, ebx

        $sequence_7 = { 3bd6 72d9 33f6 eb08 }
            // n = 4, score = 400
            //   3bd6                 | cmp                 edx, esi
            //   72d9                 | jb                  0xffffffdb
            //   33f6                 | xor                 esi, esi
            //   eb08                 | jmp                 0xa

        $sequence_8 = { 7506 807a0100 751c 8bc6 83c301 }
            // n = 5, score = 200
            //   7506                 | jne                 8
            //   807a0100             | cmp                 byte ptr [edx + 1], 0
            //   751c                 | jne                 0x1e
            //   8bc6                 | mov                 eax, esi
            //   83c301               | add                 ebx, 1

        $sequence_9 = { 83c104 5f 8bc1 2b442414 5e c60100 }
            // n = 6, score = 200
            //   83c104               | add                 ecx, 4
            //   5f                   | pop                 edi
            //   8bc1                 | mov                 eax, ecx
            //   2b442414             | sub                 eax, dword ptr [esp + 0x14]
            //   5e                   | pop                 esi
            //   c60100               | mov                 byte ptr [ecx], 0

        $sequence_10 = { eb4b 8b4c2428 55 6800014004 55 55 55 }
            // n = 7, score = 200
            //   eb4b                 | jmp                 0x4d
            //   8b4c2428             | mov                 ecx, dword ptr [esp + 0x28]
            //   55                   | push                ebp
            //   6800014004           | push                0x4400100
            //   55                   | push                ebp
            //   55                   | push                ebp
            //   55                   | push                ebp

        $sequence_11 = { 8b5308 8b03 8bf9 33fa }
            // n = 4, score = 200
            //   8b5308               | mov                 edx, dword ptr [ebx + 8]
            //   8b03                 | mov                 eax, dword ptr [ebx]
            //   8bf9                 | mov                 edi, ecx
            //   33fa                 | xor                 edi, edx

        $sequence_12 = { 89542448 ffd5 50 53 ff15???????? 85c0 }
            // n = 6, score = 200
            //   89542448             | mov                 dword ptr [esp + 0x48], edx
            //   ffd5                 | call                ebp
            //   50                   | push                eax
            //   53                   | push                ebx
            //   ff15????????         |                     
            //   85c0                 | test                eax, eax

        $sequence_13 = { 8b15???????? 5f 895608 8bc6 5e 8b8c2408060000 33cc }
            // n = 7, score = 200
            //   8b15????????         |                     
            //   5f                   | pop                 edi
            //   895608               | mov                 dword ptr [esi + 8], edx
            //   8bc6                 | mov                 eax, esi
            //   5e                   | pop                 esi
            //   8b8c2408060000       | mov                 ecx, dword ptr [esp + 0x608]
            //   33cc                 | xor                 ecx, esp

        $sequence_14 = { 8d442418 50 6a00 57 51 }
            // n = 5, score = 200
            //   8d442418             | lea                 eax, [esp + 0x18]
            //   50                   | push                eax
            //   6a00                 | push                0
            //   57                   | push                edi
            //   51                   | push                ecx

        $sequence_15 = { 0fb65002 83e23f 0fb61432 885103 83c003 83c104 }
            // n = 6, score = 200
            //   0fb65002             | movzx               edx, byte ptr [eax + 2]
            //   83e23f               | and                 edx, 0x3f
            //   0fb61432             | movzx               edx, byte ptr [edx + esi]
            //   885103               | mov                 byte ptr [ecx + 3], dl
            //   83c003               | add                 eax, 3
            //   83c104               | add                 ecx, 4

    condition:
        7 of them and filesize < 1294336
}