rule win_babuk_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2026-01-05"
        version = "1"
        description = "Detects win.babuk."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.babuk"
        malpedia_rule_date = "20260105"
        malpedia_hash = "19b79e7cab4eaf532122e5b45a77dd8f6bb5cc79"
        malpedia_version = "20251219"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { ff15???????? 6800000100 e8???????? 83c404 }
            // n = 4, score = 800
            //   ff15????????         |                     
            //   6800000100           | push                0x10000
            //   e8????????           |                     
            //   83c404               | add                 esp, 4

        $sequence_1 = { 50 ff15???????? 83f803 7502 }
            // n = 4, score = 800
            //   50                   | push                eax
            //   ff15????????         |                     
            //   83f803               | cmp                 eax, 3
            //   7502                 | jne                 4

        $sequence_2 = { ba08000000 6bc200 8b4d08 8b540104 52 8b0401 50 }
            // n = 7, score = 600
            //   ba08000000           | mov                 edx, 8
            //   6bc200               | imul                eax, edx, 0
            //   8b4d08               | mov                 ecx, dword ptr [ebp + 8]
            //   8b540104             | mov                 edx, dword ptr [ecx + eax + 4]
            //   52                   | push                edx
            //   8b0401               | mov                 eax, dword ptr [ecx + eax]
            //   50                   | push                eax

        $sequence_3 = { 56 57 b808000000 6bc80a 8b5508 c7040a00000000 }
            // n = 6, score = 600
            //   56                   | push                esi
            //   57                   | push                edi
            //   b808000000           | mov                 eax, 8
            //   6bc80a               | imul                ecx, eax, 0xa
            //   8b5508               | mov                 edx, dword ptr [ebp + 8]
            //   c7040a00000000       | mov                 dword ptr [edx + ecx], 0

        $sequence_4 = { 3dea000000 0f85d9000000 8b55ac 52 e8???????? 83c404 }
            // n = 6, score = 600
            //   3dea000000           | cmp                 eax, 0xea
            //   0f85d9000000         | jne                 0xdf
            //   8b55ac               | mov                 edx, dword ptr [ebp - 0x54]
            //   52                   | push                edx
            //   e8????????           |                     
            //   83c404               | add                 esp, 4

        $sequence_5 = { c7440a0400000000 c745fc00000000 eb09 8b45fc 83c002 8945fc }
            // n = 6, score = 600
            //   c7440a0400000000     | mov                 dword ptr [edx + ecx + 4], 0
            //   c745fc00000000       | mov                 dword ptr [ebp - 4], 0
            //   eb09                 | jmp                 0xb
            //   8b45fc               | mov                 eax, dword ptr [ebp - 4]
            //   83c002               | add                 eax, 2
            //   8945fc               | mov                 dword ptr [ebp - 4], eax

        $sequence_6 = { 8b85ecfdffff 8b8de4fdffff 8b948d70fdffff 89948508fdffff 8b85ecfdffff 83c001 }
            // n = 6, score = 600
            //   8b85ecfdffff         | mov                 eax, dword ptr [ebp - 0x214]
            //   8b8de4fdffff         | mov                 ecx, dword ptr [ebp - 0x21c]
            //   8b948d70fdffff       | mov                 edx, dword ptr [ebp + ecx*4 - 0x290]
            //   89948508fdffff       | mov                 dword ptr [ebp + eax*4 - 0x2f8], edx
            //   8b85ecfdffff         | mov                 eax, dword ptr [ebp - 0x214]
            //   83c001               | add                 eax, 1

        $sequence_7 = { 8b44ca04 50 8b0cca 51 e8???????? 83c408 8945f4 }
            // n = 7, score = 600
            //   8b44ca04             | mov                 eax, dword ptr [edx + ecx*8 + 4]
            //   50                   | push                eax
            //   8b0cca               | mov                 ecx, dword ptr [edx + ecx*8]
            //   51                   | push                ecx
            //   e8????????           |                     
            //   83c408               | add                 esp, 8
            //   8945f4               | mov                 dword ptr [ebp - 0xc], eax

        $sequence_8 = { eb02 ebbe 8b4d9c 51 ff15???????? }
            // n = 5, score = 600
            //   eb02                 | jmp                 4
            //   ebbe                 | jmp                 0xffffffc0
            //   8b4d9c               | mov                 ecx, dword ptr [ebp - 0x64]
            //   51                   | push                ecx
            //   ff15????????         |                     

        $sequence_9 = { 0f83dc000000 8b4dfc 8b5508 8b44ca04 }
            // n = 4, score = 600
            //   0f83dc000000         | jae                 0xe2
            //   8b4dfc               | mov                 ecx, dword ptr [ebp - 4]
            //   8b5508               | mov                 edx, dword ptr [ebp + 8]
            //   8b44ca04             | mov                 eax, dword ptr [edx + ecx*8 + 4]

        $sequence_10 = { 8b0401 50 e8???????? 83c408 8945ec 8955f0 b908000000 }
            // n = 7, score = 600
            //   8b0401               | mov                 eax, dword ptr [ecx + eax]
            //   50                   | push                eax
            //   e8????????           |                     
            //   83c408               | add                 esp, 8
            //   8945ec               | mov                 dword ptr [ebp - 0x14], eax
            //   8955f0               | mov                 dword ptr [ebp - 0x10], edx
            //   b908000000           | mov                 ecx, 8

        $sequence_11 = { c7040100000000 c744010400000000 ba08000000 6bc200 }
            // n = 4, score = 600
            //   c7040100000000       | mov                 dword ptr [ecx + eax], 0
            //   c744010400000000     | mov                 dword ptr [ecx + eax + 4], 0
            //   ba08000000           | mov                 edx, 8
            //   6bc200               | imul                eax, edx, 0

        $sequence_12 = { 894dfc 837dfc08 7d1e 8b55fc }
            // n = 4, score = 600
            //   894dfc               | mov                 dword ptr [ebp - 4], ecx
            //   837dfc08             | cmp                 dword ptr [ebp - 4], 8
            //   7d1e                 | jge                 0x20
            //   8b55fc               | mov                 edx, dword ptr [ebp - 4]

        $sequence_13 = { 8985c0fdffff 83bdc0fdffff00 0f84a1000000 c785ccfdffff00000000 eb0f }
            // n = 5, score = 600
            //   8985c0fdffff         | mov                 dword ptr [ebp - 0x240], eax
            //   83bdc0fdffff00       | cmp                 dword ptr [ebp - 0x240], 0
            //   0f84a1000000         | je                  0xa7
            //   c785ccfdffff00000000     | mov    dword ptr [ebp - 0x234], 0
            //   eb0f                 | jmp                 0x11

        $sequence_14 = { ba08000000 6bc20a 8b4d08 c7040100000000 c744010400000000 }
            // n = 5, score = 600
            //   ba08000000           | mov                 edx, 8
            //   6bc20a               | imul                eax, edx, 0xa
            //   8b4d08               | mov                 ecx, dword ptr [ebp + 8]
            //   c7040100000000       | mov                 dword ptr [ecx + eax], 0
            //   c744010400000000     | mov                 dword ptr [ecx + eax + 4], 0

        $sequence_15 = { 8b8c8508fdffff 51 ff15???????? eb02 }
            // n = 4, score = 600
            //   8b8c8508fdffff       | mov                 ecx, dword ptr [ebp + eax*4 - 0x2f8]
            //   51                   | push                ecx
            //   ff15????????         |                     
            //   eb02                 | jmp                 4

    condition:
        7 of them and filesize < 183296
}