rule win_babylon_rat_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2026-01-05"
        version = "1"
        description = "Detects win.babylon_rat."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.babylon_rat"
        malpedia_rule_date = "20260105"
        malpedia_hash = "19b79e7cab4eaf532122e5b45a77dd8f6bb5cc79"
        malpedia_version = "20251219"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 8b4610 83c40c 8b4dfc 8b4c080c 8b45f4 3b01 7413 }
            // n = 7, score = 100
            //   8b4610               | mov                 eax, dword ptr [esi + 0x10]
            //   83c40c               | add                 esp, 0xc
            //   8b4dfc               | mov                 ecx, dword ptr [ebp - 4]
            //   8b4c080c             | mov                 ecx, dword ptr [eax + ecx + 0xc]
            //   8b45f4               | mov                 eax, dword ptr [ebp - 0xc]
            //   3b01                 | cmp                 eax, dword ptr [ecx]
            //   7413                 | je                  0x15

        $sequence_1 = { ff75ec e8???????? 59 59 85ff 0f8541010000 8b0b }
            // n = 7, score = 100
            //   ff75ec               | push                dword ptr [ebp - 0x14]
            //   e8????????           |                     
            //   59                   | pop                 ecx
            //   59                   | pop                 ecx
            //   85ff                 | test                edi, edi
            //   0f8541010000         | jne                 0x147
            //   8b0b                 | mov                 ecx, dword ptr [ebx]

        $sequence_2 = { ff75c0 6a23 56 e8???????? 6a01 56 e8???????? }
            // n = 7, score = 100
            //   ff75c0               | push                dword ptr [ebp - 0x40]
            //   6a23                 | push                0x23
            //   56                   | push                esi
            //   e8????????           |                     
            //   6a01                 | push                1
            //   56                   | push                esi
            //   e8????????           |                     

        $sequence_3 = { 8b450c f6402a20 753d 51 ff75f4 6a70 53 }
            // n = 7, score = 100
            //   8b450c               | mov                 eax, dword ptr [ebp + 0xc]
            //   f6402a20             | test                byte ptr [eax + 0x2a], 0x20
            //   753d                 | jne                 0x3f
            //   51                   | push                ecx
            //   ff75f4               | push                dword ptr [ebp - 0xc]
            //   6a70                 | push                0x70
            //   53                   | push                ebx

        $sequence_4 = { ff3402 e8???????? 8bf0 83c404 803e9a 0f85a6000000 8b55bc }
            // n = 7, score = 100
            //   ff3402               | push                dword ptr [edx + eax]
            //   e8????????           |                     
            //   8bf0                 | mov                 esi, eax
            //   83c404               | add                 esp, 4
            //   803e9a               | cmp                 byte ptr [esi], 0x9a
            //   0f85a6000000         | jne                 0xac
            //   8b55bc               | mov                 edx, dword ptr [ebp - 0x44]

        $sequence_5 = { eb5e 83f8fa 7508 897e10 884601 eb51 83f8f6 }
            // n = 7, score = 100
            //   eb5e                 | jmp                 0x60
            //   83f8fa               | cmp                 eax, -6
            //   7508                 | jne                 0xa
            //   897e10               | mov                 dword ptr [esi + 0x10], edi
            //   884601               | mov                 byte ptr [esi + 1], al
            //   eb51                 | jmp                 0x53
            //   83f8f6               | cmp                 eax, -0xa

        $sequence_6 = { 8d4801 66894dbc 8b4620 8945a4 8b450c 8945b0 8b06 }
            // n = 7, score = 100
            //   8d4801               | lea                 ecx, [eax + 1]
            //   66894dbc             | mov                 word ptr [ebp - 0x44], cx
            //   8b4620               | mov                 eax, dword ptr [esi + 0x20]
            //   8945a4               | mov                 dword ptr [ebp - 0x5c], eax
            //   8b450c               | mov                 eax, dword ptr [ebp + 0xc]
            //   8945b0               | mov                 dword ptr [ebp - 0x50], eax
            //   8b06                 | mov                 eax, dword ptr [esi]

        $sequence_7 = { 85f6 7e4c c7451007000000 53 8b450c 0fbe5c1001 0fbe0c10 }
            // n = 7, score = 100
            //   85f6                 | test                esi, esi
            //   7e4c                 | jle                 0x4e
            //   c7451007000000       | mov                 dword ptr [ebp + 0x10], 7
            //   53                   | push                ebx
            //   8b450c               | mov                 eax, dword ptr [ebp + 0xc]
            //   0fbe5c1001           | movsx               ebx, byte ptr [eax + edx + 1]
            //   0fbe0c10             | movsx               ecx, byte ptr [eax + edx]

        $sequence_8 = { ff75f4 ffb57cffffff 53 56 e8???????? 83c42c 837dc000 }
            // n = 7, score = 100
            //   ff75f4               | push                dword ptr [ebp - 0xc]
            //   ffb57cffffff         | push                dword ptr [ebp - 0x84]
            //   53                   | push                ebx
            //   56                   | push                esi
            //   e8????????           |                     
            //   83c42c               | add                 esp, 0x2c
            //   837dc000             | cmp                 dword ptr [ebp - 0x40], 0

        $sequence_9 = { ffb3ac000000 e8???????? 8bbbac000000 be???????? 8b4dfc 03f9 51 }
            // n = 7, score = 100
            //   ffb3ac000000         | push                dword ptr [ebx + 0xac]
            //   e8????????           |                     
            //   8bbbac000000         | mov                 edi, dword ptr [ebx + 0xac]
            //   be????????           |                     
            //   8b4dfc               | mov                 ecx, dword ptr [ebp - 4]
            //   03f9                 | add                 edi, ecx
            //   51                   | push                ecx

    condition:
        7 of them and filesize < 1604608
}