rule win_backspace_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2026-01-05"
        version = "1"
        description = "Detects win.backspace."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.backspace"
        malpedia_rule_date = "20260105"
        malpedia_hash = "19b79e7cab4eaf532122e5b45a77dd8f6bb5cc79"
        malpedia_version = "20251219"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 8d8578fdffff 56 50 89b579fdffff e8???????? }
            // n = 5, score = 100
            //   8d8578fdffff         | lea                 eax, [ebp - 0x288]
            //   56                   | push                esi
            //   50                   | push                eax
            //   89b579fdffff         | mov                 dword ptr [ebp - 0x287], esi
            //   e8????????           |                     

        $sequence_1 = { 90 745f 90 13c9 90 eb20 }
            // n = 6, score = 100
            //   90                   | nop                 
            //   745f                 | je                  0x61
            //   90                   | nop                 
            //   13c9                 | adc                 ecx, ecx
            //   90                   | nop                 
            //   eb20                 | jmp                 0x22

        $sequence_2 = { 68???????? 50 ff15???????? 6a0a 58 }
            // n = 5, score = 100
            //   68????????           |                     
            //   50                   | push                eax
            //   ff15????????         |                     
            //   6a0a                 | push                0xa
            //   58                   | pop                 eax

        $sequence_3 = { 6a00 68???????? 68???????? 6a50 56 e8???????? 83c420 }
            // n = 7, score = 100
            //   6a00                 | push                0
            //   68????????           |                     
            //   68????????           |                     
            //   6a50                 | push                0x50
            //   56                   | push                esi
            //   e8????????           |                     
            //   83c420               | add                 esp, 0x20

        $sequence_4 = { 7e1a 8b4c240c 8b442404 56 2bc1 8bf2 }
            // n = 6, score = 100
            //   7e1a                 | jle                 0x1c
            //   8b4c240c             | mov                 ecx, dword ptr [esp + 0xc]
            //   8b442404             | mov                 eax, dword ptr [esp + 4]
            //   56                   | push                esi
            //   2bc1                 | sub                 eax, ecx
            //   8bf2                 | mov                 esi, edx

        $sequence_5 = { f7f9 55 8b35???????? 8bd8 a1???????? 2b05???????? 0fafc3 }
            // n = 7, score = 100
            //   f7f9                 | idiv                ecx
            //   55                   | push                ebp
            //   8b35????????         |                     
            //   8bd8                 | mov                 ebx, eax
            //   a1????????           |                     
            //   2b05????????         |                     
            //   0fafc3               | imul                eax, ebx

        $sequence_6 = { 66ab aa 8d8580fdffff 6800020000 50 53 }
            // n = 6, score = 100
            //   66ab                 | stosw               word ptr es:[edi], ax
            //   aa                   | stosb               byte ptr es:[edi], al
            //   8d8580fdffff         | lea                 eax, [ebp - 0x280]
            //   6800020000           | push                0x200
            //   50                   | push                eax
            //   53                   | push                ebx

        $sequence_7 = { a1???????? 57 40 50 ff15???????? 85c0 0f8fa3000000 }
            // n = 7, score = 100
            //   a1????????           |                     
            //   57                   | push                edi
            //   40                   | inc                 eax
            //   50                   | push                eax
            //   ff15????????         |                     
            //   85c0                 | test                eax, eax
            //   0f8fa3000000         | jg                  0xa9

        $sequence_8 = { c3 55 8bec b808200000 e8???????? 53 56 }
            // n = 7, score = 100
            //   c3                   | ret                 
            //   55                   | push                ebp
            //   8bec                 | mov                 ebp, esp
            //   b808200000           | mov                 eax, 0x2008
            //   e8????????           |                     
            //   53                   | push                ebx
            //   56                   | push                esi

        $sequence_9 = { 57 50 ffd6 83c418 85db }
            // n = 5, score = 100
            //   57                   | push                edi
            //   50                   | push                eax
            //   ffd6                 | call                esi
            //   83c418               | add                 esp, 0x18
            //   85db                 | test                ebx, ebx

    condition:
        7 of them and filesize < 131072
}