rule win_badflick_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2026-01-05"
        version = "1"
        description = "Detects win.badflick."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.badflick"
        malpedia_rule_date = "20260105"
        malpedia_hash = "19b79e7cab4eaf532122e5b45a77dd8f6bb5cc79"
        malpedia_version = "20251219"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 8bd8 ff37 ff15???????? 50 e8???????? 50 ff7508 }
            // n = 7, score = 100
            //   8bd8                 | mov                 ebx, eax
            //   ff37                 | push                dword ptr [edi]
            //   ff15????????         |                     
            //   50                   | push                eax
            //   e8????????           |                     
            //   50                   | push                eax
            //   ff7508               | push                dword ptr [ebp + 8]

        $sequence_1 = { ff35???????? ff750c ff75fc ff33 e8???????? 8b7d10 83c418 }
            // n = 7, score = 100
            //   ff35????????         |                     
            //   ff750c               | push                dword ptr [ebp + 0xc]
            //   ff75fc               | push                dword ptr [ebp - 4]
            //   ff33                 | push                dword ptr [ebx]
            //   e8????????           |                     
            //   8b7d10               | mov                 edi, dword ptr [ebp + 0x10]
            //   83c418               | add                 esp, 0x18

        $sequence_2 = { 55 8bec ff7508 6a2b }
            // n = 4, score = 100
            //   55                   | push                ebp
            //   8bec                 | mov                 ebp, esp
            //   ff7508               | push                dword ptr [ebp + 8]
            //   6a2b                 | push                0x2b

        $sequence_3 = { 807d1000 59 5f 5e }
            // n = 4, score = 100
            //   807d1000             | cmp                 byte ptr [ebp + 0x10], 0
            //   59                   | pop                 ecx
            //   5f                   | pop                 edi
            //   5e                   | pop                 esi

        $sequence_4 = { be00f00000 56 e8???????? 59 53 8d4df8 51 }
            // n = 7, score = 100
            //   be00f00000           | mov                 esi, 0xf000
            //   56                   | push                esi
            //   e8????????           |                     
            //   59                   | pop                 ecx
            //   53                   | push                ebx
            //   8d4df8               | lea                 ecx, [ebp - 8]
            //   51                   | push                ecx

        $sequence_5 = { 8b4904 03c8 81f9fe34012c 7509 83f805 }
            // n = 5, score = 100
            //   8b4904               | mov                 ecx, dword ptr [ecx + 4]
            //   03c8                 | add                 ecx, eax
            //   81f9fe34012c         | cmp                 ecx, 0x2c0134fe
            //   7509                 | jne                 0xb
            //   83f805               | cmp                 eax, 5

        $sequence_6 = { 6a3d e8???????? 8bf0 8a4508 59 59 884605 }
            // n = 7, score = 100
            //   6a3d                 | push                0x3d
            //   e8????????           |                     
            //   8bf0                 | mov                 esi, eax
            //   8a4508               | mov                 al, byte ptr [ebp + 8]
            //   59                   | pop                 ecx
            //   59                   | pop                 ecx
            //   884605               | mov                 byte ptr [esi + 5], al

        $sequence_7 = { a5 a5 eb02 33c0 50 6a00 }
            // n = 6, score = 100
            //   a5                   | movsd               dword ptr es:[edi], dword ptr [esi]
            //   a5                   | movsd               dword ptr es:[edi], dword ptr [esi]
            //   eb02                 | jmp                 4
            //   33c0                 | xor                 eax, eax
            //   50                   | push                eax
            //   6a00                 | push                0

        $sequence_8 = { 8d8548f3ffff 50 ffd7 8d856cf9ffff 50 8d8560f7ffff }
            // n = 6, score = 100
            //   8d8548f3ffff         | lea                 eax, [ebp - 0xcb8]
            //   50                   | push                eax
            //   ffd7                 | call                edi
            //   8d856cf9ffff         | lea                 eax, [ebp - 0x694]
            //   50                   | push                eax
            //   8d8560f7ffff         | lea                 eax, [ebp - 0x8a0]

        $sequence_9 = { a5 a5 e8???????? 59 6a00 }
            // n = 5, score = 100
            //   a5                   | movsd               dword ptr es:[edi], dword ptr [esi]
            //   a5                   | movsd               dword ptr es:[edi], dword ptr [esi]
            //   e8????????           |                     
            //   59                   | pop                 ecx
            //   6a00                 | push                0

    condition:
        7 of them and filesize < 81920
}