rule win_badnews_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2026-01-05"
        version = "1"
        description = "Detects win.badnews."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.badnews"
        malpedia_rule_date = "20260105"
        malpedia_hash = "19b79e7cab4eaf532122e5b45a77dd8f6bb5cc79"
        malpedia_version = "20251219"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { ff15???????? 50 e8???????? 83c404 68???????? 6804010000 }
            // n = 6, score = 1000
            //   ff15????????         |                     
            //   50                   | push                eax
            //   e8????????           |                     
            //   83c404               | add                 esp, 4
            //   68????????           |                     
            //   6804010000           | push                0x104

        $sequence_1 = { c0e004 02c1 3423 c0c003 }
            // n = 4, score = 900
            //   c0e004               | shl                 al, 4
            //   02c1                 | add                 al, cl
            //   3423                 | xor                 al, 0x23
            //   c0c003               | rol                 al, 3

        $sequence_2 = { c78534ffffff47657457 c78538ffffff696e646f c7853cffffff77546578 66c78540ffffff7457 }
            // n = 4, score = 900
            //   c78534ffffff47657457     | mov    dword ptr [ebp - 0xcc], 0x57746547
            //   c78538ffffff696e646f     | mov    dword ptr [ebp - 0xc8], 0x6f646e69
            //   c7853cffffff77546578     | mov    dword ptr [ebp - 0xc4], 0x78655477
            //   66c78540ffffff7457     | mov    word ptr [ebp - 0xc0], 0x5774

        $sequence_3 = { c705????????33322e64 66c705????????6c6c c605????????00 ff15???????? }
            // n = 4, score = 900
            //   c705????????33322e64     |     
            //   66c705????????6c6c     |     
            //   c605????????00       |                     
            //   ff15????????         |                     

        $sequence_4 = { a1???????? 33c5 8945fc 53 56 57 8d8534ffffff }
            // n = 7, score = 900
            //   a1????????           |                     
            //   33c5                 | xor                 eax, ebp
            //   8945fc               | mov                 dword ptr [ebp - 4], eax
            //   53                   | push                ebx
            //   56                   | push                esi
            //   57                   | push                edi
            //   8d8534ffffff         | lea                 eax, [ebp - 0xcc]

        $sequence_5 = { eb02 33c9 c0e004 02c1 }
            // n = 4, score = 900
            //   eb02                 | jmp                 4
            //   33c9                 | xor                 ecx, ecx
            //   c0e004               | shl                 al, 4
            //   02c1                 | add                 al, cl

        $sequence_6 = { 55 8bec 8b450c 3d01020000 }
            // n = 4, score = 900
            //   55                   | push                ebp
            //   8bec                 | mov                 ebp, esp
            //   8b450c               | mov                 eax, dword ptr [ebp + 0xc]
            //   3d01020000           | cmp                 eax, 0x201

        $sequence_7 = { 68???????? 6a1a 68???????? 57 }
            // n = 4, score = 800
            //   68????????           |                     
            //   6a1a                 | push                0x1a
            //   68????????           |                     
            //   57                   | push                edi

        $sequence_8 = { 6a00 d1f9 68???????? 03c9 }
            // n = 4, score = 800
            //   6a00                 | push                0
            //   d1f9                 | sar                 ecx, 1
            //   68????????           |                     
            //   03c9                 | add                 ecx, ecx

        $sequence_9 = { 57 6a00 6880000000 6a04 6a00 6a01 6a04 }
            // n = 7, score = 700
            //   57                   | push                edi
            //   6a00                 | push                0
            //   6880000000           | push                0x80
            //   6a04                 | push                4
            //   6a00                 | push                0
            //   6a01                 | push                1
            //   6a04                 | push                4

        $sequence_10 = { ffd3 85c0 7403 83c608 8a06 }
            // n = 5, score = 700
            //   ffd3                 | call                ebx
            //   85c0                 | test                eax, eax
            //   7403                 | je                  5
            //   83c608               | add                 esi, 8
            //   8a06                 | mov                 al, byte ptr [esi]

        $sequence_11 = { ff15???????? 85c0 7405 83c004 }
            // n = 4, score = 700
            //   ff15????????         |                     
            //   85c0                 | test                eax, eax
            //   7405                 | je                  7
            //   83c004               | add                 eax, 4

        $sequence_12 = { 68???????? ff15???????? b8???????? 83c424 8d5002 668b08 }
            // n = 6, score = 500
            //   68????????           |                     
            //   ff15????????         |                     
            //   b8????????           |                     
            //   83c424               | add                 esp, 0x24
            //   8d5002               | lea                 edx, [eax + 2]
            //   668b08               | mov                 cx, word ptr [eax]

        $sequence_13 = { 41 84c0 75f9 2bce 3bd1 72e4 }
            // n = 6, score = 100
            //   41                   | inc                 ecx
            //   84c0                 | test                al, al
            //   75f9                 | jne                 0xfffffffb
            //   2bce                 | sub                 ecx, esi
            //   3bd1                 | cmp                 edx, ecx
            //   72e4                 | jb                  0xffffffe6

        $sequence_14 = { 8bc7 c1f805 83e71f c1e706 8b0485d0a70110 }
            // n = 5, score = 100
            //   8bc7                 | mov                 eax, edi
            //   c1f805               | sar                 eax, 5
            //   83e71f               | and                 edi, 0x1f
            //   c1e706               | shl                 edi, 6
            //   8b0485d0a70110       | mov                 eax, dword ptr [eax*4 + 0x1001a7d0]

        $sequence_15 = { 4b 75da 8b35???????? 8b9d50fbffff }
            // n = 4, score = 100
            //   4b                   | dec                 ebx
            //   75da                 | jne                 0xffffffdc
            //   8b35????????         |                     
            //   8b9d50fbffff         | mov                 ebx, dword ptr [ebp - 0x4b0]

        $sequence_16 = { 8bce 83e11f c1e106 8b0485d0a70110 c644080401 56 e8???????? }
            // n = 7, score = 100
            //   8bce                 | mov                 ecx, esi
            //   83e11f               | and                 ecx, 0x1f
            //   c1e106               | shl                 ecx, 6
            //   8b0485d0a70110       | mov                 eax, dword ptr [eax*4 + 0x1001a7d0]
            //   c644080401           | mov                 byte ptr [eax + ecx + 4], 1
            //   56                   | push                esi
            //   e8????????           |                     

        $sequence_17 = { 6a03 8802 42 8b048dd0a70110 4e 5f 6a0a }
            // n = 7, score = 100
            //   6a03                 | push                3
            //   8802                 | mov                 byte ptr [edx], al
            //   42                   | inc                 edx
            //   8b048dd0a70110       | mov                 eax, dword ptr [ecx*4 + 0x1001a7d0]
            //   4e                   | dec                 esi
            //   5f                   | pop                 edi
            //   6a0a                 | push                0xa

        $sequence_18 = { c1e106 899528e5ffff 53 8b1495d0a70110 }
            // n = 4, score = 100
            //   c1e106               | shl                 ecx, 6
            //   899528e5ffff         | mov                 dword ptr [ebp - 0x1ad8], edx
            //   53                   | push                ebx
            //   8b1495d0a70110       | mov                 edx, dword ptr [edx*4 + 0x1001a7d0]

        $sequence_19 = { 84c0 75f9 2bce 741c 804415ec03 8d4dec 42 }
            // n = 7, score = 100
            //   84c0                 | test                al, al
            //   75f9                 | jne                 0xfffffffb
            //   2bce                 | sub                 ecx, esi
            //   741c                 | je                  0x1e
            //   804415ec03           | add                 byte ptr [ebp + edx - 0x14], 3
            //   8d4dec               | lea                 ecx, [ebp - 0x14]
            //   42                   | inc                 edx

        $sequence_20 = { c7465c00350110 83660800 33ff 47 897e14 }
            // n = 5, score = 100
            //   c7465c00350110       | mov                 dword ptr [esi + 0x5c], 0x10013500
            //   83660800             | and                 dword ptr [esi + 8], 0
            //   33ff                 | xor                 edi, edi
            //   47                   | inc                 edi
            //   897e14               | mov                 dword ptr [esi + 0x14], edi

    condition:
        7 of them and filesize < 612352
}