rule win_balkan_door_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2026-01-05"
        version = "1"
        description = "Detects win.balkan_door."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.balkan_door"
        malpedia_rule_date = "20260105"
        malpedia_hash = "19b79e7cab4eaf532122e5b45a77dd8f6bb5cc79"
        malpedia_version = "20251219"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 50 ffd7 50 56 68???????? }
            // n = 5, score = 700
            //   50                   | push                eax
            //   ffd7                 | call                edi
            //   50                   | push                eax
            //   56                   | push                esi
            //   68????????           |                     

        $sequence_1 = { ffd7 5e 32c0 5f c3 32c0 }
            // n = 6, score = 700
            //   ffd7                 | call                edi
            //   5e                   | pop                 esi
            //   32c0                 | xor                 al, al
            //   5f                   | pop                 edi
            //   c3                   | ret                 
            //   32c0                 | xor                 al, al

        $sequence_2 = { ffd7 5e 32c0 5f }
            // n = 4, score = 700
            //   ffd7                 | call                edi
            //   5e                   | pop                 esi
            //   32c0                 | xor                 al, al
            //   5f                   | pop                 edi

        $sequence_3 = { 50 57 6a00 6a16 ffb53cefffff ff15???????? 85c0 }
            // n = 7, score = 700
            //   50                   | push                eax
            //   57                   | push                edi
            //   6a00                 | push                0
            //   6a16                 | push                0x16
            //   ffb53cefffff         | push                dword ptr [ebp - 0x10c4]
            //   ff15????????         |                     
            //   85c0                 | test                eax, eax

        $sequence_4 = { 6a26 ffb53cefffff ff15???????? 85c0 750c ff15???????? 8986f8000000 }
            // n = 7, score = 700
            //   6a26                 | push                0x26
            //   ffb53cefffff         | push                dword ptr [ebp - 0x10c4]
            //   ff15????????         |                     
            //   85c0                 | test                eax, eax
            //   750c                 | jne                 0xe
            //   ff15????????         |                     
            //   8986f8000000         | mov                 dword ptr [esi + 0xf8], eax

        $sequence_5 = { 740b 6a00 6a00 56 ff15???????? 57 8b3d???????? }
            // n = 7, score = 700
            //   740b                 | je                  0xd
            //   6a00                 | push                0
            //   6a00                 | push                0
            //   56                   | push                esi
            //   ff15????????         |                     
            //   57                   | push                edi
            //   8b3d????????         |                     

        $sequence_6 = { 68c0270900 ffd7 6a00 ff35???????? }
            // n = 4, score = 700
            //   68c0270900           | push                0x927c0
            //   ffd7                 | call                edi
            //   6a00                 | push                0
            //   ff35????????         |                     

        $sequence_7 = { d1f8 33d2 50 51 8d4dd8 }
            // n = 5, score = 700
            //   d1f8                 | sar                 eax, 1
            //   33d2                 | xor                 edx, edx
            //   50                   | push                eax
            //   51                   | push                ecx
            //   8d4dd8               | lea                 ecx, [ebp - 0x28]

        $sequence_8 = { ffd7 85c0 741a 8d85d0fdffff c785d0fdffff2c020000 50 }
            // n = 6, score = 700
            //   ffd7                 | call                edi
            //   85c0                 | test                eax, eax
            //   741a                 | je                  0x1c
            //   8d85d0fdffff         | lea                 eax, [ebp - 0x230]
            //   c785d0fdffff2c020000     | mov    dword ptr [ebp - 0x230], 0x22c
            //   50                   | push                eax

        $sequence_9 = { ff15???????? 8bf0 85f6 740b 6a00 6a00 56 }
            // n = 7, score = 700
            //   ff15????????         |                     
            //   8bf0                 | mov                 esi, eax
            //   85f6                 | test                esi, esi
            //   740b                 | je                  0xd
            //   6a00                 | push                0
            //   6a00                 | push                0
            //   56                   | push                esi

    condition:
        7 of them and filesize < 352256
}