rule win_bandit_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2026-01-05"
        version = "1"
        description = "Detects win.bandit."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.bandit"
        malpedia_rule_date = "20260105"
        malpedia_hash = "19b79e7cab4eaf532122e5b45a77dd8f6bb5cc79"
        malpedia_version = "20251219"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { eb24 31c0 488d5c241f b931000000 0f1f00 e8???????? 488bac2498000000 }
            // n = 7, score = 100
            //   eb24                 | dec                 eax
            //   31c0                 | mov                 dword ptr [eax], ecx
            //   488d5c241f           | dec                 eax
            //   b931000000           | mov                 ecx, dword ptr [esp + 0x88]
            //   0f1f00               | dec                 eax
            //   e8????????           |                     
            //   488bac2498000000     | mov                 dword ptr [eax + 0x18], ecx

        $sequence_1 = { eb1e 440fb64c341a 4183c1c3 4401ca 88543c1a 448844341a 4883c002 }
            // n = 7, score = 100
            //   eb1e                 | mov                 ebp, dword ptr [esp + 0x830]
            //   440fb64c341a         | dec                 eax
            //   4183c1c3             | add                 esp, 0x838
            //   4401ca               | ret                 
            //   88543c1a             | dec                 eax
            //   448844341a           | lea                 ebx, [0x877990]
            //   4883c002             | dec                 eax

        $sequence_2 = { 8854245f 0fb6542424 0fb6742421 29f2 88542460 31c0 488d5c2446 }
            // n = 7, score = 100
            //   8854245f             | mov                 byte ptr [esp + 0x37], dl
            //   0fb6542424           | movzx               edx, byte ptr [esp + 0x25]
            //   0fb6742421           | movzx               esi, byte ptr [esp + 0x1d]
            //   29f2                 | xor                 edx, esi
            //   88542460             | mov                 byte ptr [esp + 0x38], dl
            //   31c0                 | movzx               edx, byte ptr [esp + 0x21]
            //   488d5c2446           | movzx               esi, byte ptr [esp + 0x28]

        $sequence_3 = { eb1c 4889c7 488b8c2400110000 e8???????? 488d3d6bac7c00 e8???????? e8???????? }
            // n = 7, score = 100
            //   eb1c                 | mov                 edx, dword ptr [esp + 0xd8]
            //   4889c7               | jmp                 0xfa2
            //   488b8c2400110000     | dec                 eax
            //   e8????????           |                     
            //   488d3d6bac7c00       | mov                 edx, dword ptr [esp + 0xd8]
            //   e8????????           |                     
            //   e8????????           |                     

        $sequence_4 = { e8???????? 90 31c9 e8???????? 4885ff 750a 48895c2440 }
            // n = 7, score = 100
            //   e8????????           |                     
            //   90                   | dec                 eax
            //   31c9                 | lea                 eax, [0x4a913c]
            //   e8????????           |                     
            //   4885ff               | dec                 eax
            //   750a                 | mov                 ebx, dword ptr [esp + 0xd08]
            //   48895c2440           | dec                 eax

        $sequence_5 = { eb1d 488d7808 488b9424501b0000 e8???????? 488d3dc0945f00 e8???????? 90 }
            // n = 7, score = 100
            //   eb1d                 | xor                 esi, esi
            //   488d7808             | dec                 eax
            //   488b9424501b0000     | lea                 edx, [0x97aede]
            //   e8????????           |                     
            //   488d3dc0945f00       | dec                 eax
            //   e8????????           |                     
            //   90                   | mov                 esi, eax

        $sequence_6 = { e8???????? 488b8424c8000000 488b542430 488b7058 4885f6 7429 4889742448 }
            // n = 7, score = 100
            //   e8????????           |                     
            //   488b8424c8000000     | mov                 dword ptr [esp + 0xe28], 0xee1860a8
            //   488b542430           | xor                 eax, eax
            //   488b7058             | jmp                 0x398
            //   4885f6               | movzx               edx, byte ptr [esp + eax + 0xe2c]
            //   7429                 | movzx               esi, byte ptr [esp + eax + 0xe20]
            //   4889742448           | sub                 esi, edx

        $sequence_7 = { eb15 488d05172b4e00 e8???????? 488b4c2440 48ff4158 c60002 4889c3 }
            // n = 7, score = 100
            //   eb15                 | add                 byte ptr [ebx + ecx*4 - 0x6c], cl
            //   488d05172b4e00       | and                 al, 0x98
            //   e8????????           |                     
            //   488b4c2440           | add                 byte ptr [eax], al
            //   48ff4158             | add                 byte ptr [ebx + ecx*4 - 0x5c], cl
            //   c60002               | and                 al, 0xc0
            //   4889c3               | add                 byte ptr [eax], al

        $sequence_8 = { eb1a 440fb64c342a 4183c14d 4401ca 88543c2a 448844342a 4883c002 }
            // n = 7, score = 100
            //   eb1a                 | dec                 eax
            //   440fb64c342a         | mov                 dword ptr [eax], 0xc
            //   4183c14d             | dec                 eax
            //   4401ca               | mov                 edi, dword ptr [esp + 0x168]
            //   88543c2a             | dec                 eax
            //   448844342a           | mov                 dword ptr [edi + 0x10], 1
            //   4883c002             | dec                 eax

        $sequence_9 = { e8???????? 833d????????00 750e 488b8c24e8060000 48894818 eb15 488d7818 }
            // n = 7, score = 100
            //   e8????????           |                     
            //   833d????????00       |                     
            //   750e                 | mov                 dword ptr [esp + 0x70], ecx
            //   488b8c24e8060000     | dec                 eax
            //   48894818             | mov                 dword ptr [esp + 0x68], edi
            //   eb15                 | nop                 
            //   488d7818             | movsd               xmm0, qword ptr [esp + 0x60]

    condition:
        7 of them and filesize < 29914112
}