rule win_bandook_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2026-01-05"
        version = "1"
        description = "Detects win.bandook."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.bandook"
        malpedia_rule_date = "20260105"
        malpedia_hash = "19b79e7cab4eaf532122e5b45a77dd8f6bb5cc79"
        malpedia_version = "20251219"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 8b85f0bfffff 8985a0beffff 89b598beffff 899d94beffff }
            // n = 4, score = 100
            //   8b85f0bfffff         | mov                 eax, dword ptr [ebp - 0x4010]
            //   8985a0beffff         | mov                 dword ptr [ebp - 0x4160], eax
            //   89b598beffff         | mov                 dword ptr [ebp - 0x4168], esi
            //   899d94beffff         | mov                 dword ptr [ebp - 0x416c], ebx

        $sequence_1 = { 8d95f4fbffff 83c414 e8???????? 8b4df8 33cd 5e e8???????? }
            // n = 7, score = 100
            //   8d95f4fbffff         | lea                 edx, [ebp - 0x40c]
            //   83c414               | add                 esp, 0x14
            //   e8????????           |                     
            //   8b4df8               | mov                 ecx, dword ptr [ebp - 8]
            //   33cd                 | xor                 ecx, ebp
            //   5e                   | pop                 esi
            //   e8????????           |                     

        $sequence_2 = { 8b45f0 0fb640f8 0fb680789d1c13 3334c5a3c31e13 8bc2 c1e818 0fb688789d1c13 }
            // n = 7, score = 100
            //   8b45f0               | mov                 eax, dword ptr [ebp - 0x10]
            //   0fb640f8             | movzx               eax, byte ptr [eax - 8]
            //   0fb680789d1c13       | movzx               eax, byte ptr [eax + 0x131c9d78]
            //   3334c5a3c31e13       | xor                 esi, dword ptr [eax*8 + 0x131ec3a3]
            //   8bc2                 | mov                 eax, edx
            //   c1e818               | shr                 eax, 0x18
            //   0fb688789d1c13       | movzx               ecx, byte ptr [eax + 0x131c9d78]

        $sequence_3 = { 83c404 89442414 68c0d40100 e8???????? 83c404 8bf8 }
            // n = 6, score = 100
            //   83c404               | add                 esp, 4
            //   89442414             | mov                 dword ptr [esp + 0x14], eax
            //   68c0d40100           | push                0x1d4c0
            //   e8????????           |                     
            //   83c404               | add                 esp, 4
            //   8bf8                 | mov                 edi, eax

        $sequence_4 = { 8945fc 803d????????01 8b4508 753a ff30 ba???????? }
            // n = 6, score = 100
            //   8945fc               | mov                 dword ptr [ebp - 4], eax
            //   803d????????01       |                     
            //   8b4508               | mov                 eax, dword ptr [ebp + 8]
            //   753a                 | jne                 0x3c
            //   ff30                 | push                dword ptr [eax]
            //   ba????????           |                     

        $sequence_5 = { 8bc8 e8???????? 83c408 8d4704 c707???????? c700???????? 8b4df4 }
            // n = 7, score = 100
            //   8bc8                 | mov                 ecx, eax
            //   e8????????           |                     
            //   83c408               | add                 esp, 8
            //   8d4704               | lea                 eax, [edi + 4]
            //   c707????????         |                     
            //   c700????????         |                     
            //   8b4df4               | mov                 ecx, dword ptr [ebp - 0xc]

        $sequence_6 = { 58 6bc000 c7805cd11e1302000000 6a04 58 6bc000 8b0d???????? }
            // n = 7, score = 100
            //   58                   | pop                 eax
            //   6bc000               | imul                eax, eax, 0
            //   c7805cd11e1302000000     | mov    dword ptr [eax + 0x131ed15c], 2
            //   6a04                 | push                4
            //   58                   | pop                 eax
            //   6bc000               | imul                eax, eax, 0
            //   8b0d????????         |                     

        $sequence_7 = { 64a300000000 8bf9 897dac c745fc00000000 897d98 c745a800000000 0f2805???????? }
            // n = 7, score = 100
            //   64a300000000         | mov                 dword ptr fs:[0], eax
            //   8bf9                 | mov                 edi, ecx
            //   897dac               | mov                 dword ptr [ebp - 0x54], edi
            //   c745fc00000000       | mov                 dword ptr [ebp - 4], 0
            //   897d98               | mov                 dword ptr [ebp - 0x68], edi
            //   c745a800000000       | mov                 dword ptr [ebp - 0x58], 0
            //   0f2805????????       |                     

        $sequence_8 = { e8???????? 8bf0 83c404 8975e0 6a00 8bce c645fc01 }
            // n = 7, score = 100
            //   e8????????           |                     
            //   8bf0                 | mov                 esi, eax
            //   83c404               | add                 esp, 4
            //   8975e0               | mov                 dword ptr [ebp - 0x20], esi
            //   6a00                 | push                0
            //   8bce                 | mov                 ecx, esi
            //   c645fc01             | mov                 byte ptr [ebp - 4], 1

        $sequence_9 = { 0fb708 8d4002 66894c02fe 6685c9 75f0 8d8c24c00d0000 }
            // n = 6, score = 100
            //   0fb708               | movzx               ecx, word ptr [eax]
            //   8d4002               | lea                 eax, [eax + 2]
            //   66894c02fe           | mov                 word ptr [edx + eax - 2], cx
            //   6685c9               | test                cx, cx
            //   75f0                 | jne                 0xfffffff2
            //   8d8c24c00d0000       | lea                 ecx, [esp + 0xdc0]

    condition:
        7 of them and filesize < 23088128
}