rule win_banpolmex_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2026-01-05"
        version = "1"
        description = "Detects win.banpolmex."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.banpolmex"
        malpedia_rule_date = "20260105"
        malpedia_hash = "19b79e7cab4eaf532122e5b45a77dd8f6bb5cc79"
        malpedia_version = "20251219"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 488bcf e8???????? e9???????? 3d4c494b50 7515 488d4c2430 4c8bc7 }
            // n = 7, score = 100
            //   488bcf               | lea                 ecx, [esp + 0x70]
            //   e8????????           |                     
            //   e9????????           |                     
            //   3d4c494b50           | cmp                 cl, 6
            //   7515                 | jne                 0x501
            //   488d4c2430           | dec                 eax
            //   4c8bc7               | mov                 edx, dword ptr [edi + 0x18]

        $sequence_1 = { 488b4d07 4885c9 7406 ff15???????? 4183fd04 7512 488d1560960200 }
            // n = 7, score = 100
            //   488b4d07             | mov                 eax, 0x40
            //   4885c9               | dec                 eax
            //   7406                 | lea                 ecx, [ebp + 0x4e0]
            //   ff15????????         |                     
            //   4183fd04             | jne                 0xa1e
            //   7512                 | mov                 al, byte ptr [ebx]
            //   488d1560960200       | dec                 ebx

        $sequence_2 = { 418bc0 c1e808 0fb6c8 418b848a20de0800 250000ff00 33d0 }
            // n = 6, score = 100
            //   418bc0               | mov                 ecx, esi
            //   c1e808               | nop                 word ptr [eax + eax]
            //   0fb6c8               | inc                 esp
            //   418b848a20de0800     | movzx               ecx, byte ptr [ebp + edi - 0x80]
            //   250000ff00           | dec                 esp
            //   33d0                 | lea                 eax, [0x150b7]

        $sequence_3 = { 8944246c 8bf8 ff15???????? 488bd8 4885c0 0f847e010000 8d4e40 }
            // n = 7, score = 100
            //   8944246c             | xor                 ecx, ecx
            //   8bf8                 | mov                 edx, 0x1b
            //   ff15????????         |                     
            //   488bd8               | inc                 eax
            //   4885c0               | push                ebx
            //   0f847e010000         | dec                 eax
            //   8d4e40               | sub                 esp, 0x20

        $sequence_4 = { 410fb6c5 45338487000c0000 4433460c 418bc0 c1e810 0fb6d0 418bc1 }
            // n = 7, score = 100
            //   410fb6c5             | lea                 edx, [0x3a4e3]
            //   45338487000c0000     | dec                 eax
            //   4433460c             | mov                 ecx, edi
            //   418bc0               | jmp                 0x2001
            //   c1e810               | dec                 esp
            //   0fb6d0               | mov                 dword ptr [edi + 0x848], ebp
            //   418bc1               | jmp                 0x2001

        $sequence_5 = { 0f47d0 8915???????? 488d0d42130900 e8???????? 4c8b6c2468 4c8b642470 488bac24a0000000 }
            // n = 7, score = 100
            //   0f47d0               | arpl                ax, dx
            //   8915????????         |                     
            //   488d0d42130900       | test                edx, edx
            //   e8????????           |                     
            //   4c8b6c2468           | dec                 eax
            //   4c8b642470           | mov                 ecx, ebp
            //   488bac24a0000000     | dec                 eax

        $sequence_6 = { 7439 4883c420 5b c3 488d91d0000000 41b840000000 e8???????? }
            // n = 7, score = 100
            //   7439                 | dec                 eax
            //   4883c420             | lea                 ecx, [ebp - 0x19]
            //   5b                   | mov                 byte ptr [ecx], 0
            //   c3                   | dec                 eax
            //   488d91d0000000       | inc                 ecx
            //   41b840000000         | dec                 ecx
            //   e8????????           |                     

        $sequence_7 = { 4885ff 7406 89aee4000000 4885db 7406 89aee0000000 33c0 }
            // n = 7, score = 100
            //   4885ff               | inc                 ecx
            //   7406                 | cmp                 eax, ecx
            //   89aee4000000         | je                  0x17a3
            //   4885db               | test                word ptr [ebx + 0x368], ax
            //   7406                 | je                  0x17dc
            //   89aee0000000         | mov                 edx, dword ptr [esi]
            //   33c0                 | mov                 ecx, edx

        $sequence_8 = { 488d542440 4c8bc3 488bc8 488bf8 c744244000000400 e8???????? 33ed }
            // n = 7, score = 100
            //   488d542440           | dec                 eax
            //   4c8bc3               | add                 esp, 0x240
            //   488bc8               | mov                 eax, ebx
            //   488bf8               | dec                 eax
            //   c744244000000400     | mov                 ecx, dword ptr [esp + 0x150]
            //   e8????????           |                     
            //   33ed                 | dec                 eax

        $sequence_9 = { 488bd3 488bcf e8???????? 85c0 78ba 8b03 803c3805 }
            // n = 7, score = 100
            //   488bd3               | mov                 edi, 5
            //   488bcf               | dec                 eax
            //   e8????????           |                     
            //   85c0                 | add                 esi, edx
            //   78ba                 | test                ebx, ebx
            //   8b03                 | or                  eax, 0xffffffff
            //   803c3805             | jmp                 0x42f

    condition:
        7 of them and filesize < 1555456
}