rule win_bart_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2026-01-05"
        version = "1"
        description = "Detects win.bart."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.bart"
        malpedia_rule_date = "20260105"
        malpedia_hash = "19b79e7cab4eaf532122e5b45a77dd8f6bb5cc79"
        malpedia_version = "20251219"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 74d1 68ffffff00 50 8d45d8 8bce 50 e8???????? }
            // n = 7, score = 100
            //   74d1                 | je                  0xffffffd3
            //   68ffffff00           | push                0xffffff
            //   50                   | push                eax
            //   8d45d8               | lea                 eax, [ebp - 0x28]
            //   8bce                 | mov                 ecx, esi
            //   50                   | push                eax
            //   e8????????           |                     

        $sequence_1 = { 8d4dbc e8???????? 8b8558ffffff 8d8d7cffffff 8b9550ffffff 0fb600 }
            // n = 6, score = 100
            //   8d4dbc               | lea                 ecx, [ebp - 0x44]
            //   e8????????           |                     
            //   8b8558ffffff         | mov                 eax, dword ptr [ebp - 0xa8]
            //   8d8d7cffffff         | lea                 ecx, [ebp - 0x84]
            //   8b9550ffffff         | mov                 edx, dword ptr [ebp - 0xb0]
            //   0fb600               | movzx               eax, byte ptr [eax]

        $sequence_2 = { 8d4dd4 eb55 84db 755a 6a02 5a 8d4de4 }
            // n = 7, score = 100
            //   8d4dd4               | lea                 ecx, [ebp - 0x2c]
            //   eb55                 | jmp                 0x57
            //   84db                 | test                bl, bl
            //   755a                 | jne                 0x5c
            //   6a02                 | push                2
            //   5a                   | pop                 edx
            //   8d4de4               | lea                 ecx, [ebp - 0x1c]

        $sequence_3 = { 48 0fb7c0 6683f801 7e7e }
            // n = 4, score = 100
            //   48                   | dec                 eax
            //   0fb7c0               | movzx               eax, ax
            //   6683f801             | cmp                 ax, 1
            //   7e7e                 | jle                 0x80

        $sequence_4 = { 53 56 57 8d45b8 8955ec 8bf9 50 }
            // n = 7, score = 100
            //   53                   | push                ebx
            //   56                   | push                esi
            //   57                   | push                edi
            //   8d45b8               | lea                 eax, [ebp - 0x48]
            //   8955ec               | mov                 dword ptr [ebp - 0x14], edx
            //   8bf9                 | mov                 edi, ecx
            //   50                   | push                eax

        $sequence_5 = { ffb63c010000 53 ffd7 83c40c 3b461c 75e1 33c0 }
            // n = 7, score = 100
            //   ffb63c010000         | push                dword ptr [esi + 0x13c]
            //   53                   | push                ebx
            //   ffd7                 | call                edi
            //   83c40c               | add                 esp, 0xc
            //   3b461c               | cmp                 eax, dword ptr [esi + 0x1c]
            //   75e1                 | jne                 0xffffffe3
            //   33c0                 | xor                 eax, eax

        $sequence_6 = { 8bfa 8bd9 384601 7e11 }
            // n = 4, score = 100
            //   8bfa                 | mov                 edi, edx
            //   8bd9                 | mov                 ebx, ecx
            //   384601               | cmp                 byte ptr [esi + 1], al
            //   7e11                 | jle                 0x13

        $sequence_7 = { 8bec 53 56 8bd9 57 33ff 397b48 }
            // n = 7, score = 100
            //   8bec                 | mov                 ebp, esp
            //   53                   | push                ebx
            //   56                   | push                esi
            //   8bd9                 | mov                 ebx, ecx
            //   57                   | push                edi
            //   33ff                 | xor                 edi, edi
            //   397b48               | cmp                 dword ptr [ebx + 0x48], edi

        $sequence_8 = { 0f840c010000 57 ff15???????? 6800ff0000 ffd3 8bf8 85ff }
            // n = 7, score = 100
            //   0f840c010000         | je                  0x112
            //   57                   | push                edi
            //   ff15????????         |                     
            //   6800ff0000           | push                0xff00
            //   ffd3                 | call                ebx
            //   8bf8                 | mov                 edi, eax
            //   85ff                 | test                edi, edi

        $sequence_9 = { 50 8b83b0000000 ffd0 8b95c8feffff 8b8db8feffff 53 56 }
            // n = 7, score = 100
            //   50                   | push                eax
            //   8b83b0000000         | mov                 eax, dword ptr [ebx + 0xb0]
            //   ffd0                 | call                eax
            //   8b95c8feffff         | mov                 edx, dword ptr [ebp - 0x138]
            //   8b8db8feffff         | mov                 ecx, dword ptr [ebp - 0x148]
            //   53                   | push                ebx
            //   56                   | push                esi

    condition:
        7 of them and filesize < 163840
}