rule win_batel_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2026-01-05"
        version = "1"
        description = "Detects win.batel."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.batel"
        malpedia_rule_date = "20260105"
        malpedia_hash = "19b79e7cab4eaf532122e5b45a77dd8f6bb5cc79"
        malpedia_version = "20251219"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 33c0 5b c21000 3b0d???????? 7502 }
            // n = 5, score = 200
            //   33c0                 | xor                 eax, eax
            //   5b                   | pop                 ebx
            //   c21000               | ret                 0x10
            //   3b0d????????         |                     
            //   7502                 | jne                 4

        $sequence_1 = { eb35 a1???????? 81b80000230050450000 75eb b90b010000 66398818002300 }
            // n = 6, score = 100
            //   eb35                 | jmp                 0x37
            //   a1????????           |                     
            //   81b80000230050450000     | cmp    dword ptr [eax + 0x230000], 0x4550
            //   75eb                 | jne                 0xffffffed
            //   b90b010000           | mov                 ecx, 0x10b
            //   66398818002300       | cmp                 word ptr [eax + 0x230018], cx

        $sequence_2 = { 7412 ffd0 56 ffd3 68005c2605 ffd5 47 }
            // n = 7, score = 100
            //   7412                 | je                  0x14
            //   ffd0                 | call                eax
            //   56                   | push                esi
            //   ffd3                 | call                ebx
            //   68005c2605           | push                0x5265c00
            //   ffd5                 | call                ebp
            //   47                   | inc                 edi

        $sequence_3 = { 8bec 81eca0020000 68ee020000 ff15???????? 689d020000 }
            // n = 5, score = 100
            //   8bec                 | mov                 ebp, esp
            //   81eca0020000         | sub                 esp, 0x2a0
            //   68ee020000           | push                0x2ee
            //   ff15????????         |                     
            //   689d020000           | push                0x29d

        $sequence_4 = { 85f6 7422 68???????? 56 ff15???????? 85c0 7412 }
            // n = 7, score = 100
            //   85f6                 | test                esi, esi
            //   7422                 | je                  0x24
            //   68????????           |                     
            //   56                   | push                esi
            //   ff15????????         |                     
            //   85c0                 | test                eax, eax
            //   7412                 | je                  0x14

        $sequence_5 = { 57 6a40 6800100000 689e020000 }
            // n = 4, score = 100
            //   57                   | push                edi
            //   6a40                 | push                0x40
            //   6800100000           | push                0x1000
            //   689e020000           | push                0x29e

        $sequence_6 = { 68005c2605 ffd5 47 83ff5a 7ccd 5f 5e }
            // n = 7, score = 100
            //   68005c2605           | push                0x5265c00
            //   ffd5                 | call                ebp
            //   47                   | inc                 edi
            //   83ff5a               | cmp                 edi, 0x5a
            //   7ccd                 | jl                  0xffffffcf
            //   5f                   | pop                 edi
            //   5e                   | pop                 esi

        $sequence_7 = { 55 8b2d???????? 56 57 68a00f0000 ffd5 8b1d???????? }
            // n = 7, score = 100
            //   55                   | push                ebp
            //   8b2d????????         |                     
            //   56                   | push                esi
            //   57                   | push                edi
            //   68a00f0000           | push                0xfa0
            //   ffd5                 | call                ebp
            //   8b1d????????         |                     

        $sequence_8 = { 33c9 b8???????? 8a10 88940d60fdffff }
            // n = 4, score = 100
            //   33c9                 | xor                 ecx, ecx
            //   b8????????           |                     
            //   8a10                 | mov                 dl, byte ptr [eax]
            //   88940d60fdffff       | mov                 byte ptr [ebp + ecx - 0x2a0], dl

        $sequence_9 = { 6868212300 e8???????? 33db 895de4 8d4594 50 ff15???????? }
            // n = 7, score = 100
            //   6868212300           | push                0x232168
            //   e8????????           |                     
            //   33db                 | xor                 ebx, ebx
            //   895de4               | mov                 dword ptr [ebp - 0x1c], ebx
            //   8d4594               | lea                 eax, [ebp - 0x6c]
            //   50                   | push                eax
            //   ff15????????         |                     

        $sequence_10 = { 8935???????? 68d0202300 68c4202300 e8???????? 59 59 }
            // n = 6, score = 100
            //   8935????????         |                     
            //   68d0202300           | push                0x2320d0
            //   68c4202300           | push                0x2320c4
            //   e8????????           |                     
            //   59                   | pop                 ecx
            //   59                   | pop                 ecx

        $sequence_11 = { 66a5 ffd0 5f 5e }
            // n = 4, score = 100
            //   66a5                 | movsw               word ptr es:[edi], word ptr [esi]
            //   ffd0                 | call                eax
            //   5f                   | pop                 edi
            //   5e                   | pop                 esi

        $sequence_12 = { e9???????? 6894152300 e8???????? a1???????? c704242c302300 ff35???????? }
            // n = 6, score = 100
            //   e9????????           |                     
            //   6894152300           | push                0x231594
            //   e8????????           |                     
            //   a1????????           |                     
            //   c704242c302300       | mov                 dword ptr [esp], 0x23302c
            //   ff35????????         |                     

        $sequence_13 = { ff15???????? 689d020000 8d8561fdffff 6a00 50 }
            // n = 5, score = 100
            //   ff15????????         |                     
            //   689d020000           | push                0x29d
            //   8d8561fdffff         | lea                 eax, [ebp - 0x29f]
            //   6a00                 | push                0
            //   50                   | push                eax

        $sequence_14 = { 50 c68560fdffff00 e8???????? 83c40c 33c9 }
            // n = 5, score = 100
            //   50                   | push                eax
            //   c68560fdffff00       | mov                 byte ptr [ebp - 0x2a0], 0
            //   e8????????           |                     
            //   83c40c               | add                 esp, 0xc
            //   33c9                 | xor                 ecx, ecx

        $sequence_15 = { 41 3d???????? 7cec 56 57 }
            // n = 5, score = 100
            //   41                   | inc                 ecx
            //   3d????????           |                     
            //   7cec                 | jl                  0xffffffee
            //   56                   | push                esi
            //   57                   | push                edi

        $sequence_16 = { 8b1d???????? bf01000000 8d642400 68???????? ff15???????? 8bf0 85f6 }
            // n = 7, score = 100
            //   8b1d????????         |                     
            //   bf01000000           | mov                 edi, 1
            //   8d642400             | lea                 esp, [esp]
            //   68????????           |                     
            //   ff15????????         |                     
            //   8bf0                 | mov                 esi, eax
            //   85f6                 | test                esi, esi

        $sequence_17 = { c745fc00000000 6800002300 e8???????? 83c404 85c0 }
            // n = 5, score = 100
            //   c745fc00000000       | mov                 dword ptr [ebp - 4], 0
            //   6800002300           | push                0x230000
            //   e8????????           |                     
            //   83c404               | add                 esp, 4
            //   85c0                 | test                eax, eax

        $sequence_18 = { 689e020000 6a00 ff15???????? 8bf8 b9a7000000 8db560fdffff f3a5 }
            // n = 7, score = 100
            //   689e020000           | push                0x29e
            //   6a00                 | push                0
            //   ff15????????         |                     
            //   8bf8                 | mov                 edi, eax
            //   b9a7000000           | mov                 ecx, 0xa7
            //   8db560fdffff         | lea                 esi, [ebp - 0x2a0]
            //   f3a5                 | rep movsd           dword ptr es:[edi], dword ptr [esi]

        $sequence_19 = { c3 8bff 56 b858212300 be58212300 57 }
            // n = 6, score = 100
            //   c3                   | ret                 
            //   8bff                 | mov                 edi, edi
            //   56                   | push                esi
            //   b858212300           | mov                 eax, 0x232158
            //   be58212300           | mov                 esi, 0x232158
            //   57                   | push                edi

        $sequence_20 = { 7419 ffd0 56 ffd3 68404c5827 ff15???????? 47 }
            // n = 7, score = 100
            //   7419                 | je                  0x1b
            //   ffd0                 | call                eax
            //   56                   | push                esi
            //   ffd3                 | call                ebx
            //   68404c5827           | push                0x27584c40
            //   ff15????????         |                     
            //   47                   | inc                 edi

    condition:
        7 of them and filesize < 49152
}