rule win_bazarbackdoor_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2026-01-05"
        version = "1"
        description = "Detects win.bazarbackdoor."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.bazarbackdoor"
        malpedia_rule_date = "20260105"
        malpedia_hash = "19b79e7cab4eaf532122e5b45a77dd8f6bb5cc79"
        malpedia_version = "20251219"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 488bce 4889442420 ff15???????? 85c0 780a 4898 }
            // n = 6, score = 1500
            //   488bce               | mov                 eax, 0x100f
            //   4889442420           | inc                 ebp
            //   ff15????????         |                     
            //   85c0                 | xor                 ecx, ecx
            //   780a                 | dec                 eax
            //   4898                 | mov                 dword ptr [esp + 0x28], eax

        $sequence_1 = { 41b8e6b5a12c 448d4a7d e8???????? 4885c0 740c }
            // n = 5, score = 1300
            //   41b8e6b5a12c         | inc                 ebp
            //   448d4a7d             | xor                 ecx, ecx
            //   e8????????           |                     
            //   4885c0               | dec                 eax
            //   740c                 | mov                 dword ptr [esp + 0x28], eax

        $sequence_2 = { 4533c0 ffd0 eb03 488bc7 83f8ff }
            // n = 5, score = 1300
            //   4533c0               | dec                 eax
            //   ffd0                 | lea                 edx, [ebp + 0x7a0]
            //   eb03                 | dec                 eax
            //   488bc7               | lea                 eax, [esp + 0x70]
            //   83f8ff               | inc                 ecx

        $sequence_3 = { 48635004 85d2 7415 48035138 488b4928 }
            // n = 5, score = 1300
            //   48635004             | mov                 eax, 0x100f
            //   85d2                 | dec                 eax
            //   7415                 | mov                 ecx, esi
            //   48035138             | dec                 eax
            //   488b4928             | mov                 dword ptr [esp + 0x20], eax

        $sequence_4 = { 0fb70f ff15???????? 0fb74f02 0fb7d8 ff15???????? 0fb74f08 }
            // n = 6, score = 1100
            //   0fb70f               | movzx               ecx, word ptr [edi]
            //   ff15????????         |                     
            //   0fb74f02             | movzx               ecx, word ptr [edi + 2]
            //   0fb7d8               | movzx               ebx, ax
            //   ff15????????         |                     
            //   0fb74f08             | movzx               ecx, word ptr [edi + 8]

        $sequence_5 = { 488d4d80 e8???????? 498bd6 488d4d80 }
            // n = 4, score = 1100
            //   488d4d80             | dec                 eax
            //   e8????????           |                     
            //   498bd6               | cwde                
            //   488d4d80             | inc                 ecx

        $sequence_6 = { ff15???????? 0fb74f08 440fb7e8 ff15???????? }
            // n = 4, score = 1000
            //   ff15????????         |                     
            //   0fb74f08             | movzx               ebp, ax
            //   440fb7e8             | movzx               ecx, word ptr [edi + 8]
            //   ff15????????         |                     

        $sequence_7 = { 7507 33c0 e9???????? b8ff000000 }
            // n = 4, score = 1000
            //   7507                 | jne                 9
            //   33c0                 | xor                 eax, eax
            //   e9????????           |                     
            //   b8ff000000           | mov                 eax, 0xff

        $sequence_8 = { c3 0fb74c0818 b80b010000 663bc8 }
            // n = 4, score = 900
            //   c3                   | inc                 esp
            //   0fb74c0818           | movzx               ebp, ax
            //   b80b010000           | movzx               ecx, word ptr [edi]
            //   663bc8               | movzx               ecx, word ptr [edi + 2]

        $sequence_9 = { cc 4053 4883ec20 b902000000 }
            // n = 4, score = 900
            //   cc                   | dec                 eax
            //   4053                 | mov                 dword ptr [esp + 0x20], eax
            //   4883ec20             | test                eax, eax
            //   b902000000           | inc                 ecx

        $sequence_10 = { 4533c9 4889442428 488d95a0070000 488d442470 41b80f100000 488bce 4889442420 }
            // n = 7, score = 800
            //   4533c9               | dec                 eax
            //   4889442428           | mov                 dword ptr [esp + 0x20], eax
            //   488d95a0070000       | test                eax, eax
            //   488d442470           | js                  0x13
            //   41b80f100000         | dec                 eax
            //   488bce               | cwde                
            //   4889442420           | inc                 ecx

        $sequence_11 = { 418d5508 488bc8 ff15???????? 488bd8 4885c0 }
            // n = 5, score = 800
            //   418d5508             | movzx               ecx, word ptr [edi + 8]
            //   488bc8               | inc                 esp
            //   ff15????????         |                     
            //   488bd8               | movzx               ebp, ax
            //   4885c0               | movzx               ecx, word ptr [edi + 2]

        $sequence_12 = { 48c1e108 4803c8 8bc1 488d94059f070000 }
            // n = 4, score = 800
            //   48c1e108             | mov                 eax, 0x100f
            //   4803c8               | dec                 eax
            //   8bc1                 | mov                 ecx, esi
            //   488d94059f070000     | dec                 eax

        $sequence_13 = { 31ff 4889c1 31d2 4989f0 }
            // n = 4, score = 800
            //   31ff                 | dec                 eax
            //   4889c1               | lea                 ecx, [esp + 0x20]
            //   31d2                 | dec                 eax
            //   4989f0               | mov                 dword ptr [esp + 0x28], eax

        $sequence_14 = { 488d9590050000 488bce ff15???????? 85c0 }
            // n = 4, score = 800
            //   488d9590050000       | mov                 eax, ecx
            //   488bce               | dec                 eax
            //   ff15????????         |                     
            //   85c0                 | lea                 edx, [ebp + eax + 0x79f]

        $sequence_15 = { e8???????? 4889c7 8b05???????? 8b0d???????? }
            // n = 4, score = 800
            //   e8????????           |                     
            //   4889c7               | je                  0x92
            //   8b05????????         |                     
            //   8b0d????????         |                     

        $sequence_16 = { e8???????? 4c89e1 e8???????? 8b05???????? }
            // n = 4, score = 800
            //   e8????????           |                     
            //   4c89e1               | mov                 dword ptr [esp + 0x28], eax
            //   e8????????           |                     
            //   8b05????????         |                     

        $sequence_17 = { 08ca 80f201 7502 ebfe }
            // n = 4, score = 700
            //   08ca                 | xor                 edx, edx
            //   80f201               | dec                 ecx
            //   7502                 | mov                 eax, esi
            //   ebfe                 | inc                 ecx

        $sequence_18 = { 488bd3 e8???????? ff15???????? 4c8bc3 33d2 }
            // n = 5, score = 700
            //   488bd3               | xor                 ecx, ecx
            //   e8????????           |                     
            //   ff15????????         |                     
            //   4c8bc3               | dec                 eax
            //   33d2                 | mov                 dword ptr [esp + 0x28], eax

        $sequence_19 = { 0f94c3 83fa09 0f9fc1 83fa0a 0f9cc2 30da 7519 }
            // n = 7, score = 700
            //   0f94c3               | dec                 eax
            //   83fa09               | mov                 ecx, eax
            //   0f9fc1               | xor                 edx, edx
            //   83fa0a               | dec                 ebp
            //   0f9cc2               | mov                 eax, edi
            //   30da                 | inc                 ecx
            //   7519                 | call                ebp

        $sequence_20 = { 83ff0a 0f9cc3 83ff09 0f9fc0 38d3 }
            // n = 5, score = 700
            //   83ff0a               | inc                 ecx
            //   0f9cc3               | mov                 eax, 0x100f
            //   83ff09               | dec                 eax
            //   0f9fc0               | mov                 ecx, esi
            //   38d3                 | dec                 eax

        $sequence_21 = { 0fb6d1 80f973 7504 0fb65305 33c0 }
            // n = 5, score = 700
            //   0fb6d1               | js                  0x13
            //   80f973               | dec                 eax
            //   7504                 | cwde                
            //   0fb65305             | inc                 ecx
            //   33c0                 | mov                 eax, 0x100f

        $sequence_22 = { 4889442428 488d95b0030000 488d4580 41b80f100000 }
            // n = 4, score = 700
            //   4889442428           | movzx               ebp, ax
            //   488d95b0030000       | inc                 ecx
            //   488d4580             | lea                 edx, [ebp + 8]
            //   41b80f100000         | dec                 eax

        $sequence_23 = { 0f9cc3 84d3 7504 30d3 }
            // n = 4, score = 700
            //   0f9cc3               | call                esp
            //   84d3                 | dec                 eax
            //   7504                 | mov                 ecx, esi
            //   30d3                 | mov                 edx, 0x80000000

        $sequence_24 = { c744242800000001 4533c9 4533c0 c744242002000000 ba1f000f00 }
            // n = 5, score = 700
            //   c744242800000001     | dec                 eax
            //   4533c9               | mov                 ebx, eax
            //   4533c0               | dec                 eax
            //   c744242002000000     | mov                 dword ptr [esp + 0x28], eax
            //   ba1f000f00           | dec                 eax

        $sequence_25 = { e8???????? 8bd8 ff15???????? 4d8bc7 }
            // n = 4, score = 700
            //   e8????????           |                     
            //   8bd8                 | xor                 eax, eax
            //   ff15????????         |                     
            //   4d8bc7               | mov                 eax, 0xff

        $sequence_26 = { ff15???????? 31db 4889c1 31d2 }
            // n = 4, score = 700
            //   ff15????????         |                     
            //   31db                 | inc                 ecx
            //   4889c1               | mov                 eax, 0x21000
            //   31d2                 | dec                 eax

        $sequence_27 = { e8???????? 4889f1 e8???????? 8b05???????? 8b0d???????? }
            // n = 5, score = 700
            //   e8????????           |                     
            //   4889f1               | dec                 eax
            //   e8????????           |                     
            //   8b05????????         |                     
            //   8b0d????????         |                     

        $sequence_28 = { 89d0 83f0fe 85d0 0f94c2 0f95c0 83f90a 0f9cc3 }
            // n = 7, score = 700
            //   89d0                 | mov                 eax, dword ptr [esp + 0x30]
            //   83f0fe               | dec                 eax
            //   85d0                 | mov                 eax, dword ptr [eax]
            //   0f94c2               | cmp                 dword ptr [eax + 0x28], 0
            //   0f95c0               | je                  0x99
            //   83f90a               | dec                 eax
            //   0f9cc3               | mov                 eax, dword ptr [esp + 0x30]

        $sequence_29 = { 0fb65305 33c0 80f973 0f94c0 }
            // n = 4, score = 700
            //   0fb65305             | movzx               ecx, word ptr [eax + ecx + 0x18]
            //   33c0                 | mov                 eax, 0x10b
            //   80f973               | cmp                 cx, ax
            //   0f94c0               | mov                 ecx, 0x1bb

        $sequence_30 = { 0fafd0 89d1 83f1fe 21d1 }
            // n = 4, score = 700
            //   0fafd0               | dec                 eax
            //   89d1                 | mov                 ecx, eax
            //   83f1fe               | xor                 edx, edx
            //   21d1                 | dec                 ecx

        $sequence_31 = { c744242880000000 c744242003000000 4889f9 ba00000080 41b801000000 }
            // n = 5, score = 700
            //   c744242880000000     | dec                 eax
            //   c744242003000000     | mov                 eax, dword ptr [esp + 0x30]
            //   4889f9               | cmp                 dword ptr [eax + 0x20], 0
            //   ba00000080           | je                  0x6b
            //   41b801000000         | dec                 eax

        $sequence_32 = { 31ed 4889c1 31d2 4989d8 }
            // n = 4, score = 700
            //   31ed                 | dec                 esp
            //   4889c1               | lea                 eax, [0x202a]
            //   31d2                 | dec                 eax
            //   4989d8               | mov                 edx, dword ptr [esp + 0x28]

        $sequence_33 = { 0f9cc3 83f909 0f9fc1 38d3 7507 08c1 }
            // n = 6, score = 700
            //   0f9cc3               | inc                 ecx
            //   83f909               | mov                 eax, 1
            //   0f9fc1               | inc                 ebp
            //   38d3                 | xor                 ecx, ecx
            //   7507                 | dec                 eax
            //   08c1                 | mov                 ecx, eax

        $sequence_34 = { 7528 0fb64b04 0fb6d1 80f973 }
            // n = 4, score = 700
            //   7528                 | dec                 eax
            //   0fb64b04             | mov                 ecx, esi
            //   0fb6d1               | dec                 eax
            //   80f973               | mov                 dword ptr [esp + 0x20], eax

        $sequence_35 = { 08c1 80f101 7502 ebfe }
            // n = 4, score = 700
            //   08c1                 | dec                 ecx
            //   80f101               | mov                 eax, esi
            //   7502                 | dec                 eax
            //   ebfe                 | mov                 ecx, eax

        $sequence_36 = { e8???????? 4c897c2420 4889d9 89fa }
            // n = 4, score = 600
            //   e8????????           |                     
            //   4c897c2420           | lea                 edx, [0x2fd0]
            //   4889d9               | dec                 eax
            //   89fa                 | lea                 ecx, [esp + 0x20]

        $sequence_37 = { 84d2 7405 80fa2e 750f 0fb6c1 }
            // n = 5, score = 600
            //   84d2                 | dec                 eax
            //   7405                 | lea                 eax, [esp + 0x70]
            //   80fa2e               | inc                 ecx
            //   750f                 | mov                 eax, 0x100f
            //   0fb6c1               | dec                 eax

        $sequence_38 = { 4889c1 31d2 4d89f8 ffd3 }
            // n = 4, score = 600
            //   4889c1               | mov                 dword ptr [esp + 0x80], eax
            //   31d2                 | cmp                 dword ptr [esp + 0x80], 0
            //   4d89f8               | jne                 0x27
            //   ffd3                 | dec                 eax

        $sequence_39 = { 31d2 4989d8 ff15???????? 488906 }
            // n = 4, score = 500
            //   31d2                 | movzx               edx, byte ptr [ebx + 5]
            //   4989d8               | xor                 eax, eax
            //   ff15????????         |                     
            //   488906               | cmp                 cl, 0x73

        $sequence_40 = { 4c8bf0 4889442458 488d4801 e8???????? }
            // n = 4, score = 500
            //   4c8bf0               | dec                 eax
            //   4889442458           | lea                 eax, [esp + 0x70]
            //   488d4801             | inc                 ecx
            //   e8????????           |                     

        $sequence_41 = { 4889fa 4189f0 4d89f1 ffd0 }
            // n = 4, score = 500
            //   4889fa               | cmp                 cl, 0x73
            //   4189f0               | sete                al
            //   4d89f1               | cmp                 cl, 0x73
            //   ffd0                 | jne                 0x15

        $sequence_42 = { 8d4833 ff15???????? c744242810000000 4533c9 }
            // n = 4, score = 500
            //   8d4833               | mov                 dword ptr [esp + 0x28], eax
            //   ff15????????         |                     
            //   c744242810000000     | dec                 eax
            //   4533c9               | lea                 edx, [ebp + 0x7a0]

        $sequence_43 = { 4889f1 ba00000080 41b801000000 4531c9 }
            // n = 4, score = 500
            //   4889f1               | mov                 dword ptr [esp + 0x30], eax
            //   ba00000080           | call                dword ptr [esp + 0x30]
            //   41b801000000         | mov                 eax, 1
            //   4531c9               | dec                 eax

        $sequence_44 = { 48c744243000000000 c744242880000000 c744242003000000 4889f1 ba00000080 }
            // n = 5, score = 500
            //   48c744243000000000     | imul    eax, eax, 0x10
            //   c744242880000000     | dec                 eax
            //   c744242003000000     | lea                 ecx, [0x238e3]
            //   4889f1               | dec                 eax
            //   ba00000080           | add                 ecx, eax

        $sequence_45 = { e8???????? 8bc8 e8???????? 8bf8 85ff 7507 6a05 }
            // n = 7, score = 400
            //   e8????????           |                     
            //   8bc8                 | mov                 ecx, eax
            //   e8????????           |                     
            //   8bf8                 | mov                 edi, eax
            //   85ff                 | test                edi, edi
            //   7507                 | jne                 9
            //   6a05                 | push                5

        $sequence_46 = { 3c0a 7223 89d0 24df 04bf 3c1a }
            // n = 6, score = 400
            //   3c0a                 | mov                 eax, dword ptr [esp + 0x2c]
            //   7223                 | mov                 dword ptr [esp + 0x38], eax
            //   89d0                 | dec                 eax
            //   24df                 | arpl                word ptr [esp + 0x30], ax
            //   04bf                 | dec                 eax
            //   3c1a                 | imul                eax, eax, 0x10

        $sequence_47 = { 84db 7402 ff06 8d4c2410 e8???????? 33d2 85c0 }
            // n = 7, score = 400
            //   84db                 | test                bl, bl
            //   7402                 | je                  4
            //   ff06                 | inc                 dword ptr [esi]
            //   8d4c2410             | lea                 ecx, [esp + 0x10]
            //   e8????????           |                     
            //   33d2                 | xor                 edx, edx
            //   85c0                 | test                eax, eax

        $sequence_48 = { 66890d???????? 0fb7ca ff15???????? b901000000 66c746020100 668906 }
            // n = 6, score = 400
            //   66890d????????       |                     
            //   0fb7ca               | test                eax, eax
            //   ff15????????         |                     
            //   b901000000           | je                  0xf
            //   66c746020100         | dec                 eax
            //   668906               | mov                 ecx, edi

        $sequence_49 = { 7506 8b0e 894c2460 0fb7c0 }
            // n = 4, score = 400
            //   7506                 | dec                 eax
            //   8b0e                 | mov                 dword ptr [esp + 0x20], eax
            //   894c2460             | inc                 ecx
            //   0fb7c0               | mov                 eax, 0x100f

        $sequence_50 = { 686af17afc 6a04 5a e8???????? 59 }
            // n = 5, score = 400
            //   686af17afc           | push                0xfc7af16a
            //   6a04                 | push                4
            //   5a                   | pop                 edx
            //   e8????????           |                     
            //   59                   | pop                 ecx

        $sequence_51 = { 6685ff 0f849c000000 837c2460ff 0f858c000000 }
            // n = 4, score = 400
            //   6685ff               | inc                 ecx
            //   0f849c000000         | mov                 eax, 0x100f
            //   837c2460ff           | dec                 eax
            //   0f858c000000         | mov                 ecx, esi

        $sequence_52 = { 33d2 8d8d00ffffff e8???????? eb18 51 8d4e01 e8???????? }
            // n = 7, score = 400
            //   33d2                 | xor                 edx, edx
            //   8d8d00ffffff         | lea                 ecx, [ebp - 0x100]
            //   e8????????           |                     
            //   eb18                 | jmp                 0x1a
            //   51                   | push                ecx
            //   8d4e01               | lea                 ecx, [esi + 1]
            //   e8????????           |                     

        $sequence_53 = { 59 59 85c0 740b 8bc8 c60100 41 }
            // n = 7, score = 400
            //   59                   | pop                 ecx
            //   59                   | pop                 ecx
            //   85c0                 | test                eax, eax
            //   740b                 | je                  0xd
            //   8bc8                 | mov                 ecx, eax
            //   c60100               | mov                 byte ptr [ecx], 0
            //   41                   | inc                 ecx

        $sequence_54 = { 50 0fb745e8 50 68???????? e8???????? }
            // n = 5, score = 400
            //   50                   | push                eax
            //   0fb745e8             | movzx               eax, word ptr [ebp - 0x18]
            //   50                   | push                eax
            //   68????????           |                     
            //   e8????????           |                     

        $sequence_55 = { 51 8b4d00 03cf e8???????? 59 3b442414 }
            // n = 6, score = 400
            //   51                   | push                ecx
            //   8b4d00               | mov                 ecx, dword ptr [ebp]
            //   03cf                 | add                 ecx, edi
            //   e8????????           |                     
            //   59                   | pop                 ecx
            //   3b442414             | cmp                 eax, dword ptr [esp + 0x14]

        $sequence_56 = { 0fb7d8 0fb74708 50 ff15???????? 0fb7c8 }
            // n = 5, score = 300
            //   0fb7d8               | movzx               ebx, ax
            //   0fb74708             | movzx               eax, word ptr [edi + 8]
            //   50                   | push                eax
            //   ff15????????         |                     
            //   0fb7c8               | movzx               ecx, ax

        $sequence_57 = { 6a00 ffd3 50 ffd6 33c0 5f 5e }
            // n = 7, score = 300
            //   6a00                 | push                0
            //   ffd3                 | call                ebx
            //   50                   | push                eax
            //   ffd6                 | call                esi
            //   33c0                 | xor                 eax, eax
            //   5f                   | pop                 edi
            //   5e                   | pop                 esi

        $sequence_58 = { 83f902 0f95c2 83c224 eb05 ba29000000 }
            // n = 5, score = 300
            //   83f902               | cmp                 ecx, 2
            //   0f95c2               | setne               dl
            //   83c224               | add                 edx, 0x24
            //   eb05                 | jmp                 7
            //   ba29000000           | mov                 edx, 0x29

        $sequence_59 = { 8be5 5d c3 6a40 6800300000 ff7750 }
            // n = 6, score = 300
            //   8be5                 | dec                 eax
            //   5d                   | mov                 dword ptr [esp + 0x20], eax
            //   c3                   | dec                 eax
            //   6a40                 | lea                 edx, [ebp + 0x7a0]
            //   6800300000           | dec                 eax
            //   ff7750               | lea                 eax, [esp + 0x70]

        $sequence_60 = { 8d450c 50 ff7508 56 ff15???????? 6a00 }
            // n = 6, score = 300
            //   8d450c               | lea                 eax, [ebp + 0xc]
            //   50                   | push                eax
            //   ff7508               | push                dword ptr [ebp + 8]
            //   56                   | push                esi
            //   ff15????????         |                     
            //   6a00                 | push                0

        $sequence_61 = { 660f73d801 660febd0 660f7ed0 84c0 }
            // n = 4, score = 300
            //   660f73d801           | psrldq              xmm0, 1
            //   660febd0             | por                 xmm2, xmm0
            //   660f7ed0             | movd                eax, xmm2
            //   84c0                 | test                al, al

        $sequence_62 = { 83c40c 8d4101 51 66a3???????? ff15???????? }
            // n = 5, score = 300
            //   83c40c               | add                 esp, 0xc
            //   8d4101               | lea                 eax, [ecx + 1]
            //   51                   | push                ecx
            //   66a3????????         |                     
            //   ff15????????         |                     

        $sequence_63 = { 8d7001 81fe80000000 760c 80e1f2 80c902 }
            // n = 5, score = 300
            //   8d7001               | lea                 eax, [esp + 0x70]
            //   81fe80000000         | inc                 ecx
            //   760c                 | mov                 eax, 0x100f
            //   80e1f2               | dec                 eax
            //   80c902               | mov                 ecx, esi

        $sequence_64 = { 68???????? e8???????? 83c410 b800308804 6a00 }
            // n = 5, score = 300
            //   68????????           |                     
            //   e8????????           |                     
            //   83c410               | add                 esp, 0x10
            //   b800308804           | mov                 eax, 0x4883000
            //   6a00                 | push                0

        $sequence_65 = { 85d2 740d 33d2 83f902 0f95c2 }
            // n = 5, score = 300
            //   85d2                 | test                edx, edx
            //   740d                 | je                  0xf
            //   33d2                 | xor                 edx, edx
            //   83f902               | cmp                 ecx, 2
            //   0f95c2               | setne               dl

        $sequence_66 = { 0f848c000000 488b442430 83782000 7460 488b442430 }
            // n = 5, score = 100
            //   0f848c000000         | dec                 eax
            //   488b442430           | mov                 dword ptr [esp + 0x20], eax
            //   83782000             | test                eax, eax
            //   7460                 | js                  0x13
            //   488b442430           | dec                 eax

        $sequence_67 = { 7460 488b442430 488b00 8b4028 488b4c2440 4803c8 488bc1 }
            // n = 7, score = 100
            //   7460                 | dec                 eax
            //   488b442430           | mov                 dword ptr [esp + 0x20], eax
            //   488b00               | test                eax, eax
            //   8b4028               | js                  0xe
            //   488b4c2440           | inc                 ebp
            //   4803c8               | xor                 eax, eax
            //   488bc1               | call                eax

        $sequence_68 = { 89442424 48c744242800000000 41b800100200 488d15d02f0000 488d4c2420 }
            // n = 5, score = 100
            //   89442424             | lea                 ecx, [edx + 0x7d]
            //   48c744242800000000     | dec    eax
            //   41b800100200         | test                eax, eax
            //   488d15d02f0000       | je                  0x11
            //   488d4c2420           | dec                 eax

        $sequence_69 = { 4863442430 486bc010 488d0de3380200 4803c8 }
            // n = 4, score = 100
            //   4863442430           | cwde                
            //   486bc010             | inc                 ecx
            //   488d0de3380200       | mov                 eax, 0x100f
            //   4803c8               | dec                 eax

        $sequence_70 = { 488d0de3380200 4803c8 488bc1 48634c2434 488d04c8 48634c2438 8b0488 }
            // n = 7, score = 100
            //   488d0de3380200       | cwde                
            //   4803c8               | test                eax, eax
            //   488bc1               | js                  0xe
            //   48634c2434           | dec                 eax
            //   488d04c8             | cwde                
            //   48634c2438           | inc                 ecx
            //   8b0488               | mov                 eax, 0x100f

        $sequence_71 = { 4533c0 ba01000000 488b4c2440 ff9424a0000000 89842480000000 83bc248000000000 }
            // n = 6, score = 100
            //   4533c0               | dec                 eax
            //   ba01000000           | mov                 ecx, esi
            //   488b4c2440           | dec                 eax
            //   ff9424a0000000       | mov                 dword ptr [esp + 0x20], eax
            //   89842480000000       | dec                 eax
            //   83bc248000000000     | mov                 ecx, esi

        $sequence_72 = { 488d4c2420 e8???????? 4889442428 4c8d052a200000 }
            // n = 4, score = 100
            //   488d4c2420           | test                eax, eax
            //   e8????????           |                     
            //   4889442428           | js                  0xe
            //   4c8d052a200000       | dec                 eax

        $sequence_73 = { 4c8d052a200000 488b542428 488d4c2420 e8???????? 4889442430 ff542430 }
            // n = 6, score = 100
            //   4c8d052a200000       | js                  0x22
            //   488b542428           | inc                 ecx
            //   488d4c2420           | mov                 eax, 0x100f
            //   e8????????           |                     
            //   4889442430           | dec                 eax
            //   ff542430             | mov                 ecx, esi

    condition:
        7 of them and filesize < 2088960
}