rule win_beardshell_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2026-01-05"
        version = "1"
        description = "Detects win.beardshell."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.beardshell"
        malpedia_rule_date = "20260105"
        malpedia_hash = "19b79e7cab4eaf532122e5b45a77dd8f6bb5cc79"
        malpedia_version = "20251219"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 488d55c0 498bcc 488b4038 ff15???????? 410fbaed0e 4183cd20 44896c243c }
            // n = 7, score = 100
            //   488d55c0             | dec                 eax
            //   498bcc               | mov                 eax, dword ptr [esp + 0x28]
            //   488b4038             | mov                 dword ptr [eax + 0x28], 3
            //   ff15????????         |                     
            //   410fbaed0e           | dec                 eax
            //   4183cd20             | mov                 eax, dword ptr [esp + 0x28]
            //   44896c243c           | dec                 eax

        $sequence_1 = { 8a44246f 4c8b4c2460 488b542460 448a442440 88442420 e8???????? 4889442470 }
            // n = 7, score = 100
            //   8a44246f             | jmp                 0xa2c
            //   4c8b4c2460           | dec                 ecx
            //   488b542460           | and                 dword ptr [edi], 0
            //   448a442440           | inc                 ecx
            //   88442420             | mov                 al, ah
            //   e8????????           |                     
            //   4889442470           | inc                 ecx

        $sequence_2 = { e8???????? 488b4c2430 4c8d442460 4983c008 488d542458 e8???????? 488b4c2470 }
            // n = 7, score = 100
            //   e8????????           |                     
            //   488b4c2430           | dec                 eax
            //   4c8d442460           | mov                 ecx, dword ptr [esp + 0x70]
            //   4983c008             | dec                 eax
            //   488d542458           | mov                 dword ptr [esp + 0x38], ecx
            //   e8????????           |                     
            //   488b4c2470           | dec                 eax

        $sequence_3 = { e9???????? 488b8424b8000000 4889842488000000 4c8b442458 48634c2448 31c0 4829c8 }
            // n = 7, score = 100
            //   e9????????           |                     
            //   488b8424b8000000     | mov                 ecx, ebx
            //   4889842488000000     | dec                 eax
            //   4c8b442458           | mov                 eax, ebx
            //   48634c2448           | dec                 eax
            //   31c0                 | add                 esp, 0x30
            //   4829c8               | dec                 eax

        $sequence_4 = { 488b4010 4883e00f 4889442448 48837c244800 0f84ce000000 488b442450 }
            // n = 6, score = 100
            //   488b4010             | lea                 ecx, [0xc52a1]
            //   4883e00f             | test                cl, 1
            //   4889442448           | mov                 byte ptr [ebp - 1], al
            //   48837c244800         | jne                 0x1b5
            //   0f84ce000000         | dec                 eax
            //   488b442450           | lea                 ecx, [0xc52f1]

        $sequence_5 = { 0fbf1448 c1ea02 b901000000 84d1 7510 837d4004 7594 }
            // n = 7, score = 100
            //   0fbf1448             | dec                 eax
            //   c1ea02               | mov                 dword ptr [ecx + eax + 0x10], edx
            //   b901000000           | dec                 eax
            //   84d1                 | mov                 eax, dword ptr [esp + 0x40]
            //   7510                 | dec                 eax
            //   837d4004             | mov                 edx, dword ptr [esp + 0x50]
            //   7594                 | dec                 esp

        $sequence_6 = { 410f104500 f30f7f4587 48897c2420 440fb74c2440 4c8d4587 488d55b7 488bce }
            // n = 7, score = 100
            //   410f104500           | add                 ecx, 2
            //   f30f7f4587           | mov                 ecx, ecx
            //   48897c2420           | mov                 byte ptr [eax + ecx], dl
            //   440fb74c2440         | mov                 eax, dword ptr [esp + 0x70]
            //   4c8d4587             | dec                 eax
            //   488d55b7             | mov                 eax, dword ptr [esp + 0xb8]
            //   488bce               | mov                 ecx, dword ptr [esp + 0x70]

        $sequence_7 = { e9???????? c644245f31 8b442460 83e87f 89442458 488b842480000000 483b842488000000 }
            // n = 7, score = 100
            //   e9????????           |                     
            //   c644245f31           | dec                 eax
            //   8b442460             | mov                 edx, dword ptr [esp + 0x40]
            //   83e87f               | dec                 eax
            //   89442458             | mov                 ecx, dword ptr [esp + 0x48]
            //   488b842480000000     | dec                 eax
            //   483b842488000000     | mov                 dword ptr [esp + 0x38], eax

        $sequence_8 = { 4889c1 488b442430 48894c2440 488b4c2450 48894810 66448b44245e 488b542450 }
            // n = 7, score = 100
            //   4889c1               | sub                 esp, 0x28
            //   488b442430           | jne                 0x3a9
            //   48894c2440           | dec                 eax
            //   488b4c2450           | test                ecx, ecx
            //   48894810             | pop                 edi
            //   66448b44245e         | ret                 
            //   488b542450           | dec                 eax

        $sequence_9 = { e8???????? e9???????? 488b4c2448 e8???????? 488b4c2430 6689c2 e8???????? }
            // n = 7, score = 100
            //   e8????????           |                     
            //   e9????????           |                     
            //   488b4c2448           | dec                 esp
            //   e8????????           |                     
            //   488b4c2430           | mov                 dword ptr [esp + 0x58], eax
            //   6689c2               | dec                 eax
            //   e8????????           |                     

    condition:
        7 of them and filesize < 2416640
}