rule win_beatdrop_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2026-01-05"
        version = "1"
        description = "Detects win.beatdrop."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.beatdrop"
        malpedia_rule_date = "20260105"
        malpedia_hash = "19b79e7cab4eaf532122e5b45a77dd8f6bb5cc79"
        malpedia_version = "20251219"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 47339c8d000c0000 413384bd00080000 4133948d00080000 44335d60 0fb6d8 0fb6cc 4189d1 }
            // n = 7, score = 400
            //   47339c8d000c0000     | mov                 ecx, esi
            //   413384bd00080000     | dec                 esp
            //   4133948d00080000     | lea                 edi, [esp + 0x60]
            //   44335d60             | inc                 ecx
            //   0fb6d8               | mov                 eax, esi
            //   0fb6cc               | dec                 esp
            //   4189d1               | mov                 edx, esi

        $sequence_1 = { 33557c 413384bd000c0000 4489cf 334578 41c1eb18 }
            // n = 5, score = 400
            //   33557c               | dec                 esp
            //   413384bd000c0000     | mov                 ecx, esp
            //   4489cf               | dec                 esp
            //   334578               | lea                 eax, [0xffff9ee6]
            //   41c1eb18             | dec                 eax

        $sequence_2 = { 443385a4000000 450fb6d2 4733849500040000 450fb6d7 }
            // n = 4, score = 400
            //   443385a4000000       | mov                 ebx, dword ptr [esp + edx*4]
            //   450fb6d2             | inc                 ebx
            //   4733849500040000     | xor                 ebx, dword ptr [esp + ebx*4 + 0xc00]
            //   450fb6d7             | shr                 eax, 0x10

        $sequence_3 = { 4c3b6610 740f 4c89e1 e8???????? }
            // n = 4, score = 400
            //   4c3b6610             | dec                 eax
            //   740f                 | lea                 edx, [esp + 0x1f0]
            //   4c89e1               | dec                 eax
            //   e8????????           |                     

        $sequence_4 = { 4409c8 4133470c 448b7c2418 89aef8000000 }
            // n = 4, score = 400
            //   4409c8               | inc                 ecx
            //   4133470c             | shr                 ebx, 0x10
            //   448b7c2418           | inc                 esp
            //   89aef8000000         | xor                 ecx, dword ptr [esi + 0x48]

        $sequence_5 = { 47338495000c0000 4189c2 0fb6cd 41c1ea10 443385a4000000 450fb6d2 4733849500040000 }
            // n = 7, score = 400
            //   47338495000c0000     | mov                 ecx, esp
            //   4189c2               | dec                 ecx
            //   0fb6cd               | mov                 ebp, eax
            //   41c1ea10             | dec                 esp
            //   443385a4000000       | mov                 ecx, esp
            //   450fb6d2             | dec                 eax
            //   4733849500040000     | lea                 edx, [0x8a5f]

        $sequence_6 = { c1ea10 338590000000 458b74b500 4489c1 0fb6d2 }
            // n = 5, score = 400
            //   c1ea10               | dec                 eax
            //   338590000000         | mov                 ecx, esi
            //   458b74b500           | dec                 eax
            //   4489c1               | lea                 ecx, [esp + 0x350]
            //   0fb6d2               | dec                 eax

        $sequence_7 = { 41c1ef18 0fb6cd 44897c2418 894c2404 89c1 0fb6c0 c1e918 }
            // n = 7, score = 400
            //   41c1ef18             | dec                 ecx
            //   0fb6cd               | mov                 esi, esi
            //   44897c2418           | dec                 eax
            //   894c2404             | cmovne              ebp, ebx
            //   89c1                 | dec                 eax
            //   0fb6c0               | lea                 ecx, [0x9b45]
            //   c1e918               | nop                 

        $sequence_8 = { c1e818 4489d1 450fb6da 418b448500 41338495000c0000 }
            // n = 5, score = 400
            //   c1e818               | dec                 eax
            //   4489d1               | lea                 ecx, [esp + 0x3e0]
            //   450fb6da             | dec                 eax
            //   418b448500           | mov                 ecx, esi
            //   41338495000c0000     | dec                 eax

        $sequence_9 = { 4133948c00080000 89c1 0fb6ef 440fb6c2 }
            // n = 4, score = 400
            //   4133948c00080000     | inc                 ecx
            //   89c1                 | shr                 ebx, 0x18
            //   0fb6ef               | shr                 edi, 0x10
            //   440fb6c2             | inc                 ecx

    condition:
        7 of them and filesize < 584704
}