rule win_beepservice_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2026-01-05"
        version = "1"
        description = "Detects win.beepservice."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.beepservice"
        malpedia_rule_date = "20260105"
        malpedia_hash = "19b79e7cab4eaf532122e5b45a77dd8f6bb5cc79"
        malpedia_version = "20251219"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 8b0d???????? 68???????? ffd6 8bc8 }
            // n = 4, score = 600
            //   8b0d????????         |                     
            //   68????????           |                     
            //   ffd6                 | call                esi
            //   8bc8                 | mov                 ecx, eax

        $sequence_1 = { ffd6 8bc8 ff15???????? 50 ff15???????? }
            // n = 5, score = 600
            //   ffd6                 | call                esi
            //   8bc8                 | mov                 ecx, eax
            //   ff15????????         |                     
            //   50                   | push                eax
            //   ff15????????         |                     

        $sequence_2 = { 683f000f00 6a00 68???????? ff15???????? }
            // n = 4, score = 500
            //   683f000f00           | push                0xf003f
            //   6a00                 | push                0
            //   68????????           |                     
            //   ff15????????         |                     

        $sequence_3 = { e8???????? 83f801 7505 e8???????? 68???????? 68???????? }
            // n = 6, score = 500
            //   e8????????           |                     
            //   83f801               | cmp                 eax, 1
            //   7505                 | jne                 7
            //   e8????????           |                     
            //   68????????           |                     
            //   68????????           |                     

        $sequence_4 = { 7512 6888130000 68???????? e8???????? 83c408 }
            // n = 5, score = 500
            //   7512                 | jne                 0x14
            //   6888130000           | push                0x1388
            //   68????????           |                     
            //   e8????????           |                     
            //   83c408               | add                 esp, 8

        $sequence_5 = { 83c408 e9???????? 68???????? e8???????? 83c404 6a00 6a00 }
            // n = 7, score = 500
            //   83c408               | add                 esp, 8
            //   e9????????           |                     
            //   68????????           |                     
            //   e8????????           |                     
            //   83c404               | add                 esp, 4
            //   6a00                 | push                0
            //   6a00                 | push                0

        $sequence_6 = { 8d85fcfdffff 56 56 6a02 56 56 }
            // n = 6, score = 400
            //   8d85fcfdffff         | lea                 eax, [ebp - 0x204]
            //   56                   | push                esi
            //   56                   | push                esi
            //   6a02                 | push                2
            //   56                   | push                esi
            //   56                   | push                esi

        $sequence_7 = { 6a20 57 bf???????? 57 }
            // n = 4, score = 400
            //   6a20                 | push                0x20
            //   57                   | push                edi
            //   bf????????           |                     
            //   57                   | push                edi

        $sequence_8 = { 68???????? e8???????? ff7608 e8???????? 83c40c }
            // n = 5, score = 400
            //   68????????           |                     
            //   e8????????           |                     
            //   ff7608               | push                dword ptr [esi + 8]
            //   e8????????           |                     
            //   83c40c               | add                 esp, 0xc

        $sequence_9 = { ff7614 e8???????? 50 ff7614 57 e8???????? 83c42c }
            // n = 7, score = 400
            //   ff7614               | push                dword ptr [esi + 0x14]
            //   e8????????           |                     
            //   50                   | push                eax
            //   ff7614               | push                dword ptr [esi + 0x14]
            //   57                   | push                edi
            //   e8????????           |                     
            //   83c42c               | add                 esp, 0x2c

        $sequence_10 = { 6a02 50 55 e8???????? ff7610 e8???????? 50 }
            // n = 7, score = 400
            //   6a02                 | push                2
            //   50                   | push                eax
            //   55                   | push                ebp
            //   e8????????           |                     
            //   ff7610               | push                dword ptr [esi + 0x10]
            //   e8????????           |                     
            //   50                   | push                eax

        $sequence_11 = { e8???????? 83c444 8d442410 6a02 }
            // n = 4, score = 400
            //   e8????????           |                     
            //   83c444               | add                 esp, 0x44
            //   8d442410             | lea                 eax, [esp + 0x10]
            //   6a02                 | push                2

        $sequence_12 = { 85f6 7403 56 ffd7 53 ffd7 5f }
            // n = 7, score = 300
            //   85f6                 | test                esi, esi
            //   7403                 | je                  5
            //   56                   | push                esi
            //   ffd7                 | call                edi
            //   53                   | push                ebx
            //   ffd7                 | call                edi
            //   5f                   | pop                 edi

        $sequence_13 = { b90a000000 a3???????? bf???????? a3???????? }
            // n = 4, score = 300
            //   b90a000000           | mov                 ecx, 0xa
            //   a3????????           |                     
            //   bf????????           |                     
            //   a3????????           |                     

        $sequence_14 = { 8b5c240c 8b3d???????? 85f6 7403 }
            // n = 4, score = 300
            //   8b5c240c             | mov                 ebx, dword ptr [esp + 0xc]
            //   8b3d????????         |                     
            //   85f6                 | test                esi, esi
            //   7403                 | je                  5

        $sequence_15 = { 741e 45 83fd0a 7ce0 eb23 ff15???????? }
            // n = 6, score = 300
            //   741e                 | je                  0x20
            //   45                   | inc                 ebp
            //   83fd0a               | cmp                 ebp, 0xa
            //   7ce0                 | jl                  0xffffffe2
            //   eb23                 | jmp                 0x25
            //   ff15????????         |                     

        $sequence_16 = { ffd7 8d442414 50 56 }
            // n = 4, score = 300
            //   ffd7                 | call                edi
            //   8d442414             | lea                 eax, [esp + 0x14]
            //   50                   | push                eax
            //   56                   | push                esi

        $sequence_17 = { c785f8fdffff00240000 6a00 8d95f4fdffff 52 8b85f8fdffff 50 }
            // n = 6, score = 200
            //   c785f8fdffff00240000     | mov    dword ptr [ebp - 0x208], 0x2400
            //   6a00                 | push                0
            //   8d95f4fdffff         | lea                 edx, [ebp - 0x20c]
            //   52                   | push                edx
            //   8b85f8fdffff         | mov                 eax, dword ptr [ebp - 0x208]
            //   50                   | push                eax

        $sequence_18 = { 83f81e 720a b801000000 e9???????? 8b450c 8b480c }
            // n = 6, score = 200
            //   83f81e               | cmp                 eax, 0x1e
            //   720a                 | jb                  0xc
            //   b801000000           | mov                 eax, 1
            //   e9????????           |                     
            //   8b450c               | mov                 eax, dword ptr [ebp + 0xc]
            //   8b480c               | mov                 ecx, dword ptr [eax + 0xc]

        $sequence_19 = { 8b85f8fdffff 50 68???????? 8b8dfcfdffff 51 ff15???????? }
            // n = 6, score = 200
            //   8b85f8fdffff         | mov                 eax, dword ptr [ebp - 0x208]
            //   50                   | push                eax
            //   68????????           |                     
            //   8b8dfcfdffff         | mov                 ecx, dword ptr [ebp - 0x204]
            //   51                   | push                ecx
            //   ff15????????         |                     

        $sequence_20 = { 8b5108 52 68???????? e8???????? 83c40c 6a02 }
            // n = 6, score = 200
            //   8b5108               | mov                 edx, dword ptr [ecx + 8]
            //   52                   | push                edx
            //   68????????           |                     
            //   e8????????           |                     
            //   83c40c               | add                 esp, 0xc
            //   6a02                 | push                2

        $sequence_21 = { 50 e8???????? 83c404 c3 6a00 6a00 }
            // n = 6, score = 100
            //   50                   | push                eax
            //   e8????????           |                     
            //   83c404               | add                 esp, 4
            //   c3                   | ret                 
            //   6a00                 | push                0
            //   6a00                 | push                0

        $sequence_22 = { a1???????? 85c0 746b a1???????? 85c0 7562 }
            // n = 6, score = 100
            //   a1????????           |                     
            //   85c0                 | test                eax, eax
            //   746b                 | je                  0x6d
            //   a1????????           |                     
            //   85c0                 | test                eax, eax
            //   7562                 | jne                 0x64

        $sequence_23 = { 48 83f804 0f8795000000 ff248548144000 6888130000 6a01 6a00 }
            // n = 7, score = 100
            //   48                   | dec                 eax
            //   83f804               | cmp                 eax, 4
            //   0f8795000000         | ja                  0x9b
            //   ff248548144000       | jmp                 dword ptr [eax*4 + 0x401448]
            //   6888130000           | push                0x1388
            //   6a01                 | push                1
            //   6a00                 | push                0

        $sequence_24 = { 85c9 668935???????? 7e15 b299 8a9874304000 32da }
            // n = 6, score = 100
            //   85c9                 | test                ecx, ecx
            //   668935????????       |                     
            //   7e15                 | jle                 0x17
            //   b299                 | mov                 dl, 0x99
            //   8a9874304000         | mov                 bl, byte ptr [eax + 0x403074]
            //   32da                 | xor                 bl, dl

        $sequence_25 = { 83c414 e8???????? 6a00 6a00 b907000000 6a00 }
            // n = 6, score = 100
            //   83c414               | add                 esp, 0x14
            //   e8????????           |                     
            //   6a00                 | push                0
            //   6a00                 | push                0
            //   b907000000           | mov                 ecx, 7
            //   6a00                 | push                0

        $sequence_26 = { 57 33f6 8975d8 8975e0 8975e4 8975dc 8975fc }
            // n = 7, score = 100
            //   57                   | push                edi
            //   33f6                 | xor                 esi, esi
            //   8975d8               | mov                 dword ptr [ebp - 0x28], esi
            //   8975e0               | mov                 dword ptr [ebp - 0x20], esi
            //   8975e4               | mov                 dword ptr [ebp - 0x1c], esi
            //   8975dc               | mov                 dword ptr [ebp - 0x24], esi
            //   8975fc               | mov                 dword ptr [ebp - 4], esi

        $sequence_27 = { 83c404 c3 8b0d???????? 6aff 51 }
            // n = 5, score = 100
            //   83c404               | add                 esp, 4
            //   c3                   | ret                 
            //   8b0d????????         |                     
            //   6aff                 | push                -1
            //   51                   | push                ecx

        $sequence_28 = { 6a03 e8???????? 83c414 e9???????? a1???????? }
            // n = 5, score = 100
            //   6a03                 | push                3
            //   e8????????           |                     
            //   83c414               | add                 esp, 0x14
            //   e9????????           |                     
            //   a1????????           |                     

    condition:
        7 of them and filesize < 253952
}