rule win_betabot_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2026-01-05"
        version = "1"
        description = "Detects win.betabot."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.betabot"
        malpedia_rule_date = "20260105"
        malpedia_hash = "19b79e7cab4eaf532122e5b45a77dd8f6bb5cc79"
        malpedia_version = "20251219"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { f7d0 2345fc eb02 33c0 c9 c20800 55 }
            // n = 7, score = 400
            //   f7d0                 | not                 eax
            //   2345fc               | and                 eax, dword ptr [ebp - 4]
            //   eb02                 | jmp                 4
            //   33c0                 | xor                 eax, eax
            //   c9                   | leave               
            //   c20800               | ret                 8
            //   55                   | push                ebp

        $sequence_1 = { ff15???????? 85c0 7413 8d4df8 e8???????? 50 8d45f8 }
            // n = 7, score = 400
            //   ff15????????         |                     
            //   85c0                 | test                eax, eax
            //   7413                 | je                  0x15
            //   8d4df8               | lea                 ecx, [ebp - 8]
            //   e8????????           |                     
            //   50                   | push                eax
            //   8d45f8               | lea                 eax, [ebp - 8]

        $sequence_2 = { 7440 8d45f4 50 8d45f8 50 ff75fc ff15???????? }
            // n = 7, score = 400
            //   7440                 | je                  0x42
            //   8d45f4               | lea                 eax, [ebp - 0xc]
            //   50                   | push                eax
            //   8d45f8               | lea                 eax, [ebp - 8]
            //   50                   | push                eax
            //   ff75fc               | push                dword ptr [ebp - 4]
            //   ff15????????         |                     

        $sequence_3 = { 8bc6 83e80c 53 57 741d 48 7551 }
            // n = 7, score = 400
            //   8bc6                 | mov                 eax, esi
            //   83e80c               | sub                 eax, 0xc
            //   53                   | push                ebx
            //   57                   | push                edi
            //   741d                 | je                  0x1f
            //   48                   | dec                 eax
            //   7551                 | jne                 0x53

        $sequence_4 = { 8bec 81ecac000000 8365f800 8365f000 8365f400 8365fc00 }
            // n = 6, score = 400
            //   8bec                 | mov                 ebp, esp
            //   81ecac000000         | sub                 esp, 0xac
            //   8365f800             | and                 dword ptr [ebp - 8], 0
            //   8365f000             | and                 dword ptr [ebp - 0x10], 0
            //   8365f400             | and                 dword ptr [ebp - 0xc], 0
            //   8365fc00             | and                 dword ptr [ebp - 4], 0

        $sequence_5 = { ff15???????? 85c0 7504 6a06 eb11 68???????? }
            // n = 6, score = 400
            //   ff15????????         |                     
            //   85c0                 | test                eax, eax
            //   7504                 | jne                 6
            //   6a06                 | push                6
            //   eb11                 | jmp                 0x13
            //   68????????           |                     

        $sequence_6 = { 741a 837df800 7414 8b45f8 8b4804 e8???????? 8945fc }
            // n = 7, score = 400
            //   741a                 | je                  0x1c
            //   837df800             | cmp                 dword ptr [ebp - 8], 0
            //   7414                 | je                  0x16
            //   8b45f8               | mov                 eax, dword ptr [ebp - 8]
            //   8b4804               | mov                 ecx, dword ptr [eax + 4]
            //   e8????????           |                     
            //   8945fc               | mov                 dword ptr [ebp - 4], eax

        $sequence_7 = { a3???????? 8bc7 5f 5e 5d c20400 55 }
            // n = 7, score = 400
            //   a3????????           |                     
            //   8bc7                 | mov                 eax, edi
            //   5f                   | pop                 edi
            //   5e                   | pop                 esi
            //   5d                   | pop                 ebp
            //   c20400               | ret                 4
            //   55                   | push                ebp

        $sequence_8 = { ff15???????? 85c0 75df 6a32 58 ebdc 55 }
            // n = 7, score = 400
            //   ff15????????         |                     
            //   85c0                 | test                eax, eax
            //   75df                 | jne                 0xffffffe1
            //   6a32                 | push                0x32
            //   58                   | pop                 eax
            //   ebdc                 | jmp                 0xffffffde
            //   55                   | push                ebp

        $sequence_9 = { 8d04b8 833800 7414 ff30 ff45fc e8???????? 8b460c }
            // n = 7, score = 400
            //   8d04b8               | lea                 eax, [eax + edi*4]
            //   833800               | cmp                 dword ptr [eax], 0
            //   7414                 | je                  0x16
            //   ff30                 | push                dword ptr [eax]
            //   ff45fc               | inc                 dword ptr [ebp - 4]
            //   e8????????           |                     
            //   8b460c               | mov                 eax, dword ptr [esi + 0xc]

    condition:
        7 of them and filesize < 835584
}