rule win_bh_a006_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2026-01-05"
        version = "1"
        description = "Detects win.bh_a006."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.bh_a006"
        malpedia_rule_date = "20260105"
        malpedia_hash = "19b79e7cab4eaf532122e5b45a77dd8f6bb5cc79"
        malpedia_version = "20251219"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 8bca 2b08 03cb 8930 }
            // n = 4, score = 100
            //   8bca                 | mov                 ecx, edx
            //   2b08                 | sub                 ecx, dword ptr [eax]
            //   03cb                 | add                 ecx, ebx
            //   8930                 | mov                 dword ptr [eax], esi

        $sequence_1 = { 6683bdecdfffff00 8dbdecdfffff 7436 57 }
            // n = 4, score = 100
            //   6683bdecdfffff00     | cmp                 word ptr [ebp - 0x2014], 0
            //   8dbdecdfffff         | lea                 edi, [ebp - 0x2014]
            //   7436                 | je                  0x38
            //   57                   | push                edi

        $sequence_2 = { 88041a 42 884517 8955f4 e9???????? 2bf0 }
            // n = 6, score = 100
            //   88041a               | mov                 byte ptr [edx + ebx], al
            //   42                   | inc                 edx
            //   884517               | mov                 byte ptr [ebp + 0x17], al
            //   8955f4               | mov                 dword ptr [ebp - 0xc], edx
            //   e9????????           |                     
            //   2bf0                 | sub                 esi, eax

        $sequence_3 = { 85ff 7472 8d45fc 50 }
            // n = 4, score = 100
            //   85ff                 | test                edi, edi
            //   7472                 | je                  0x74
            //   8d45fc               | lea                 eax, [ebp - 4]
            //   50                   | push                eax

        $sequence_4 = { 8b95e4deffff 59 83e201 c1e202 6a04 59 }
            // n = 6, score = 100
            //   8b95e4deffff         | mov                 edx, dword ptr [ebp - 0x211c]
            //   59                   | pop                 ecx
            //   83e201               | and                 edx, 1
            //   c1e202               | shl                 edx, 2
            //   6a04                 | push                4
            //   59                   | pop                 ecx

        $sequence_5 = { 8985d4ddffff 8985d8ddffff 8985dcddffff 8945fc }
            // n = 4, score = 100
            //   8985d4ddffff         | mov                 dword ptr [ebp - 0x222c], eax
            //   8985d8ddffff         | mov                 dword ptr [ebp - 0x2228], eax
            //   8985dcddffff         | mov                 dword ptr [ebp - 0x2224], eax
            //   8945fc               | mov                 dword ptr [ebp - 4], eax

        $sequence_6 = { 898de4deffff 3bcb 7cbb 8bb5d8deffff 33db 8b85d0deffff 56 }
            // n = 7, score = 100
            //   898de4deffff         | mov                 dword ptr [ebp - 0x211c], ecx
            //   3bcb                 | cmp                 ecx, ebx
            //   7cbb                 | jl                  0xffffffbd
            //   8bb5d8deffff         | mov                 esi, dword ptr [ebp - 0x2128]
            //   33db                 | xor                 ebx, ebx
            //   8b85d0deffff         | mov                 eax, dword ptr [ebp - 0x2130]
            //   56                   | push                esi

        $sequence_7 = { 50 68???????? 8d85b8f5ffff 50 e8???????? 85c0 7922 }
            // n = 7, score = 100
            //   50                   | push                eax
            //   68????????           |                     
            //   8d85b8f5ffff         | lea                 eax, [ebp - 0xa48]
            //   50                   | push                eax
            //   e8????????           |                     
            //   85c0                 | test                eax, eax
            //   7922                 | jns                 0x24

    condition:
        7 of them and filesize < 430080
}