rule win_bhunt_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2026-01-05"
        version = "1"
        description = "Detects win.bhunt."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.bhunt"
        malpedia_rule_date = "20260105"
        malpedia_hash = "19b79e7cab4eaf532122e5b45a77dd8f6bb5cc79"
        malpedia_version = "20251219"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { f6c643 f65f47 146d 80739aea 7cf9 ed cf }
            // n = 7, score = 100
            //   f6c643               | test                dh, 0x43
            //   f65f47               | neg                 byte ptr [edi + 0x47]
            //   146d                 | adc                 al, 0x6d
            //   80739aea             | xor                 byte ptr [ebx - 0x66], 0xea
            //   7cf9                 | jl                  0xfffffffb
            //   ed                   | in                  eax, dx
            //   cf                   | iretd               

        $sequence_1 = { ff7510 8d442414 50 8984240c070000 e8???????? 8bb42404070000 68???????? }
            // n = 7, score = 100
            //   ff7510               | push                dword ptr [ebp + 0x10]
            //   8d442414             | lea                 eax, [esp + 0x14]
            //   50                   | push                eax
            //   8984240c070000       | mov                 dword ptr [esp + 0x70c], eax
            //   e8????????           |                     
            //   8bb42404070000       | mov                 esi, dword ptr [esp + 0x704]
            //   68????????           |                     

        $sequence_2 = { 50 e8???????? 8d86001c0000 50 8d85b6f3ffff 50 e8???????? }
            // n = 7, score = 100
            //   50                   | push                eax
            //   e8????????           |                     
            //   8d86001c0000         | lea                 eax, [esi + 0x1c00]
            //   50                   | push                eax
            //   8d85b6f3ffff         | lea                 eax, [ebp - 0xc4a]
            //   50                   | push                eax
            //   e8????????           |                     

        $sequence_3 = { 6613c6 8b07 84c8 f8 8dbf04000000 66f7c76d13 33c3 }
            // n = 7, score = 100
            //   6613c6               | adc                 ax, si
            //   8b07                 | mov                 eax, dword ptr [edi]
            //   84c8                 | test                al, cl
            //   f8                   | clc                 
            //   8dbf04000000         | lea                 edi, [edi + 4]
            //   66f7c76d13           | test                di, 0x136d
            //   33c3                 | xor                 eax, ebx

        $sequence_4 = { 83c40c 6a03 bbfb020000 e8???????? 50 56 e8???????? }
            // n = 7, score = 100
            //   83c40c               | add                 esp, 0xc
            //   6a03                 | push                3
            //   bbfb020000           | mov                 ebx, 0x2fb
            //   e8????????           |                     
            //   50                   | push                eax
            //   56                   | push                esi
            //   e8????????           |                     

        $sequence_5 = { 83e01f c1f905 8b0c8d00e04900 c1e006 8d44010c 50 e8???????? }
            // n = 7, score = 100
            //   83e01f               | and                 eax, 0x1f
            //   c1f905               | sar                 ecx, 5
            //   8b0c8d00e04900       | mov                 ecx, dword ptr [ecx*4 + 0x49e000]
            //   c1e006               | shl                 eax, 6
            //   8d44010c             | lea                 eax, [ecx + eax + 0xc]
            //   50                   | push                eax
            //   e8????????           |                     

        $sequence_6 = { 85c0 751f 8b4518 0118 33c0 5f 5e }
            // n = 7, score = 100
            //   85c0                 | test                eax, eax
            //   751f                 | jne                 0x21
            //   8b4518               | mov                 eax, dword ptr [ebp + 0x18]
            //   0118                 | add                 dword ptr [eax], ebx
            //   33c0                 | xor                 eax, eax
            //   5f                   | pop                 edi
            //   5e                   | pop                 esi

        $sequence_7 = { 46 56 68???????? 56 56 e8???????? 85c0 }
            // n = 7, score = 100
            //   46                   | inc                 esi
            //   56                   | push                esi
            //   68????????           |                     
            //   56                   | push                esi
            //   56                   | push                esi
            //   e8????????           |                     
            //   85c0                 | test                eax, eax

        $sequence_8 = { fc 8e04a5???????? 33ef aa 3417 ed b877eefc1d }
            // n = 7, score = 100
            //   fc                   | cld                 
            //   8e04a5????????       |                     
            //   33ef                 | xor                 ebp, edi
            //   aa                   | stosb               byte ptr es:[edi], al
            //   3417                 | xor                 al, 0x17
            //   ed                   | in                  eax, dx
            //   b877eefc1d           | mov                 eax, 0x1dfcee77

        $sequence_9 = { 2522e9fb64 794f 8b00 9a5250f0069a5c 2640 2e9b 1a489f }
            // n = 7, score = 100
            //   2522e9fb64           | and                 eax, 0x64fbe922
            //   794f                 | jns                 0x51
            //   8b00                 | mov                 eax, dword ptr [eax]
            //   9a5250f0069a5c       | lcall               0x5c9a:0x6f05052
            //   2640                 | inc                 eax
            //   2e9b                 | wait                
            //   1a489f               | sbb                 cl, byte ptr [eax - 0x61]

    condition:
        7 of them and filesize < 19161088
}