rule win_bibi_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2026-01-05"
        version = "1"
        description = "Detects win.bibi."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.bibi"
        malpedia_rule_date = "20260105"
        malpedia_hash = "19b79e7cab4eaf532122e5b45a77dd8f6bb5cc79"
        malpedia_version = "20251219"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 0f840b010000 488d05a2af0100 4a8b04e8 42385cf838 0f8df5000000 e8???????? }
            // n = 6, score = 100
            //   0f840b010000         | jb                  0x4b0
            //   488d05a2af0100       | mov                 ecx, dword ptr [esp + 0x48]
            //   4a8b04e8             | call                esi
            //   42385cf838           | test                eax, eax
            //   0f8df5000000         | jne                 0x5a6
            //   e8????????           |                     

        $sequence_1 = { 754a 483bc2 0f84cc000000 660f1f440000 4c8929 4c896910 4c896918 }
            // n = 7, score = 100
            //   754a                 | nop                 dword ptr [eax + eax]
            //   483bc2               | cmp                 dword ptr [ebx + 8], 0
            //   0f84cc000000         | je                  0x5eb
            //   660f1f440000         | cmp                 dword ptr [ebx + 8], eax
            //   4c8929               | je                  0x5db
            //   4c896910             | je                  0x52c
            //   4c896918             | dec                 eax

        $sequence_2 = { 488b45bf 488b1cd0 488b5318 4883fa08 }
            // n = 4, score = 100
            //   488b45bf             | mov                 edx, dword ptr [ebp - 0x40]
            //   488b1cd0             | dec                 eax
            //   488b5318             | cmp                 edx, dword ptr [ebp - 0x38]
            //   4883fa08             | dec                 eax

        $sequence_3 = { 89442424 488b4c2420 48898b78020000 488bc3 4c8d5c2460 }
            // n = 5, score = 100
            //   89442424             | dec                 edx
            //   488b4c2420           | movsx               eax, byte ptr [ecx + edx + 0x23970]
            //   48898b78020000       | inc                 edx
            //   488bc3               | mov                 cl, byte ptr [ecx + edx + 0x23980]
            //   4c8d5c2460           | dec                 esp

        $sequence_4 = { 483bd9 7522 483bc1 7468 0f1f4000 0f1008 }
            // n = 6, score = 100
            //   483bd9               | jge                 0x168
            //   7522                 | inc                 ebx
            //   483bc1               | movsx               eax, byte ptr [eax + ecx + 0x31170]
            //   7468                 | test                eax, eax
            //   0f1f4000             | jne                 0x29
            //   0f1008               | mov                 dword ptr [eax], 0x2a

        $sequence_5 = { 488d15645c0100 e8???????? 85c0 7416 }
            // n = 4, score = 100
            //   488d15645c0100       | dec                 eax
            //   e8????????           |                     
            //   85c0                 | add                 esp, 0x20
            //   7416                 | dec                 eax

        $sequence_6 = { 7716 488bc6 4983f810 7203 488b06 48894e10 c6040800 }
            // n = 7, score = 100
            //   7716                 | dec                 eax
            //   488bc6               | mov                 ecx, dword ptr [eax + 0x88]
            //   4983f810             | dec                 eax
            //   7203                 | lea                 eax, [0x175c2]
            //   488b06               | dec                 eax
            //   48894e10             | cmp                 ecx, eax
            //   c6040800             | je                  0x148

        $sequence_7 = { 0f84a1000000 b901000000 e8???????? 483bd8 7509 488d3d70c00100 eb16 }
            // n = 7, score = 100
            //   0f84a1000000         | mov                 ecx, ebx
            //   b901000000           | dec                 eax
            //   e8????????           |                     
            //   483bd8               | lea                 edx, [0x192db]
            //   7509                 | dec                 eax
            //   488d3d70c00100       | lea                 edx, [0x192db]
            //   eb16                 | dec                 eax

        $sequence_8 = { 6690 83fb0a 7d65 ba3d000000 e8???????? }
            // n = 5, score = 100
            //   6690                 | dec                 eax
            //   83fb0a               | mov                 ecx, edi
            //   7d65                 | dec                 esp
            //   ba3d000000           | mov                 eax, ebx
            //   e8????????           |                     

        $sequence_9 = { 4c8d04c0 498b84d140310300 42f644c03848 7430 8a8c2480000000 4c8b942490000000 80f90a }
            // n = 7, score = 100
            //   4c8d04c0             | lea                 eax, [esp + 4]
            //   498b84d140310300     | dec                 eax
            //   42f644c03848         | lea                 edx, [0x28cb3]
            //   7430                 | dec                 eax
            //   8a8c2480000000       | lea                 ecx, [esp + 0x180]
            //   4c8b942490000000     | dec                 esp
            //   80f90a               | mov                 dword ptr [esp + 0x88], esp

    condition:
        7 of them and filesize < 462848
}