rule win_bid_ransomware_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2026-01-05"
        version = "1"
        description = "Detects win.bid_ransomware."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.bid_ransomware"
        malpedia_rule_date = "20260105"
        malpedia_hash = "19b79e7cab4eaf532122e5b45a77dd8f6bb5cc79"
        malpedia_version = "20251219"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 8d45a4 50 6a00 6a00 68???????? 6a00 }
            // n = 6, score = 200
            //   8d45a4               | lea                 eax, [ebp - 0x5c]
            //   50                   | push                eax
            //   6a00                 | push                0
            //   6a00                 | push                0
            //   68????????           |                     
            //   6a00                 | push                0

        $sequence_1 = { 68???????? e8???????? 85c0 0f848d000000 8b7508 ff7508 }
            // n = 6, score = 200
            //   68????????           |                     
            //   e8????????           |                     
            //   85c0                 | test                eax, eax
            //   0f848d000000         | je                  0x93
            //   8b7508               | mov                 esi, dword ptr [ebp + 8]
            //   ff7508               | push                dword ptr [ebp + 8]

        $sequence_2 = { e8???????? 60 6a00 6a02 e8???????? 8bd8 c785d4fdffff2c020000 }
            // n = 7, score = 200
            //   e8????????           |                     
            //   60                   | pushal              
            //   6a00                 | push                0
            //   6a02                 | push                2
            //   e8????????           |                     
            //   8bd8                 | mov                 ebx, eax
            //   c785d4fdffff2c020000     | mov    dword ptr [ebp - 0x22c], 0x22c

        $sequence_3 = { e8???????? c9 c3 55 8bec 60 }
            // n = 6, score = 200
            //   e8????????           |                     
            //   c9                   | leave               
            //   c3                   | ret                 
            //   55                   | push                ebp
            //   8bec                 | mov                 ebp, esp
            //   60                   | pushal              

        $sequence_4 = { e8???????? 83f800 7605 8945f4 eb02 ebc9 }
            // n = 6, score = 200
            //   e8????????           |                     
            //   83f800               | cmp                 eax, 0
            //   7605                 | jbe                 7
            //   8945f4               | mov                 dword ptr [ebp - 0xc], eax
            //   eb02                 | jmp                 4
            //   ebc9                 | jmp                 0xffffffcb

        $sequence_5 = { ff759c e8???????? 8b45a8 0500040000 894590 6800010000 }
            // n = 6, score = 200
            //   ff759c               | push                dword ptr [ebp - 0x64]
            //   e8????????           |                     
            //   8b45a8               | mov                 eax, dword ptr [ebp - 0x58]
            //   0500040000           | add                 eax, 0x400
            //   894590               | mov                 dword ptr [ebp - 0x70], eax
            //   6800010000           | push                0x100

        $sequence_6 = { 6a00 6a00 e8???????? 6a0f 50 }
            // n = 5, score = 200
            //   6a00                 | push                0
            //   6a00                 | push                0
            //   e8????????           |                     
            //   6a0f                 | push                0xf
            //   50                   | push                eax

        $sequence_7 = { ff75f4 e8???????? ff75fc e8???????? ff05???????? ff75e4 e8???????? }
            // n = 7, score = 200
            //   ff75f4               | push                dword ptr [ebp - 0xc]
            //   e8????????           |                     
            //   ff75fc               | push                dword ptr [ebp - 4]
            //   e8????????           |                     
            //   ff05????????         |                     
            //   ff75e4               | push                dword ptr [ebp - 0x1c]
            //   e8????????           |                     

        $sequence_8 = { e8???????? 8d85d4fdffff 50 53 e8???????? ebb4 53 }
            // n = 7, score = 200
            //   e8????????           |                     
            //   8d85d4fdffff         | lea                 eax, [ebp - 0x22c]
            //   50                   | push                eax
            //   53                   | push                ebx
            //   e8????????           |                     
            //   ebb4                 | jmp                 0xffffffb6
            //   53                   | push                ebx

        $sequence_9 = { 6a00 8d00 50 e8???????? eb79 8b5814 66813b5c5c }
            // n = 7, score = 200
            //   6a00                 | push                0
            //   8d00                 | lea                 eax, [eax]
            //   50                   | push                eax
            //   e8????????           |                     
            //   eb79                 | jmp                 0x7b
            //   8b5814               | mov                 ebx, dword ptr [eax + 0x14]
            //   66813b5c5c           | cmp                 word ptr [ebx], 0x5c5c

    condition:
        7 of them and filesize < 57344
}