rule win_billgates_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2026-01-05"
        version = "1"
        description = "Detects win.billgates."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.billgates"
        malpedia_rule_date = "20260105"
        malpedia_hash = "19b79e7cab4eaf532122e5b45a77dd8f6bb5cc79"
        malpedia_version = "20251219"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 7408 3c22 7404 3c30 7504 }
            // n = 5, score = 200
            //   7408                 | mov                 dword ptr [esp + 0xe0], 0xf
            //   3c22                 | dec                 esp
            //   7404                 | mov                 dword ptr [esp + 0xd8], esi
            //   3c30                 | mov                 byte ptr [esp + 0xc8], 0
            //   7504                 | dec                 ecx

        $sequence_1 = { 3c21 7408 3c23 7404 3c24 }
            // n = 5, score = 200
            //   3c21                 | lea                 eax, [0x2450d]
            //   7408                 | dec                 eax
            //   3c23                 | mov                 edx, eax
            //   7404                 | nop                 
            //   3c24                 | dec                 esp

        $sequence_2 = { 7404 3c58 7507 b802000000 eb02 }
            // n = 5, score = 200
            //   7404                 | lea                 eax, [ecx - 1]
            //   3c58                 | dec                 eax
            //   7507                 | mov                 ecx, esi
            //   b802000000           | mov                 edx, dword ptr [esi + 0x18]
            //   eb02                 | dec                 eax

        $sequence_3 = { 740c 3c11 7408 3c22 7404 3c30 7504 }
            // n = 7, score = 200
            //   740c                 | dec                 eax
            //   3c11                 | mov                 dword ptr [ecx - 0x28], eax
            //   7408                 | mov                 ebx, edx
            //   3c22                 | dec                 esp
            //   7404                 | lea                 ebx, [0x1f876]
            //   3c30                 | dec                 esp
            //   7504                 | mov                 dword ptr [edi], ebx

        $sequence_4 = { 3c11 7408 3c22 7404 3c30 7504 }
            // n = 6, score = 200
            //   3c11                 | test                eax, eax
            //   7408                 | jns                 0x1a7a
            //   3c22                 | dec                 ebp
            //   7404                 | mov                 ecx, dword ptr [esp + 8]
            //   3c30                 | inc                 ecx
            //   7504                 | mov                 al, 1

        $sequence_5 = { 3c21 7408 3c23 7404 }
            // n = 4, score = 200
            //   3c21                 | inc                 edi
            //   7408                 | dec                 eax
            //   3c23                 | add                 eax, 0x18
            //   7404                 | cmp                 edx, dword ptr [esi]

        $sequence_6 = { ff15???????? 83f8ff 7508 ff15???????? f7d8 85c0 }
            // n = 6, score = 200
            //   ff15????????         |                     
            //   83f8ff               | mov                 esi, dword ptr [edi + 0x34]
            //   7508                 | mov                 ebx, eax
            //   ff15????????         |                     
            //   f7d8                 | mov                 eax, dword ptr [esi + 0x10]
            //   85c0                 | add                 esp, 4

        $sequence_7 = { 3c10 740c 3c11 7408 3c22 7404 3c30 }
            // n = 7, score = 200
            //   3c10                 | mov                 byte ptr [esp + 0x8c], 0x30
            //   740c                 | mov                 byte ptr [esp + 0x8d], 0x37
            //   3c11                 | mov                 byte ptr [esp + 0x8e], 0x39
            //   7408                 | mov                 byte ptr [esp + 0x8a], 0x37
            //   3c22                 | mov                 byte ptr [esp + 0x8b], 0x30
            //   7404                 | mov                 byte ptr [esp + 0x8c], 0x31
            //   3c30                 | mov                 byte ptr [esp + 0x8d], 0x41

        $sequence_8 = { 740c 3c11 7408 3c22 7404 }
            // n = 5, score = 200
            //   740c                 | dec                 ecx
            //   3c11                 | mov                 esi, dword ptr [esp + 0xb8]
            //   7408                 | dec                 eax
            //   3c22                 | mov                 dword ptr [esp + 0x30], esi
            //   7404                 | dec                 eax

        $sequence_9 = { 3c10 740c 3c11 7408 }
            // n = 4, score = 200
            //   3c10                 | dec                 eax
            //   740c                 | arpl                cx, dx
            //   3c11                 | dec                 eax
            //   7408                 | lea                 ecx, [0x21990]

    condition:
        7 of them and filesize < 801792
}