rule win_biscuit_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2026-01-05"
        version = "1"
        description = "Detects win.biscuit."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.biscuit"
        malpedia_rule_date = "20260105"
        malpedia_hash = "19b79e7cab4eaf532122e5b45a77dd8f6bb5cc79"
        malpedia_version = "20251219"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { c6040800 8b4c241c 5f c745300030c084 8bc5 5e }
            // n = 6, score = 100
            //   c6040800             | mov                 byte ptr [eax + ecx], 0
            //   8b4c241c             | mov                 ecx, dword ptr [esp + 0x1c]
            //   5f                   | pop                 edi
            //   c745300030c084       | mov                 dword ptr [ebp + 0x30], 0x84c03000
            //   8bc5                 | mov                 eax, ebp
            //   5e                   | pop                 esi

        $sequence_1 = { 8b95b8b7ffff 52 e8???????? 83c404 eb22 8b85d4daffff 83e801 }
            // n = 7, score = 100
            //   8b95b8b7ffff         | mov                 edx, dword ptr [ebp - 0x4848]
            //   52                   | push                edx
            //   e8????????           |                     
            //   83c404               | add                 esp, 4
            //   eb22                 | jmp                 0x24
            //   8b85d4daffff         | mov                 eax, dword ptr [ebp - 0x252c]
            //   83e801               | sub                 eax, 1

        $sequence_2 = { 8d8dd0daffff 51 b9???????? e8???????? 25ff000000 85c0 }
            // n = 6, score = 100
            //   8d8dd0daffff         | lea                 ecx, [ebp - 0x2530]
            //   51                   | push                ecx
            //   b9????????           |                     
            //   e8????????           |                     
            //   25ff000000           | and                 eax, 0xff
            //   85c0                 | test                eax, eax

        $sequence_3 = { eb1f 8b45f0 83e801 898584b6ffff 8b8d84b6ffff 8a11 }
            // n = 6, score = 100
            //   eb1f                 | jmp                 0x21
            //   8b45f0               | mov                 eax, dword ptr [ebp - 0x10]
            //   83e801               | sub                 eax, 1
            //   898584b6ffff         | mov                 dword ptr [ebp - 0x497c], eax
            //   8b8d84b6ffff         | mov                 ecx, dword ptr [ebp - 0x497c]
            //   8a11                 | mov                 dl, byte ptr [ecx]

        $sequence_4 = { 8b8d74b7ffff 3b4de0 0f83f5000000 8b55e0 2b9574b7ffff 899588b7ffff 8b857cb7ffff }
            // n = 7, score = 100
            //   8b8d74b7ffff         | mov                 ecx, dword ptr [ebp - 0x488c]
            //   3b4de0               | cmp                 ecx, dword ptr [ebp - 0x20]
            //   0f83f5000000         | jae                 0xfb
            //   8b55e0               | mov                 edx, dword ptr [ebp - 0x20]
            //   2b9574b7ffff         | sub                 edx, dword ptr [ebp - 0x488c]
            //   899588b7ffff         | mov                 dword ptr [ebp - 0x4878], edx
            //   8b857cb7ffff         | mov                 eax, dword ptr [ebp - 0x4884]

        $sequence_5 = { 83bd28ffffff00 7502 eb71 8b8528ffffff 33c9 }
            // n = 5, score = 100
            //   83bd28ffffff00       | cmp                 dword ptr [ebp - 0xd8], 0
            //   7502                 | jne                 4
            //   eb71                 | jmp                 0x73
            //   8b8528ffffff         | mov                 eax, dword ptr [ebp - 0xd8]
            //   33c9                 | xor                 ecx, ecx

        $sequence_6 = { 03f0 03d8 3bb42458100000 734f 6800100000 8d442444 53 }
            // n = 7, score = 100
            //   03f0                 | add                 esi, eax
            //   03d8                 | add                 ebx, eax
            //   3bb42458100000       | cmp                 esi, dword ptr [esp + 0x1058]
            //   734f                 | jae                 0x51
            //   6800100000           | push                0x1000
            //   8d442444             | lea                 eax, [esp + 0x44]
            //   53                   | push                ebx

        $sequence_7 = { 8d8da0daffff e8???????? 8d9510b9ffff 52 b9???????? e8???????? }
            // n = 6, score = 100
            //   8d8da0daffff         | lea                 ecx, [ebp - 0x2560]
            //   e8????????           |                     
            //   8d9510b9ffff         | lea                 edx, [ebp - 0x46f0]
            //   52                   | push                edx
            //   b9????????           |                     
            //   e8????????           |                     

        $sequence_8 = { 8b8db0feffff 51 e8???????? 83c404 eb1f 8b55e4 83ea01 }
            // n = 7, score = 100
            //   8b8db0feffff         | mov                 ecx, dword ptr [ebp - 0x150]
            //   51                   | push                ecx
            //   e8????????           |                     
            //   83c404               | add                 esp, 4
            //   eb1f                 | jmp                 0x21
            //   8b55e4               | mov                 edx, dword ptr [ebp - 0x1c]
            //   83ea01               | sub                 edx, 1

        $sequence_9 = { 83e901 898d34feffff 8b9534feffff 8a02 2c01 8b8d34feffff }
            // n = 6, score = 100
            //   83e901               | sub                 ecx, 1
            //   898d34feffff         | mov                 dword ptr [ebp - 0x1cc], ecx
            //   8b9534feffff         | mov                 edx, dword ptr [ebp - 0x1cc]
            //   8a02                 | mov                 al, byte ptr [edx]
            //   2c01                 | sub                 al, 1
            //   8b8d34feffff         | mov                 ecx, dword ptr [ebp - 0x1cc]

    condition:
        7 of them and filesize < 180224
}