rule win_bistromath_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2026-01-05"
        version = "1"
        description = "Detects win.bistromath."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.bistromath"
        malpedia_rule_date = "20260105"
        malpedia_hash = "19b79e7cab4eaf532122e5b45a77dd8f6bb5cc79"
        malpedia_version = "20251219"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { ff701c e8???????? ff75f8 ba17000000 8945e4 6aff 8bce }
            // n = 7, score = 400
            //   ff701c               | push                dword ptr [eax + 0x1c]
            //   e8????????           |                     
            //   ff75f8               | push                dword ptr [ebp - 8]
            //   ba17000000           | mov                 edx, 0x17
            //   8945e4               | mov                 dword ptr [ebp - 0x1c], eax
            //   6aff                 | push                -1
            //   8bce                 | mov                 ecx, esi

        $sequence_1 = { e8???????? 83c408 85c0 7414 8b4d08 89482c 8b4c2434 }
            // n = 7, score = 400
            //   e8????????           |                     
            //   83c408               | add                 esp, 8
            //   85c0                 | test                eax, eax
            //   7414                 | je                  0x16
            //   8b4d08               | mov                 ecx, dword ptr [ebp + 8]
            //   89482c               | mov                 dword ptr [eax + 0x2c], ecx
            //   8b4c2434             | mov                 ecx, dword ptr [esp + 0x34]

        $sequence_2 = { e8???????? 8bf0 85f6 7533 8b4b04 8d4308 50 }
            // n = 7, score = 400
            //   e8????????           |                     
            //   8bf0                 | mov                 esi, eax
            //   85f6                 | test                esi, esi
            //   7533                 | jne                 0x35
            //   8b4b04               | mov                 ecx, dword ptr [ebx + 4]
            //   8d4308               | lea                 eax, [ebx + 8]
            //   50                   | push                eax

        $sequence_3 = { 8bf9 8d45fc 50 8bf2 8b0f e8???????? 83c408 }
            // n = 7, score = 400
            //   8bf9                 | mov                 edi, ecx
            //   8d45fc               | lea                 eax, [ebp - 4]
            //   50                   | push                eax
            //   8bf2                 | mov                 esi, edx
            //   8b0f                 | mov                 ecx, dword ptr [edi]
            //   e8????????           |                     
            //   83c408               | add                 esp, 8

        $sequence_4 = { e8???????? 8bf8 85ff 7416 ff75fc ff75f4 57 }
            // n = 7, score = 400
            //   e8????????           |                     
            //   8bf8                 | mov                 edi, eax
            //   85ff                 | test                edi, edi
            //   7416                 | je                  0x18
            //   ff75fc               | push                dword ptr [ebp - 4]
            //   ff75f4               | push                dword ptr [ebp - 0xc]
            //   57                   | push                edi

        $sequence_5 = { 8d850cffffff 6a00 50 e8???????? 83c40c 8d85fcfeffff 50 }
            // n = 7, score = 400
            //   8d850cffffff         | lea                 eax, [ebp - 0xf4]
            //   6a00                 | push                0
            //   50                   | push                eax
            //   e8????????           |                     
            //   83c40c               | add                 esp, 0xc
            //   8d85fcfeffff         | lea                 eax, [ebp - 0x104]
            //   50                   | push                eax

        $sequence_6 = { ffb594f4ffff 8bd3 8d8db8f8ffff e8???????? 83c404 8d85b8f8ffff 50 }
            // n = 7, score = 400
            //   ffb594f4ffff         | push                dword ptr [ebp - 0xb6c]
            //   8bd3                 | mov                 edx, ebx
            //   8d8db8f8ffff         | lea                 ecx, [ebp - 0x748]
            //   e8????????           |                     
            //   83c404               | add                 esp, 4
            //   8d85b8f8ffff         | lea                 eax, [ebp - 0x748]
            //   50                   | push                eax

        $sequence_7 = { ffd0 83c404 83460cff 8b06 c7461400000000 8945fc 751e }
            // n = 7, score = 400
            //   ffd0                 | call                eax
            //   83c404               | add                 esp, 4
            //   83460cff             | add                 dword ptr [esi + 0xc], -1
            //   8b06                 | mov                 eax, dword ptr [esi]
            //   c7461400000000       | mov                 dword ptr [esi + 0x14], 0
            //   8945fc               | mov                 dword ptr [ebp - 4], eax
            //   751e                 | jne                 0x20

        $sequence_8 = { e8???????? 84c0 7504 33f6 eb1e 6a40 e8???????? }
            // n = 7, score = 400
            //   e8????????           |                     
            //   84c0                 | test                al, al
            //   7504                 | jne                 6
            //   33f6                 | xor                 esi, esi
            //   eb1e                 | jmp                 0x20
            //   6a40                 | push                0x40
            //   e8????????           |                     

        $sequence_9 = { 8d8504ffffff 50 57 ffd6 8985b8feffff 8d45e0 50 }
            // n = 7, score = 400
            //   8d8504ffffff         | lea                 eax, [ebp - 0xfc]
            //   50                   | push                eax
            //   57                   | push                edi
            //   ffd6                 | call                esi
            //   8985b8feffff         | mov                 dword ptr [ebp - 0x148], eax
            //   8d45e0               | lea                 eax, [ebp - 0x20]
            //   50                   | push                eax

    condition:
        7 of them and filesize < 33816576
}