rule win_bit_rat_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2026-01-05"
        version = "1"
        description = "Detects win.bit_rat."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.bit_rat"
        malpedia_rule_date = "20260105"
        malpedia_hash = "19b79e7cab4eaf532122e5b45a77dd8f6bb5cc79"
        malpedia_version = "20251219"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { eb1b 8b4de0 8b5ddc 8b7df8 8b45f4 eba7 8b4510 }
            // n = 7, score = 200
            //   eb1b                 | jmp                 0x1d
            //   8b4de0               | mov                 ecx, dword ptr [ebp - 0x20]
            //   8b5ddc               | mov                 ebx, dword ptr [ebp - 0x24]
            //   8b7df8               | mov                 edi, dword ptr [ebp - 8]
            //   8b45f4               | mov                 eax, dword ptr [ebp - 0xc]
            //   eba7                 | jmp                 0xffffffa9
            //   8b4510               | mov                 eax, dword ptr [ebp + 0x10]

        $sequence_1 = { e8???????? 8b4f0c 83c404 3b01 740e 6a00 6a00 }
            // n = 7, score = 200
            //   e8????????           |                     
            //   8b4f0c               | mov                 ecx, dword ptr [edi + 0xc]
            //   83c404               | add                 esp, 4
            //   3b01                 | cmp                 eax, dword ptr [ecx]
            //   740e                 | je                  0x10
            //   6a00                 | push                0
            //   6a00                 | push                0

        $sequence_2 = { e8???????? c645fc42 50 8bce e8???????? c645fc24 53 }
            // n = 7, score = 200
            //   e8????????           |                     
            //   c645fc42             | mov                 byte ptr [ebp - 4], 0x42
            //   50                   | push                eax
            //   8bce                 | mov                 ecx, esi
            //   e8????????           |                     
            //   c645fc24             | mov                 byte ptr [ebp - 4], 0x24
            //   53                   | push                ebx

        $sequence_3 = { 85ed 7460 895c2410 8bd3 8bce 85f6 7454 }
            // n = 7, score = 200
            //   85ed                 | test                ebp, ebp
            //   7460                 | je                  0x62
            //   895c2410             | mov                 dword ptr [esp + 0x10], ebx
            //   8bd3                 | mov                 edx, ebx
            //   8bce                 | mov                 ecx, esi
            //   85f6                 | test                esi, esi
            //   7454                 | je                  0x56

        $sequence_4 = { e9???????? 83f85b 751b 8bce e8???????? 8bce e8???????? }
            // n = 7, score = 200
            //   e9????????           |                     
            //   83f85b               | cmp                 eax, 0x5b
            //   751b                 | jne                 0x1d
            //   8bce                 | mov                 ecx, esi
            //   e8????????           |                     
            //   8bce                 | mov                 ecx, esi
            //   e8????????           |                     

        $sequence_5 = { e8???????? 8b4c240c 83c404 83f903 751b 6a00 6a00 }
            // n = 7, score = 200
            //   e8????????           |                     
            //   8b4c240c             | mov                 ecx, dword ptr [esp + 0xc]
            //   83c404               | add                 esp, 4
            //   83f903               | cmp                 ecx, 3
            //   751b                 | jne                 0x1d
            //   6a00                 | push                0
            //   6a00                 | push                0

        $sequence_6 = { ff7618 8bd7 e8???????? 8bd8 83c408 8bc2 8bcb }
            // n = 7, score = 200
            //   ff7618               | push                dword ptr [esi + 0x18]
            //   8bd7                 | mov                 edx, edi
            //   e8????????           |                     
            //   8bd8                 | mov                 ebx, eax
            //   83c408               | add                 esp, 8
            //   8bc2                 | mov                 eax, edx
            //   8bcb                 | mov                 ecx, ebx

        $sequence_7 = { ff75ec ff75e8 ff75fc ff75f8 ff7514 53 eb2a }
            // n = 7, score = 200
            //   ff75ec               | push                dword ptr [ebp - 0x14]
            //   ff75e8               | push                dword ptr [ebp - 0x18]
            //   ff75fc               | push                dword ptr [ebp - 4]
            //   ff75f8               | push                dword ptr [ebp - 8]
            //   ff7514               | push                dword ptr [ebp + 0x14]
            //   53                   | push                ebx
            //   eb2a                 | jmp                 0x2c

        $sequence_8 = { c3 8bff 55 8bec 5d e9???????? 6a00 }
            // n = 7, score = 200
            //   c3                   | ret                 
            //   8bff                 | mov                 edi, edi
            //   55                   | push                ebp
            //   8bec                 | mov                 ebp, esp
            //   5d                   | pop                 ebp
            //   e9????????           |                     
            //   6a00                 | push                0

        $sequence_9 = { ffb674040000 e8???????? 8bf8 83c408 85ff 0f8595000000 50 }
            // n = 7, score = 200
            //   ffb674040000         | push                dword ptr [esi + 0x474]
            //   e8????????           |                     
            //   8bf8                 | mov                 edi, eax
            //   83c408               | add                 esp, 8
            //   85ff                 | test                edi, edi
            //   0f8595000000         | jne                 0x9b
            //   50                   | push                eax

    condition:
        7 of them and filesize < 19405824
}