rule win_bitsran_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2026-01-05"
        version = "1"
        description = "Detects win.bitsran."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.bitsran"
        malpedia_rule_date = "20260105"
        malpedia_hash = "19b79e7cab4eaf532122e5b45a77dd8f6bb5cc79"
        malpedia_version = "20251219"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 8d85c0f6ffff 50 57 e8???????? 33c0 }
            // n = 5, score = 100
            //   8d85c0f6ffff         | lea                 eax, [ebp - 0x940]
            //   50                   | push                eax
            //   57                   | push                edi
            //   e8????????           |                     
            //   33c0                 | xor                 eax, eax

        $sequence_1 = { 8bec 53 8bd9 833b00 }
            // n = 4, score = 100
            //   8bec                 | mov                 ebp, esp
            //   53                   | push                ebx
            //   8bd9                 | mov                 ebx, ecx
            //   833b00               | cmp                 dword ptr [ebx], 0

        $sequence_2 = { 85f6 741f 85c9 741b 8b13 52 6a01 }
            // n = 7, score = 100
            //   85f6                 | test                esi, esi
            //   741f                 | je                  0x21
            //   85c9                 | test                ecx, ecx
            //   741b                 | je                  0x1d
            //   8b13                 | mov                 edx, dword ptr [ebx]
            //   52                   | push                edx
            //   6a01                 | push                1

        $sequence_3 = { eb0c 8a85eefcffff 8a8deffcffff c7830c02000000000000 84c9 740a c7830c02000010000000 }
            // n = 7, score = 100
            //   eb0c                 | jmp                 0xe
            //   8a85eefcffff         | mov                 al, byte ptr [ebp - 0x312]
            //   8a8deffcffff         | mov                 cl, byte ptr [ebp - 0x311]
            //   c7830c02000000000000     | mov    dword ptr [ebx + 0x20c], 0
            //   84c9                 | test                cl, cl
            //   740a                 | je                  0xc
            //   c7830c02000010000000     | mov    dword ptr [ebx + 0x20c], 0x10

        $sequence_4 = { 33f6 90 8d85f0fcffff 50 57 }
            // n = 5, score = 100
            //   33f6                 | xor                 esi, esi
            //   90                   | nop                 
            //   8d85f0fcffff         | lea                 eax, [ebp - 0x310]
            //   50                   | push                eax
            //   57                   | push                edi

        $sequence_5 = { 837e0813 7324 b801000000 8bff 8b4e08 8b148d90564100 }
            // n = 6, score = 100
            //   837e0813             | cmp                 dword ptr [esi + 8], 0x13
            //   7324                 | jae                 0x26
            //   b801000000           | mov                 eax, 1
            //   8bff                 | mov                 edi, edi
            //   8b4e08               | mov                 ecx, dword ptr [esi + 8]
            //   8b148d90564100       | mov                 edx, dword ptr [ecx*4 + 0x415690]

        $sequence_6 = { c70009000000 c747180c5e4100 e9???????? 8b45fc 8b4008 }
            // n = 5, score = 100
            //   c70009000000         | mov                 dword ptr [eax], 9
            //   c747180c5e4100       | mov                 dword ptr [edi + 0x18], 0x415e0c
            //   e9????????           |                     
            //   8b45fc               | mov                 eax, dword ptr [ebp - 4]
            //   8b4008               | mov                 eax, dword ptr [eax + 8]

        $sequence_7 = { ffb7b0104200 ff15???????? 8987b0104200 83c704 83ff28 72e6 5f }
            // n = 7, score = 100
            //   ffb7b0104200         | push                dword ptr [edi + 0x4210b0]
            //   ff15????????         |                     
            //   8987b0104200         | mov                 dword ptr [edi + 0x4210b0], eax
            //   83c704               | add                 edi, 4
            //   83ff28               | cmp                 edi, 0x28
            //   72e6                 | jb                  0xffffffe8
            //   5f                   | pop                 edi

        $sequence_8 = { ff248d98594000 83ff03 7338 b901000000 837df800 0f848a060000 294df8 }
            // n = 7, score = 100
            //   ff248d98594000       | jmp                 dword ptr [ecx*4 + 0x405998]
            //   83ff03               | cmp                 edi, 3
            //   7338                 | jae                 0x3a
            //   b901000000           | mov                 ecx, 1
            //   837df800             | cmp                 dword ptr [ebp - 8], 0
            //   0f848a060000         | je                  0x690
            //   294df8               | sub                 dword ptr [ebp - 8], ecx

        $sequence_9 = { 5d c3 8b4d1c c741180c5e4100 eb59 }
            // n = 5, score = 100
            //   5d                   | pop                 ebp
            //   c3                   | ret                 
            //   8b4d1c               | mov                 ecx, dword ptr [ebp + 0x1c]
            //   c741180c5e4100       | mov                 dword ptr [ecx + 0x18], 0x415e0c
            //   eb59                 | jmp                 0x5b

    condition:
        7 of them and filesize < 344064
}