rule win_bka_trojaner_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2026-01-05"
        version = "1"
        description = "Detects win.bka_trojaner."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.bka_trojaner"
        malpedia_rule_date = "20260105"
        malpedia_hash = "19b79e7cab4eaf532122e5b45a77dd8f6bb5cc79"
        malpedia_version = "20251219"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 8365d800 c745dce7384000 a1???????? 8945e0 }
            // n = 4, score = 100
            //   8365d800             | and                 dword ptr [ebp - 0x28], 0
            //   c745dce7384000       | mov                 dword ptr [ebp - 0x24], 0x4038e7
            //   a1????????           |                     
            //   8945e0               | mov                 dword ptr [ebp - 0x20], eax

        $sequence_1 = { 50 56 e8???????? 83c408 8b54241c 55 }
            // n = 6, score = 100
            //   50                   | push                eax
            //   56                   | push                esi
            //   e8????????           |                     
            //   83c408               | add                 esp, 8
            //   8b54241c             | mov                 edx, dword ptr [esp + 0x1c]
            //   55                   | push                ebp

        $sequence_2 = { 83ec4c 56 8b742454 6808020000 68???????? }
            // n = 5, score = 100
            //   83ec4c               | sub                 esp, 0x4c
            //   56                   | push                esi
            //   8b742454             | mov                 esi, dword ptr [esp + 0x54]
            //   6808020000           | push                0x208
            //   68????????           |                     

        $sequence_3 = { ff15???????? 8b542414 56 52 ff15???????? 8b4570 }
            // n = 6, score = 100
            //   ff15????????         |                     
            //   8b542414             | mov                 edx, dword ptr [esp + 0x14]
            //   56                   | push                esi
            //   52                   | push                edx
            //   ff15????????         |                     
            //   8b4570               | mov                 eax, dword ptr [ebp + 0x70]

        $sequence_4 = { 0fb6442404 8a4c240c 8488e1eb4000 751e 837c240800 7410 }
            // n = 6, score = 100
            //   0fb6442404           | movzx               eax, byte ptr [esp + 4]
            //   8a4c240c             | mov                 cl, byte ptr [esp + 0xc]
            //   8488e1eb4000         | test                byte ptr [eax + 0x40ebe1], cl
            //   751e                 | jne                 0x20
            //   837c240800           | cmp                 dword ptr [esp + 8], 0
            //   7410                 | je                  0x12

        $sequence_5 = { 5e c3 56 8b742408 8b06 813863736de0 751c }
            // n = 7, score = 100
            //   5e                   | pop                 esi
            //   c3                   | ret                 
            //   56                   | push                esi
            //   8b742408             | mov                 esi, dword ptr [esp + 8]
            //   8b06                 | mov                 eax, dword ptr [esi]
            //   813863736de0         | cmp                 dword ptr [eax], 0xe06d7363
            //   751c                 | jne                 0x1e

        $sequence_6 = { ff7508 83c008 e8???????? 3b4514 59 752d 837df800 }
            // n = 7, score = 100
            //   ff7508               | push                dword ptr [ebp + 8]
            //   83c008               | add                 eax, 8
            //   e8????????           |                     
            //   3b4514               | cmp                 eax, dword ptr [ebp + 0x14]
            //   59                   | pop                 ecx
            //   752d                 | jne                 0x2f
            //   837df800             | cmp                 dword ptr [ebp - 8], 0

        $sequence_7 = { 50 8db6b4e14000 ff36 e8???????? }
            // n = 4, score = 100
            //   50                   | push                eax
            //   8db6b4e14000         | lea                 esi, [esi + 0x40e1b4]
            //   ff36                 | push                dword ptr [esi]
            //   e8????????           |                     

        $sequence_8 = { 83ff01 751a 8b442414 8b08 8b542408 51 }
            // n = 6, score = 100
            //   83ff01               | cmp                 edi, 1
            //   751a                 | jne                 0x1c
            //   8b442414             | mov                 eax, dword ptr [esp + 0x14]
            //   8b08                 | mov                 ecx, dword ptr [eax]
            //   8b542408             | mov                 edx, dword ptr [esp + 8]
            //   51                   | push                ecx

        $sequence_9 = { 7508 8b4508 a3???????? 5b 33c0 5f }
            // n = 6, score = 100
            //   7508                 | jne                 0xa
            //   8b4508               | mov                 eax, dword ptr [ebp + 8]
            //   a3????????           |                     
            //   5b                   | pop                 ebx
            //   33c0                 | xor                 eax, eax
            //   5f                   | pop                 edi

    condition:
        7 of them and filesize < 221184
}