rule win_blackbasta_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2026-01-05"
        version = "1"
        description = "Detects win.blackbasta."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.blackbasta"
        malpedia_rule_date = "20260105"
        malpedia_hash = "19b79e7cab4eaf532122e5b45a77dd8f6bb5cc79"
        malpedia_version = "20251219"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 7447 8d45d8 84d2 7402 8bc3 fe0430 eb33 }
            // n = 7, score = 100
            //   7447                 | je                  0x49
            //   8d45d8               | lea                 eax, [ebp - 0x28]
            //   84d2                 | test                dl, dl
            //   7402                 | je                  4
            //   8bc3                 | mov                 eax, ebx
            //   fe0430               | inc                 byte ptr [eax + esi]
            //   eb33                 | jmp                 0x35

        $sequence_1 = { c745e4e48c0a10 8b4508 8bcf 8b7510 c745e004000000 dd00 8b450c }
            // n = 7, score = 100
            //   c745e4e48c0a10       | mov                 dword ptr [ebp - 0x1c], 0x100a8ce4
            //   8b4508               | mov                 eax, dword ptr [ebp + 8]
            //   8bcf                 | mov                 ecx, edi
            //   8b7510               | mov                 esi, dword ptr [ebp + 0x10]
            //   c745e004000000       | mov                 dword ptr [ebp - 0x20], 4
            //   dd00                 | fld                 qword ptr [eax]
            //   8b450c               | mov                 eax, dword ptr [ebp + 0xc]

        $sequence_2 = { 42 895594 e9???????? 8b45ec c645fc0d 83f810 0f8293000000 }
            // n = 7, score = 100
            //   42                   | inc                 edx
            //   895594               | mov                 dword ptr [ebp - 0x6c], edx
            //   e9????????           |                     
            //   8b45ec               | mov                 eax, dword ptr [ebp - 0x14]
            //   c645fc0d             | mov                 byte ptr [ebp - 4], 0xd
            //   83f810               | cmp                 eax, 0x10
            //   0f8293000000         | jb                  0x99

        $sequence_3 = { 52 8d5594 52 8b01 ff503c 50 8d8decfeffff }
            // n = 7, score = 100
            //   52                   | push                edx
            //   8d5594               | lea                 edx, [ebp - 0x6c]
            //   52                   | push                edx
            //   8b01                 | mov                 eax, dword ptr [ecx]
            //   ff503c               | call                dword ptr [eax + 0x3c]
            //   50                   | push                eax
            //   8d8decfeffff         | lea                 ecx, [ebp - 0x114]

        $sequence_4 = { 83c404 807d6700 c645fc26 0f8481040000 8d45c4 33ff 50 }
            // n = 7, score = 100
            //   83c404               | add                 esp, 4
            //   807d6700             | cmp                 byte ptr [ebp + 0x67], 0
            //   c645fc26             | mov                 byte ptr [ebp - 4], 0x26
            //   0f8481040000         | je                  0x487
            //   8d45c4               | lea                 eax, [ebp - 0x3c]
            //   33ff                 | xor                 edi, edi
            //   50                   | push                eax

        $sequence_5 = { 83c404 8bce 50 e8???????? 83e3ef 895df0 c645fc0c }
            // n = 7, score = 100
            //   83c404               | add                 esp, 4
            //   8bce                 | mov                 ecx, esi
            //   50                   | push                eax
            //   e8????????           |                     
            //   83e3ef               | and                 ebx, 0xffffffef
            //   895df0               | mov                 dword ptr [ebp - 0x10], ebx
            //   c645fc0c             | mov                 byte ptr [ebp - 4], 0xc

        $sequence_6 = { 8b4904 8b01 5d ff6048 2b49fc 83e970 e9???????? }
            // n = 7, score = 100
            //   8b4904               | mov                 ecx, dword ptr [ecx + 4]
            //   8b01                 | mov                 eax, dword ptr [ecx]
            //   5d                   | pop                 ebp
            //   ff6048               | jmp                 dword ptr [eax + 0x48]
            //   2b49fc               | sub                 ecx, dword ptr [ecx - 4]
            //   83e970               | sub                 ecx, 0x70
            //   e9????????           |                     

        $sequence_7 = { 6af6 ff15???????? 8b049d58cc0c10 8b4dfc 897c0118 33c0 5f }
            // n = 7, score = 100
            //   6af6                 | push                -0xa
            //   ff15????????         |                     
            //   8b049d58cc0c10       | mov                 eax, dword ptr [ebx*4 + 0x100ccc58]
            //   8b4dfc               | mov                 ecx, dword ptr [ebp - 4]
            //   897c0118             | mov                 dword ptr [ecx + eax + 0x18], edi
            //   33c0                 | xor                 eax, eax
            //   5f                   | pop                 edi

        $sequence_8 = { e9???????? 397d34 7768 ffb564ffffff 8d4d0c e8???????? 8b4d8c }
            // n = 7, score = 100
            //   e9????????           |                     
            //   397d34               | cmp                 dword ptr [ebp + 0x34], edi
            //   7768                 | ja                  0x6a
            //   ffb564ffffff         | push                dword ptr [ebp - 0x9c]
            //   8d4d0c               | lea                 ecx, [ebp + 0xc]
            //   e8????????           |                     
            //   8b4d8c               | mov                 ecx, dword ptr [ebp - 0x74]

        $sequence_9 = { e8???????? 03c6 13d7 8b75e4 3bd6 7f7a 8b4dec }
            // n = 7, score = 100
            //   e8????????           |                     
            //   03c6                 | add                 eax, esi
            //   13d7                 | adc                 edx, edi
            //   8b75e4               | mov                 esi, dword ptr [ebp - 0x1c]
            //   3bd6                 | cmp                 edx, esi
            //   7f7a                 | jg                  0x7c
            //   8b4dec               | mov                 ecx, dword ptr [ebp - 0x14]

    condition:
        7 of them and filesize < 1758208
}