rule win_blackmagic_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2026-01-05"
        version = "1"
        description = "Detects win.blackmagic."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.blackmagic"
        malpedia_rule_date = "20260105"
        malpedia_hash = "19b79e7cab4eaf532122e5b45a77dd8f6bb5cc79"
        malpedia_version = "20251219"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 4c8d05aa2c0200 e8???????? 488bf0 4885c0 7412 488bc8 ff15???????? }
            // n = 7, score = 100
            //   4c8d05aa2c0200       | mov                 ecx, edx
            //   e8????????           |                     
            //   488bf0               | dec                 eax
            //   4885c0               | mov                 edx, dword ptr [esp + 0x158]
            //   7412                 | dec                 eax
            //   488bc8               | lea                 ecx, [esp + 0xb8]
            //   ff15????????         |                     

        $sequence_1 = { 488bd7 488d8c2430010000 e8???????? 90 33d2 41b810010000 488d8c24e0010000 }
            // n = 7, score = 100
            //   488bd7               | dec                 eax
            //   488d8c2430010000     | cmp                 dword ptr [eax], 0
            //   e8????????           |                     
            //   90                   | je                  0x34a
            //   33d2                 | dec                 eax
            //   41b810010000         | mov                 ecx, dword ptr [edi + 0x50]
            //   488d8c24e0010000     | mov                 eax, dword ptr [ecx]

        $sequence_2 = { 33db 49895bb8 885c2470 448d4317 488d15898a0400 498d4ba8 e8???????? }
            // n = 7, score = 100
            //   33db                 | mov                 eax, esi
            //   49895bb8             | int3                
            //   885c2470             | dec                 eax
            //   448d4317             | mov                 ecx, eax
            //   488d15898a0400       | dec                 eax
            //   498d4ba8             | lea                 eax, [0x69704]
            //   e8????????           |                     

        $sequence_3 = { 488d4dd7 e8???????? 90 41b84d000000 488d159b810400 e8???????? 90 }
            // n = 7, score = 100
            //   488d4dd7             | dec                 ecx
            //   e8????????           |                     
            //   90                   | mov                 eax, eax
            //   41b84d000000         | dec                 eax
            //   488d159b810400       | shr                 eax, 5
            //   e8????????           |                     
            //   90                   | dec                 eax

        $sequence_4 = { 0f284587 488d154d1b0300 488d4d87 660f7f4587 e8???????? 488d5587 488d4c2440 }
            // n = 7, score = 100
            //   0f284587             | dec                 eax
            //   488d154d1b0300       | mov                 eax, dword ptr [ecx]
            //   488d4d87             | call                dword ptr [eax + 0x20]
            //   660f7f4587           | mov                 dword ptr [ebx], eax
            //   e8????????           |                     
            //   488d5587             | mov                 dword ptr [edi + 0xd4], eax
            //   488d4c2440           | inc                 ecx

        $sequence_5 = { e8???????? 4885c0 7411 8a0e 488d1597120300 488910 884808 }
            // n = 7, score = 100
            //   e8????????           |                     
            //   4885c0               | xor                 eax, esp
            //   7411                 | dec                 eax
            //   8a0e                 | mov                 dword ptr [ebp + 0x90], eax
            //   488d1597120300       | mov                 esi, edx
            //   488910               | dec                 eax
            //   884808               | mov                 dword ptr [esp + 0x50], 0xf

        $sequence_6 = { 90 488d05437a0600 4889442428 488d4c2460 488d542468 488b442468 }
            // n = 6, score = 100
            //   90                   | mov                 dword ptr [esi], eax
            //   488d05437a0600       | dec                 eax
            //   4889442428           | mov                 eax, dword ptr [edi]
            //   488d4c2460           | dec                 ecx
            //   488d542468           | mov                 dword ptr [eax + 0x10], ebp
            //   488b442468           | dec                 ecx

        $sequence_7 = { 488b05???????? 488945d0 488b75f0 488975b8 488975d8 33c0 488985c0000000 }
            // n = 7, score = 100
            //   488b05????????       |                     
            //   488945d0             | dec                 eax
            //   488b75f0             | arpl                word ptr [eax + 4], cx
            //   488975b8             | inc                 ebp
            //   488975d8             | xor                 eax, eax
            //   33c0                 | dec                 eax
            //   488985c0000000       | lea                 edx, [ebp - 0x51]

        $sequence_8 = { e8???????? 488bd8 488bc3 4883c430 415e 5f 5e }
            // n = 7, score = 100
            //   e8????????           |                     
            //   488bd8               | xor                 ecx, esp
            //   488bc3               | dec                 esp
            //   4883c430             | lea                 ebx, [esp + 0x60]
            //   415e                 | dec                 eax
            //   5f                   | mov                 dword ptr [ebp - 0x38], 0xf
            //   5e                   | dec                 eax

        $sequence_9 = { 488905???????? ff15???????? 483305???????? 488d1560360300 488bcb 488905???????? ff15???????? }
            // n = 7, score = 100
            //   488905????????       |                     
            //   ff15????????         |                     
            //   483305????????       |                     
            //   488d1560360300       | push                ebx
            //   488bcb               | dec                 eax
            //   488905????????       |                     
            //   ff15????????         |                     

    condition:
        7 of them and filesize < 1416192
}