rule win_blacksuit_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2026-01-05"
        version = "1"
        description = "Detects win.blacksuit."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.blacksuit"
        malpedia_rule_date = "20260105"
        malpedia_hash = "19b79e7cab4eaf532122e5b45a77dd8f6bb5cc79"
        malpedia_version = "20251219"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { ff742414 e8???????? 8b6c241c 83c404 }
            // n = 4, score = 200
            //   ff742414             | push                dword ptr [esp + 0x14]
            //   e8????????           |                     
            //   8b6c241c             | mov                 ebp, dword ptr [esp + 0x1c]
            //   83c404               | add                 esp, 4

        $sequence_1 = { 33c0 03dd 13c0 03cb 13d0 }
            // n = 5, score = 200
            //   33c0                 | xor                 eax, eax
            //   03dd                 | add                 ebx, ebp
            //   13c0                 | adc                 eax, eax
            //   03cb                 | add                 ecx, ebx
            //   13d0                 | adc                 edx, eax

        $sequence_2 = { 8d4abd e8???????? 83c408 57 }
            // n = 4, score = 100
            //   8d4abd               | lea                 ecx, [edx - 0x43]
            //   e8????????           |                     
            //   83c408               | add                 esp, 8
            //   57                   | push                edi

        $sequence_3 = { e8???????? 8be8 83c40c 33f6 85ed 7e2e }
            // n = 6, score = 100
            //   e8????????           |                     
            //   8be8                 | mov                 ebp, eax
            //   83c40c               | add                 esp, 0xc
            //   33f6                 | xor                 esi, esi
            //   85ed                 | test                ebp, ebp
            //   7e2e                 | jle                 0x30

        $sequence_4 = { e8???????? 8be8 83c40c 896c2424 85ed 7423 }
            // n = 6, score = 100
            //   e8????????           |                     
            //   8be8                 | mov                 ebp, eax
            //   83c40c               | add                 esp, 0xc
            //   896c2424             | mov                 dword ptr [esp + 0x24], ebp
            //   85ed                 | test                ebp, ebp
            //   7423                 | je                  0x25

        $sequence_5 = { e8???????? 8be8 83c40c 85ed 0f8427010000 ff74241c }
            // n = 6, score = 100
            //   e8????????           |                     
            //   8be8                 | mov                 ebp, eax
            //   83c40c               | add                 esp, 0xc
            //   85ed                 | test                ebp, ebp
            //   0f8427010000         | je                  0x12d
            //   ff74241c             | push                dword ptr [esp + 0x1c]

        $sequence_6 = { 8d4abb e8???????? 83c408 8d4c242c }
            // n = 4, score = 100
            //   8d4abb               | lea                 ecx, [edx - 0x45]
            //   e8????????           |                     
            //   83c408               | add                 esp, 8
            //   8d4c242c             | lea                 ecx, [esp + 0x2c]

        $sequence_7 = { e8???????? 8be8 83c410 85ed 0f85bb000000 }
            // n = 5, score = 100
            //   e8????????           |                     
            //   8be8                 | mov                 ebp, eax
            //   83c410               | add                 esp, 0x10
            //   85ed                 | test                ebp, ebp
            //   0f85bb000000         | jne                 0xc1

        $sequence_8 = { 8d4ab9 e8???????? 8b4c2444 83c408 }
            // n = 4, score = 100
            //   8d4ab9               | lea                 ecx, [edx - 0x47]
            //   e8????????           |                     
            //   8b4c2444             | mov                 ecx, dword ptr [esp + 0x44]
            //   83c408               | add                 esp, 8

        $sequence_9 = { e8???????? 8be8 83c40c 896c2410 85ed 0f844b070000 }
            // n = 6, score = 100
            //   e8????????           |                     
            //   8be8                 | mov                 ebp, eax
            //   83c40c               | add                 esp, 0xc
            //   896c2410             | mov                 dword ptr [esp + 0x10], ebp
            //   85ed                 | test                ebp, ebp
            //   0f844b070000         | je                  0x751

        $sequence_10 = { e8???????? 8be8 83c408 8b4504 }
            // n = 4, score = 100
            //   e8????????           |                     
            //   8be8                 | mov                 ebp, eax
            //   83c408               | add                 esp, 8
            //   8b4504               | mov                 eax, dword ptr [ebp + 4]

        $sequence_11 = { 8d4abf e8???????? 83c408 6a00 6a02 ffd0 }
            // n = 6, score = 100
            //   8d4abf               | lea                 ecx, [edx - 0x41]
            //   e8????????           |                     
            //   83c408               | add                 esp, 8
            //   6a00                 | push                0
            //   6a02                 | push                2
            //   ffd0                 | call                eax

        $sequence_12 = { 8d4ab6 e8???????? 83c408 6a00 6a00 6a03 }
            // n = 6, score = 100
            //   8d4ab6               | lea                 ecx, [edx - 0x4a]
            //   e8????????           |                     
            //   83c408               | add                 esp, 8
            //   6a00                 | push                0
            //   6a00                 | push                0
            //   6a03                 | push                3

        $sequence_13 = { 8d4ab6 0f11442430 e8???????? 83c408 6a00 6800000060 }
            // n = 6, score = 100
            //   8d4ab6               | lea                 ecx, [edx - 0x4a]
            //   0f11442430           | movups              xmmword ptr [esp + 0x30], xmm0
            //   e8????????           |                     
            //   83c408               | add                 esp, 8
            //   6a00                 | push                0
            //   6800000060           | push                0x60000000

    condition:
        7 of them and filesize < 4764672
}