rule win_bleachgap_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2026-01-05"
        version = "1"
        description = "Detects win.bleachgap."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.bleachgap"
        malpedia_rule_date = "20260105"
        malpedia_hash = "19b79e7cab4eaf532122e5b45a77dd8f6bb5cc79"
        malpedia_version = "20251219"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 8b4110 89500c 8b4110 894210 8b442410 895110 894a0c }
            // n = 7, score = 100
            //   8b4110               | mov                 eax, dword ptr [ecx + 0x10]
            //   89500c               | mov                 dword ptr [eax + 0xc], edx
            //   8b4110               | mov                 eax, dword ptr [ecx + 0x10]
            //   894210               | mov                 dword ptr [edx + 0x10], eax
            //   8b442410             | mov                 eax, dword ptr [esp + 0x10]
            //   895110               | mov                 dword ptr [ecx + 0x10], edx
            //   894a0c               | mov                 dword ptr [edx + 0xc], ecx

        $sequence_1 = { 8d8d80fdffff e8???????? 8d8d48feffff e8???????? 8ac3 8b4df4 64890d00000000 }
            // n = 7, score = 100
            //   8d8d80fdffff         | lea                 ecx, [ebp - 0x280]
            //   e8????????           |                     
            //   8d8d48feffff         | lea                 ecx, [ebp - 0x1b8]
            //   e8????????           |                     
            //   8ac3                 | mov                 al, bl
            //   8b4df4               | mov                 ecx, dword ptr [ebp - 0xc]
            //   64890d00000000       | mov                 dword ptr fs:[0], ecx

        $sequence_2 = { c78514fdffff00000000 c78524fdffff00000000 c78528fdffff00000000 0f1000 0f118514fdffff f30f7e4010 660fd68524fdffff }
            // n = 7, score = 100
            //   c78514fdffff00000000     | mov    dword ptr [ebp - 0x2ec], 0
            //   c78524fdffff00000000     | mov    dword ptr [ebp - 0x2dc], 0
            //   c78528fdffff00000000     | mov    dword ptr [ebp - 0x2d8], 0
            //   0f1000               | movups              xmm0, xmmword ptr [eax]
            //   0f118514fdffff       | movups              xmmword ptr [ebp - 0x2ec], xmm0
            //   f30f7e4010           | movq                xmm0, qword ptr [eax + 0x10]
            //   660fd68524fdffff     | movq                qword ptr [ebp - 0x2dc], xmm0

        $sequence_3 = { 83f81f 0f8783010000 51 52 e8???????? 83c408 8b8d5cffffff }
            // n = 7, score = 100
            //   83f81f               | cmp                 eax, 0x1f
            //   0f8783010000         | ja                  0x189
            //   51                   | push                ecx
            //   52                   | push                edx
            //   e8????????           |                     
            //   83c408               | add                 esp, 8
            //   8b8d5cffffff         | mov                 ecx, dword ptr [ebp - 0xa4]

        $sequence_4 = { 52 e8???????? 83c408 8a85bffeffff eb61 8b55bc 83ff10 }
            // n = 7, score = 100
            //   52                   | push                edx
            //   e8????????           |                     
            //   83c408               | add                 esp, 8
            //   8a85bffeffff         | mov                 al, byte ptr [ebp - 0x141]
            //   eb61                 | jmp                 0x63
            //   8b55bc               | mov                 edx, dword ptr [ebp - 0x44]
            //   83ff10               | cmp                 edi, 0x10

        $sequence_5 = { 83c404 83ee01 7839 0f1f00 56 57 e8???????? }
            // n = 7, score = 100
            //   83c404               | add                 esp, 4
            //   83ee01               | sub                 esi, 1
            //   7839                 | js                  0x3b
            //   0f1f00               | nop                 dword ptr [eax]
            //   56                   | push                esi
            //   57                   | push                edi
            //   e8????????           |                     

        $sequence_6 = { 6859040000 68???????? 68db000000 e9???????? 55 e8???????? 83c404 }
            // n = 7, score = 100
            //   6859040000           | push                0x459
            //   68????????           |                     
            //   68db000000           | push                0xdb
            //   e9????????           |                     
            //   55                   | push                ebp
            //   e8????????           |                     
            //   83c404               | add                 esp, 4

        $sequence_7 = { 46 8ac8 84c0 75dc 84c0 0f845b020000 e9???????? }
            // n = 7, score = 100
            //   46                   | inc                 esi
            //   8ac8                 | mov                 cl, al
            //   84c0                 | test                al, al
            //   75dc                 | jne                 0xffffffde
            //   84c0                 | test                al, al
            //   0f845b020000         | je                  0x261
            //   e9????????           |                     

        $sequence_8 = { 8b542424 8b4c2440 89450c 03ca 8b44243c 894d10 8b04b8 }
            // n = 7, score = 100
            //   8b542424             | mov                 edx, dword ptr [esp + 0x24]
            //   8b4c2440             | mov                 ecx, dword ptr [esp + 0x40]
            //   89450c               | mov                 dword ptr [ebp + 0xc], eax
            //   03ca                 | add                 ecx, edx
            //   8b44243c             | mov                 eax, dword ptr [esp + 0x3c]
            //   894d10               | mov                 dword ptr [ebp + 0x10], ecx
            //   8b04b8               | mov                 eax, dword ptr [eax + edi*4]

        $sequence_9 = { 8945d0 8d4344 8945d4 8d434c 8945d8 8d4354 8945dc }
            // n = 7, score = 100
            //   8945d0               | mov                 dword ptr [ebp - 0x30], eax
            //   8d4344               | lea                 eax, [ebx + 0x44]
            //   8945d4               | mov                 dword ptr [ebp - 0x2c], eax
            //   8d434c               | lea                 eax, [ebx + 0x4c]
            //   8945d8               | mov                 dword ptr [ebp - 0x28], eax
            //   8d4354               | lea                 eax, [ebx + 0x54]
            //   8945dc               | mov                 dword ptr [ebp - 0x24], eax

    condition:
        7 of them and filesize < 4538368
}