rule win_blindingcan_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2026-01-05"
        version = "1"
        description = "Detects win.blindingcan."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.blindingcan"
        malpedia_rule_date = "20260105"
        malpedia_hash = "19b79e7cab4eaf532122e5b45a77dd8f6bb5cc79"
        malpedia_version = "20251219"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { c745cc2932779f 66c745d0e35b c745d45df0da89 c745d87b772e76 c745dc62a9f6c4 c745e0d29c1f7b }
            // n = 6, score = 300
            //   c745cc2932779f       | mov                 dword ptr [ebp - 0x34], 0x9f773229
            //   66c745d0e35b         | mov                 word ptr [ebp - 0x30], 0x5be3
            //   c745d45df0da89       | mov                 dword ptr [ebp - 0x2c], 0x89daf05d
            //   c745d87b772e76       | mov                 dword ptr [ebp - 0x28], 0x762e777b
            //   c745dc62a9f6c4       | mov                 dword ptr [ebp - 0x24], 0xc4f6a962
            //   c745e0d29c1f7b       | mov                 dword ptr [ebp - 0x20], 0x7b1f9cd2

        $sequence_1 = { a1???????? 33c5 8945fc 56 57 8d85f8f7ffff }
            // n = 6, score = 300
            //   a1????????           |                     
            //   33c5                 | xor                 eax, ebp
            //   8945fc               | mov                 dword ptr [ebp - 4], eax
            //   56                   | push                esi
            //   57                   | push                edi
            //   8d85f8f7ffff         | lea                 eax, [ebp - 0x808]

        $sequence_2 = { 750a 8b30 89b495fcfeffff 42 83c00c 49 }
            // n = 6, score = 300
            //   750a                 | jne                 0xc
            //   8b30                 | mov                 esi, dword ptr [eax]
            //   89b495fcfeffff       | mov                 dword ptr [ebp + edx*4 - 0x104], esi
            //   42                   | inc                 edx
            //   83c00c               | add                 eax, 0xc
            //   49                   | dec                 ecx

        $sequence_3 = { c7857cfeffff36a54e6b c78580feffff5c01611e c78584feffffb5dcfc68 c78588feffff6ce7a33a c7858cfeffffafe2e55a c78590feffff74c31dff c78594feffff657f9183 }
            // n = 7, score = 300
            //   c7857cfeffff36a54e6b     | mov    dword ptr [ebp - 0x184], 0x6b4ea536
            //   c78580feffff5c01611e     | mov    dword ptr [ebp - 0x180], 0x1e61015c
            //   c78584feffffb5dcfc68     | mov    dword ptr [ebp - 0x17c], 0x68fcdcb5
            //   c78588feffff6ce7a33a     | mov    dword ptr [ebp - 0x178], 0x3aa3e76c
            //   c7858cfeffffafe2e55a     | mov    dword ptr [ebp - 0x174], 0x5ae5e2af
            //   c78590feffff74c31dff     | mov    dword ptr [ebp - 0x170], 0xff1dc374
            //   c78594feffff657f9183     | mov    dword ptr [ebp - 0x16c], 0x83917f65

        $sequence_4 = { c78514fdffff7532479f c78518fdffffe35bc9c0 c7851cfdfffffc9c461f c78520fdffff9821ddfa c78524fdffff589a8f7a }
            // n = 5, score = 300
            //   c78514fdffff7532479f     | mov    dword ptr [ebp - 0x2ec], 0x9f473275
            //   c78518fdffffe35bc9c0     | mov    dword ptr [ebp - 0x2e8], 0xc0c95be3
            //   c7851cfdfffffc9c461f     | mov    dword ptr [ebp - 0x2e4], 0x1f469cfc
            //   c78520fdffff9821ddfa     | mov    dword ptr [ebp - 0x2e0], 0xfadd2198
            //   c78524fdffff589a8f7a     | mov    dword ptr [ebp - 0x2dc], 0x7a8f9a58

        $sequence_5 = { c78554feffffa14b0c27 c78558feffff10c0aac6 c7855cfeffff489a8471 c78560feffff9cab4ad6 c78564feffff67cf2900 c78568feffff02dbaeb5 }
            // n = 6, score = 300
            //   c78554feffffa14b0c27     | mov    dword ptr [ebp - 0x1ac], 0x270c4ba1
            //   c78558feffff10c0aac6     | mov    dword ptr [ebp - 0x1a8], 0xc6aac010
            //   c7855cfeffff489a8471     | mov    dword ptr [ebp - 0x1a4], 0x71849a48
            //   c78560feffff9cab4ad6     | mov    dword ptr [ebp - 0x1a0], 0xd64aab9c
            //   c78564feffff67cf2900     | mov    dword ptr [ebp - 0x19c], 0x29cf67
            //   c78568feffff02dbaeb5     | mov    dword ptr [ebp - 0x198], 0xb5aedb02

        $sequence_6 = { 83c40c 85f6 741f 68???????? 68???????? 6a00 }
            // n = 6, score = 300
            //   83c40c               | add                 esp, 0xc
            //   85f6                 | test                esi, esi
            //   741f                 | je                  0x21
            //   68????????           |                     
            //   68????????           |                     
            //   6a00                 | push                0

        $sequence_7 = { c78504fdfffff79d6681 c78508fdffffbfa7f8a5 c7850cfdffffa0118db8 c78510fdffff4d3feb78 }
            // n = 4, score = 300
            //   c78504fdfffff79d6681     | mov    dword ptr [ebp - 0x2fc], 0x81669df7
            //   c78508fdffffbfa7f8a5     | mov    dword ptr [ebp - 0x2f8], 0xa5f8a7bf
            //   c7850cfdffffa0118db8     | mov    dword ptr [ebp - 0x2f4], 0xb88d11a0
            //   c78510fdffff4d3feb78     | mov    dword ptr [ebp - 0x2f0], 0x78eb3f4d

        $sequence_8 = { 8bca e8???????? 85c0 7409 e8???????? }
            // n = 5, score = 200
            //   8bca                 | mov                 ecx, edx
            //   e8????????           |                     
            //   85c0                 | test                eax, eax
            //   7409                 | je                  0xb
            //   e8????????           |                     

        $sequence_9 = { 99 f7fe 8bca e8???????? }
            // n = 4, score = 200
            //   99                   | cdq                 
            //   f7fe                 | idiv                esi
            //   8bca                 | mov                 ecx, edx
            //   e8????????           |                     

        $sequence_10 = { b990190000 66394802 7574 488b35???????? 33d2 }
            // n = 5, score = 100
            //   b990190000           | xor                 eax, dword ptr [ebp + 0x1c]
            //   66394802             | inc                 ecx
            //   7574                 | mov                 eax, eax
            //   488b35????????       |                     
            //   33d2                 | shr                 eax, 0x10

        $sequence_11 = { 488bd3 ff15???????? 4c21642438 4c21642430 895c2428 83cbff }
            // n = 6, score = 100
            //   488bd3               | mov                 edx, 0x100
            //   ff15????????         |                     
            //   4c21642438           | dec                 eax
            //   4c21642430           | mov                 edx, ebx
            //   895c2428             | dec                 esp
            //   83cbff               | and                 dword ptr [esp + 0x38], esp

        $sequence_12 = { 4c8bc9 753b 0fb789a8040000 b8bb010000 ba00010000 }
            // n = 5, score = 100
            //   4c8bc9               | dec                 esp
            //   753b                 | mov                 ecx, ecx
            //   0fb789a8040000       | jne                 0x3d
            //   b8bb010000           | movzx               ecx, word ptr [ecx + 0x4a8]
            //   ba00010000           | mov                 eax, 0x1bb

        $sequence_13 = { 488d4dd0 ff15???????? 488d55b8 488d4dd0 ff15???????? f20f102d???????? }
            // n = 6, score = 100
            //   488d4dd0             | inc                 ebp
            //   ff15????????         |                     
            //   488d55b8             | xor                 eax, dword ptr [esp + eax*4 + 0x1cb10]
            //   488d4dd0             | inc                 ebp
            //   ff15????????         |                     
            //   f20f102d????????     |                     

        $sequence_14 = { 4533848410cb0100 4533451c 418bc0 c1e810 }
            // n = 4, score = 100
            //   4533848410cb0100     | dec                 esp
            //   4533451c             | and                 dword ptr [esp + 0x30], esp
            //   418bc0               | mov                 dword ptr [esp + 0x28], ebx
            //   c1e810               | or                  ebx, 0xffffffff

        $sequence_15 = { 488bf8 483bc3 7423 448d4e81 448d4684 488d542440 }
            // n = 6, score = 100
            //   488bf8               | dec                 eax
            //   483bc3               | lea                 ecx, [ebp - 0x30]
            //   7423                 | dec                 eax
            //   448d4e81             | lea                 edx, [ebp - 0x48]
            //   448d4684             | dec                 eax
            //   488d542440           | lea                 ecx, [ebp - 0x30]

    condition:
        7 of them and filesize < 363520
}