rule win_blister_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2026-01-05"
        version = "1"
        description = "Detects win.blister."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.blister"
        malpedia_rule_date = "20260105"
        malpedia_hash = "19b79e7cab4eaf532122e5b45a77dd8f6bb5cc79"
        malpedia_version = "20251219"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 53 8b5d10 56 8b750c 57 33ff 6a02 }
            // n = 7, score = 100
            //   53                   | push                ebx
            //   8b5d10               | mov                 ebx, dword ptr [ebp + 0x10]
            //   56                   | push                esi
            //   8b750c               | mov                 esi, dword ptr [ebp + 0xc]
            //   57                   | push                edi
            //   33ff                 | xor                 edi, edi
            //   6a02                 | push                2

        $sequence_1 = { 50 c745c03c000000 c745c400020000 c745cce4301717 c745dc05000000 ff15???????? }
            // n = 6, score = 100
            //   50                   | push                eax
            //   c745c03c000000       | mov                 dword ptr [ebp - 0x40], 0x3c
            //   c745c400020000       | mov                 dword ptr [ebp - 0x3c], 0x200
            //   c745cce4301717       | mov                 dword ptr [ebp - 0x34], 0x171730e4
            //   c745dc05000000       | mov                 dword ptr [ebp - 0x24], 5
            //   ff15????????         |                     

        $sequence_2 = { 7507 bf0e000780 eb34 8365f400 ff750c 33c0 }
            // n = 6, score = 100
            //   7507                 | jne                 9
            //   bf0e000780           | mov                 edi, 0x8007000e
            //   eb34                 | jmp                 0x36
            //   8365f400             | and                 dword ptr [ebp - 0xc], 0
            //   ff750c               | push                dword ptr [ebp + 0xc]
            //   33c0                 | xor                 eax, eax

        $sequence_3 = { 7d06 33c0 33ff eb03 8b45f4 8945fc }
            // n = 6, score = 100
            //   7d06                 | jge                 8
            //   33c0                 | xor                 eax, eax
            //   33ff                 | xor                 edi, edi
            //   eb03                 | jmp                 5
            //   8b45f4               | mov                 eax, dword ptr [ebp - 0xc]
            //   8945fc               | mov                 dword ptr [ebp - 4], eax

        $sequence_4 = { 50 8d8584fcffff 50 ffb580fcffff 8d856cfcffff ffb578fcffff 50 }
            // n = 7, score = 100
            //   50                   | push                eax
            //   8d8584fcffff         | lea                 eax, [ebp - 0x37c]
            //   50                   | push                eax
            //   ffb580fcffff         | push                dword ptr [ebp - 0x380]
            //   8d856cfcffff         | lea                 eax, [ebp - 0x394]
            //   ffb578fcffff         | push                dword ptr [ebp - 0x388]
            //   50                   | push                eax

        $sequence_5 = { ff32 ff15???????? 83f8ff 7507 b805400080 eb02 33c0 }
            // n = 7, score = 100
            //   ff32                 | push                dword ptr [edx]
            //   ff15????????         |                     
            //   83f8ff               | cmp                 eax, -1
            //   7507                 | jne                 9
            //   b805400080           | mov                 eax, 0x80004005
            //   eb02                 | jmp                 4
            //   33c0                 | xor                 eax, eax

        $sequence_6 = { ff7508 6813100000 ff36 ffd7 6a03 58 8945d4 }
            // n = 7, score = 100
            //   ff7508               | push                dword ptr [ebp + 8]
            //   6813100000           | push                0x1013
            //   ff36                 | push                dword ptr [esi]
            //   ffd7                 | call                edi
            //   6a03                 | push                3
            //   58                   | pop                 eax
            //   8945d4               | mov                 dword ptr [ebp - 0x2c], eax

        $sequence_7 = { e8???????? 57 8bce 894508 e8???????? 5f 5e }
            // n = 7, score = 100
            //   e8????????           |                     
            //   57                   | push                edi
            //   8bce                 | mov                 ecx, esi
            //   894508               | mov                 dword ptr [ebp + 8], eax
            //   e8????????           |                     
            //   5f                   | pop                 edi
            //   5e                   | pop                 esi

        $sequence_8 = { 85f6 7507 b857000780 eb45 832600 6a38 8d45c8 }
            // n = 7, score = 100
            //   85f6                 | test                esi, esi
            //   7507                 | jne                 9
            //   b857000780           | mov                 eax, 0x80070057
            //   eb45                 | jmp                 0x47
            //   832600               | and                 dword ptr [esi], 0
            //   6a38                 | push                0x38
            //   8d45c8               | lea                 eax, [ebp - 0x38]

        $sequence_9 = { e8???????? 8bce e8???????? 8bd8 85db 7d0f }
            // n = 6, score = 100
            //   e8????????           |                     
            //   8bce                 | mov                 ecx, esi
            //   e8????????           |                     
            //   8bd8                 | mov                 ebx, eax
            //   85db                 | test                ebx, ebx
            //   7d0f                 | jge                 0x11

    condition:
        7 of them and filesize < 1822720
}